/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.userdefinedjavaclass;

import org.pentaho.di.core.exception.KettleStepException;

public class UserDefinedJavaClassDef
implements Cloneable {
    private ClassType classType;
    private boolean classActive;
    private String className;
    private String source;
    private static final String CONSTRUCTOR = "\n\npublic %s(UserDefinedJavaClass parent, UserDefinedJavaClassMeta meta, UserDefinedJavaClassData data) throws KettleStepException { super(parent,meta,data);}";

    public UserDefinedJavaClassDef(ClassType classType, String className, String source) {
        this.classType = classType;
        this.className = className;
        this.source = source;
        this.classActive = true;
    }

    public ClassType getClassType() {
        return this.classType;
    }

    public void setClassType(ClassType classType) {
        this.classType = classType;
    }

    public String getSource() {
        return this.source;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String getTransformedSource() throws KettleStepException {
        StringBuilder sb = new StringBuilder(this.getSource());
        this.appendConstructor(sb);
        return sb.toString();
    }

    public void setSource(String source) {
        this.source = source;
    }

    private void appendConstructor(StringBuilder sb) {
        sb.append(String.format(CONSTRUCTOR, this.className));
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public boolean isTransformClass() {
        return this.classActive && this.classType == ClassType.TRANSFORM_CLASS;
    }

    public void setActive(boolean classActive) {
        this.classActive = classActive;
    }

    public boolean isActive() {
        return this.classActive;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ClassType {
        NORMAL_CLASS,
        TRANSFORM_CLASS;

    }
}

