/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.webservices.wsdl;

import com.ibm.wsdl.extensions.soap12.SOAP12BodyImpl;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Port;
import javax.wsdl.extensions.ElementExtensible;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.wsdl.extensions.soap12.SOAP12Address;
import javax.wsdl.extensions.soap12.SOAP12Binding;
import javax.wsdl.extensions.soap12.SOAP12Header;
import javax.wsdl.extensions.soap12.SOAP12Operation;
import org.pentaho.di.core.exception.KettleException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class WsdlUtils {
    private static final String SOAP_PORT_ADDRESS_NAME = "address";
    private static final String SOAP_BINDING_ELEMENT_NAME = "binding";
    private static final String SOAP_BODY_ELEMENT_NAME = "body";
    private static final String SOAP_HEADER_ELEMENT_NAME = "header";
    private static final String SOAP_OPERATION_ELEMENT_NAME = "operation";
    private static final String SOAP_BINDING_DEFAULT = "document";
    protected static final String ELEMENT_FORM_DEFAULT_ATTR = "elementFormDefault";
    protected static final String ANY_TAG_NAME = "any";
    protected static final String TARGET_NAMESPACE_ATTR = "targetNamespace";
    protected static final String ELEMENT_FORM_QUALIFIED = "qualified";
    protected static final String ELEMENT_NAME = "element";
    protected static final String COMPLEX_TYPE_NAME = "complexType";
    protected static final String SCHEMA_ELEMENT_NAME = "schema";
    protected static final String SEQUENCE_TAG_NAME = "sequence";
    protected static final String SIMPLE_TYPE_NAME = "simpleType";
    protected static final String NAME_ATTR = "name";
    protected static final String ELEMENT_TYPE_ATTR = "type";
    protected static final String ELEMENT_REF_ATTR = "ref";
    protected static final String MAXOCCURS_ATTR = "maxOccurs";
    protected static final String MINOCCURS_ATTR = "minOccurs";

    WsdlUtils() {
    }

    protected static String getSOAPAddress(Port p) {
        ExtensibilityElement e = WsdlUtils.findExtensibilityElement((ElementExtensible)p, SOAP_PORT_ADDRESS_NAME);
        if (e instanceof SOAP12Address) {
            return ((SOAP12Address)e).getLocationURI();
        }
        if (e instanceof SOAPAddress) {
            return ((SOAPAddress)e).getLocationURI();
        }
        return null;
    }

    protected static String getSOAPBindingStyle(Binding binding) throws KettleException {
        String style = SOAP_BINDING_DEFAULT;
        ExtensibilityElement soapBindingElem = WsdlUtils.findExtensibilityElement((ElementExtensible)binding, SOAP_BINDING_ELEMENT_NAME);
        if (soapBindingElem != null) {
            if (soapBindingElem instanceof SOAP12Binding) {
                style = ((SOAP12Binding)soapBindingElem).getStyle();
            } else if (soapBindingElem instanceof SOAPBinding) {
                style = ((SOAPBinding)soapBindingElem).getStyle();
            } else {
                throw new KettleException("Binding type " + soapBindingElem + " encountered. The Web Service Lookup step only supports SOAP Bindings!");
            }
        }
        return style;
    }

    protected static String getSOAPBindingUse(Binding binding, String operationName) {
        ExtensibilityElement soapBodyElem;
        ExtensibilityElement soapBodyElem2;
        BindingOperation bindingOperation = binding.getBindingOperation(operationName, null, null);
        if (bindingOperation == null) {
            throw new IllegalArgumentException("Can not find operation: " + operationName);
        }
        BindingInput bindingInput = bindingOperation.getBindingInput();
        if (bindingInput != null && (soapBodyElem2 = WsdlUtils.findExtensibilityElement((ElementExtensible)bindingInput, SOAP_BODY_ELEMENT_NAME)) != null) {
            if (soapBodyElem2 instanceof SOAP12BodyImpl) {
                return ((SOAP12BodyImpl)soapBodyElem2).getUse();
            }
            return ((SOAPBody)soapBodyElem2).getUse();
        }
        BindingOutput bindingOutput = bindingOperation.getBindingOutput();
        if (bindingOutput != null && (soapBodyElem = WsdlUtils.findExtensibilityElement((ElementExtensible)bindingOutput, SOAP_BODY_ELEMENT_NAME)) != null) {
            if (soapBodyElem instanceof SOAP12BodyImpl) {
                return ((SOAP12BodyImpl)soapBodyElem).getUse();
            }
            return ((SOAPBody)soapBodyElem).getUse();
        }
        throw new RuntimeException("Unable to determine SOAP use for operation: " + operationName);
    }

    protected static String getSOAPAction(BindingOperation operation) {
        ExtensibilityElement e = WsdlUtils.findExtensibilityElement((ElementExtensible)operation, SOAP_OPERATION_ELEMENT_NAME);
        if (e != null) {
            if (e instanceof SOAP12Operation) {
                return ((SOAP12Operation)e).getSoapActionURI();
            }
            return ((SOAPOperation)e).getSoapActionURI();
        }
        return null;
    }

    protected static boolean isWrappedParameterStyle(String operationName, boolean outputParam, String messagePartName) {
        return !(outputParam ? messagePartName.equals(operationName + "Response") : messagePartName.equals(operationName));
    }

    protected static HashSet<String> getSOAPHeaders(Binding binding, String operationName) {
        BindingOutput bindingOutput;
        ArrayList<ExtensibilityElement> headers = new ArrayList<ExtensibilityElement>();
        BindingOperation bindingOperation = binding.getBindingOperation(operationName, null, null);
        if (bindingOperation == null) {
            throw new IllegalArgumentException("Can not find operation: " + operationName);
        }
        BindingInput bindingInput = bindingOperation.getBindingInput();
        if (bindingInput != null) {
            headers.addAll(WsdlUtils.findExtensibilityElements((ElementExtensible)bindingInput, SOAP_HEADER_ELEMENT_NAME));
        }
        if ((bindingOutput = bindingOperation.getBindingOutput()) != null) {
            headers.addAll(WsdlUtils.findExtensibilityElements((ElementExtensible)bindingOutput, SOAP_HEADER_ELEMENT_NAME));
        }
        HashSet<String> headerSet = new HashSet<String>(headers.size());
        for (ExtensibilityElement element : headers) {
            if (element instanceof SOAP12Header) {
                headerSet.add(((SOAP12Header)element).getPart());
                continue;
            }
            headerSet.add(((SOAPHeader)element).getPart());
        }
        return headerSet;
    }

    protected static ExtensibilityElement findExtensibilityElement(ElementExtensible extensibleElement, String elementType) {
        List extensibilityElements = extensibleElement.getExtensibilityElements();
        if (extensibilityElements != null) {
            for (ExtensibilityElement element : extensibilityElements) {
                if (!element.getElementType().getLocalPart().equalsIgnoreCase(elementType)) continue;
                return element;
            }
        }
        return null;
    }

    protected static List<ExtensibilityElement> findExtensibilityElements(ElementExtensible extensibleElement, String elementType) {
        ArrayList<ExtensibilityElement> elements = new ArrayList<ExtensibilityElement>();
        List extensibilityElements = extensibleElement.getExtensibilityElements();
        if (extensibilityElements != null) {
            for (ExtensibilityElement element : extensibilityElements) {
                if (!element.getElementType().getLocalPart().equalsIgnoreCase(elementType)) continue;
                elements.add(element);
            }
        }
        return elements;
    }

    protected static boolean isSoapPort(Port port) {
        return WsdlUtils.getSOAPAddress(port) != null;
    }
}

