/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.xmlinput;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.vfs.FileObject;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.fileinput.FileInputList;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceDefinition;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceNamingInterface;
import org.pentaho.di.resource.ResourceReference;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.xmlinput.XMLInput;
import org.pentaho.di.trans.steps.xmlinput.XMLInputData;
import org.pentaho.di.trans.steps.xmlinput.XMLInputField;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLInputMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = XMLInputMeta.class;
    private String[] fileName;
    private String[] fileMask;
    private boolean includeFilename;
    private String filenameField;
    private boolean includeRowNumber;
    private String rowNumberField;
    private long rowLimit;
    private int nrRowsToSkip;
    private boolean namespaceAware;
    private boolean ignoreEntities;
    private String fileBaseURI;
    private XMLInputField[] inputFields;
    private String[] inputPosition;

    public XMLInputField[] getInputFields() {
        return this.inputFields;
    }

    public void setInputFields(XMLInputField[] inputFields) {
        this.inputFields = inputFields;
    }

    public String[] getFileMask() {
        return this.fileMask;
    }

    public void setFileMask(String[] fileMask) {
        this.fileMask = fileMask;
    }

    public String[] getFileName() {
        return this.fileName;
    }

    public void setFileName(String[] fileName) {
        this.fileName = fileName;
    }

    public String getFilenameField() {
        return this.filenameField;
    }

    public void setFilenameField(String filenameField) {
        this.filenameField = filenameField;
    }

    public boolean includeFilename() {
        return this.includeFilename;
    }

    public void setIncludeFilename(boolean includeFilename) {
        this.includeFilename = includeFilename;
    }

    public boolean includeRowNumber() {
        return this.includeRowNumber;
    }

    public void setIncludeRowNumber(boolean includeRowNumber) {
        this.includeRowNumber = includeRowNumber;
    }

    public long getRowLimit() {
        return this.rowLimit;
    }

    public void setRowLimit(long rowLimit) {
        this.rowLimit = rowLimit;
    }

    public int getNrRowsToSkip() {
        return this.nrRowsToSkip;
    }

    public void setNrRowsToSkip(int nrRowsToSkip) {
        this.nrRowsToSkip = nrRowsToSkip;
    }

    public String getRowNumberField() {
        return this.rowNumberField;
    }

    public void setRowNumberField(String rowNumberField) {
        this.rowNumberField = rowNumberField;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        this.readData(stepnode);
    }

    @Override
    public Object clone() {
        int i;
        XMLInputMeta retval = (XMLInputMeta)super.clone();
        int nrFiles = this.fileName.length;
        int nrFields = this.inputFields.length;
        int nrPositions = this.inputPosition.length;
        retval.allocate(nrFiles, nrFields, nrPositions);
        for (i = 0; i < nrFields; ++i) {
            if (this.inputFields[i] == null) continue;
            retval.inputFields[i] = (XMLInputField)this.inputFields[i].clone();
        }
        for (i = 0; i < nrPositions; ++i) {
            retval.inputPosition[i] = this.inputPosition[i];
        }
        return retval;
    }

    @Override
    public String getXML() {
        int i;
        StringBuffer retval = new StringBuffer();
        retval.append("    " + XMLHandler.addTagValue((String)"include", (boolean)this.includeFilename));
        retval.append("    " + XMLHandler.addTagValue((String)"include_field", (String)this.filenameField));
        retval.append("    " + XMLHandler.addTagValue((String)"rownum", (boolean)this.includeRowNumber));
        retval.append("    " + XMLHandler.addTagValue((String)"rownum_field", (String)this.rowNumberField));
        retval.append("    " + XMLHandler.addTagValue((String)"file_base_uri", (String)this.fileBaseURI));
        retval.append("    " + XMLHandler.addTagValue((String)"ignore_entities", (boolean)this.ignoreEntities));
        retval.append("    " + XMLHandler.addTagValue((String)"namespace_aware", (boolean)this.namespaceAware));
        retval.append("    <file>" + Const.CR);
        for (i = 0; i < this.fileName.length; ++i) {
            retval.append("      " + XMLHandler.addTagValue((String)"name", (String)this.fileName[i]));
            retval.append("      " + XMLHandler.addTagValue((String)"filemask", (String)this.fileMask[i]));
        }
        retval.append("      </file>" + Const.CR);
        retval.append("    <fields>" + Const.CR);
        for (i = 0; i < this.inputFields.length; ++i) {
            XMLInputField field = this.inputFields[i];
            retval.append(field.getXML());
        }
        retval.append("      </fields>" + Const.CR);
        retval.append("    <positions>" + Const.CR);
        for (i = 0; i < this.inputPosition.length; ++i) {
            retval.append("      " + XMLHandler.addTagValue((String)"position", (String)this.inputPosition[i]));
        }
        retval.append("      </positions>" + Const.CR);
        retval.append("    " + XMLHandler.addTagValue((String)"limit", (long)this.rowLimit));
        retval.append("    " + XMLHandler.addTagValue((String)"skip", (int)this.nrRowsToSkip));
        return retval.toString();
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            int i;
            this.includeFilename = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"include"));
            this.filenameField = XMLHandler.getTagValue((Node)stepnode, (String)"include_field");
            this.includeRowNumber = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"rownum"));
            this.rowNumberField = XMLHandler.getTagValue((Node)stepnode, (String)"rownum_field");
            this.fileBaseURI = XMLHandler.getTagValue((Node)stepnode, (String)"file_base_uri");
            this.ignoreEntities = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"ignore_entities"));
            this.namespaceAware = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"namespace_aware"));
            Node filenode = XMLHandler.getSubNode((Node)stepnode, (String)"file");
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            Node positions = XMLHandler.getSubNode((Node)stepnode, (String)"positions");
            int nrFiles = XMLHandler.countNodes((Node)filenode, (String)"name");
            int nrFields = XMLHandler.countNodes((Node)fields, (String)"field");
            int nrPositions = XMLHandler.countNodes((Node)positions, (String)"position");
            this.allocate(nrFiles, nrFields, nrPositions);
            for (i = 0; i < nrFiles; ++i) {
                Node filenamenode = XMLHandler.getSubNodeByNr((Node)filenode, (String)"name", (int)i);
                Node filemasknode = XMLHandler.getSubNodeByNr((Node)filenode, (String)"filemask", (int)i);
                this.fileName[i] = XMLHandler.getNodeValue((Node)filenamenode);
                this.fileMask[i] = XMLHandler.getNodeValue((Node)filemasknode);
            }
            for (i = 0; i < nrFields; ++i) {
                XMLInputField field;
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.inputFields[i] = field = new XMLInputField(fnode);
            }
            for (i = 0; i < nrPositions; ++i) {
                Node positionnode = XMLHandler.getSubNodeByNr((Node)positions, (String)"position", (int)i);
                this.inputPosition[i] = XMLHandler.getNodeValue((Node)positionnode);
            }
            this.rowLimit = Const.toLong((String)XMLHandler.getTagValue((Node)stepnode, (String)"limit"), (long)0L);
            this.nrRowsToSkip = Const.toInt((String)XMLHandler.getTagValue((Node)stepnode, (String)"skip"), (int)0);
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to load step info from XML", (Throwable)e);
        }
    }

    public void allocate(int nrfiles, int nrfields, int nrPositions) {
        this.fileName = new String[nrfiles];
        this.fileMask = new String[nrfiles];
        this.inputFields = new XMLInputField[nrfields];
        this.inputPosition = new String[nrPositions];
    }

    @Override
    public void setDefault() {
        int i;
        this.includeFilename = false;
        this.filenameField = "";
        this.includeRowNumber = false;
        this.rowNumberField = "";
        this.fileBaseURI = "";
        this.ignoreEntities = false;
        this.namespaceAware = false;
        int nrFiles = 0;
        int nrFields = 0;
        int nrPositions = 0;
        this.allocate(nrFiles, nrFields, nrPositions);
        for (i = 0; i < nrFiles; ++i) {
            this.fileName[i] = "filename" + (i + 1);
            this.fileMask[i] = "";
        }
        for (i = 0; i < nrFields; ++i) {
            this.inputFields[i] = new XMLInputField("field" + (i + 1), null);
        }
        for (i = 0; i < nrPositions; ++i) {
            this.inputPosition[i] = "position" + (i + 1);
        }
        this.rowLimit = 0L;
        this.nrRowsToSkip = 0;
    }

    @Override
    public void getFields(RowMetaInterface r, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space) {
        for (int i = 0; i < this.inputFields.length; ++i) {
            XMLInputField field = this.inputFields[i];
            int type = field.getType();
            if (type == 0) {
                type = 2;
            }
            ValueMeta v = new ValueMeta(field.getName(), type);
            v.setLength(field.getLength(), field.getPrecision());
            v.setConversionMask(field.getFormat());
            v.setDecimalSymbol(field.getDecimalSymbol());
            v.setGroupingSymbol(field.getGroupSymbol());
            v.setTrimType(field.getTrimType());
            v.setCurrencySymbol(field.getCurrencySymbol());
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
        if (this.includeFilename) {
            ValueMeta v = new ValueMeta(this.filenameField, 2);
            v.setLength(100);
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
        if (this.includeRowNumber) {
            ValueMeta v = new ValueMeta(this.rowNumberField, 5);
            v.setLength(10);
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
    }

    @Override
    public void readRep(Repository rep, ObjectId id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        try {
            int i;
            this.includeFilename = rep.getStepAttributeBoolean(id_step, "include");
            this.filenameField = rep.getStepAttributeString(id_step, "include_field");
            this.includeRowNumber = rep.getStepAttributeBoolean(id_step, "rownum");
            this.rowNumberField = rep.getStepAttributeString(id_step, "rownum_field");
            this.rowLimit = rep.getStepAttributeInteger(id_step, "limit");
            this.nrRowsToSkip = (int)rep.getStepAttributeInteger(id_step, "skip");
            this.fileBaseURI = rep.getStepAttributeString(id_step, "file_base_uri");
            this.ignoreEntities = rep.getStepAttributeBoolean(id_step, "ignore_entities");
            this.namespaceAware = rep.getStepAttributeBoolean(id_step, "namespace_aware");
            int nrFiles = rep.countNrStepAttributes(id_step, "file_name");
            int nrFields = rep.countNrStepAttributes(id_step, "field_name");
            int nrPositions = rep.countNrStepAttributes(id_step, "input_position");
            this.allocate(nrFiles, nrFields, nrPositions);
            for (i = 0; i < nrFiles; ++i) {
                this.fileName[i] = rep.getStepAttributeString(id_step, i, "file_name");
                this.fileMask[i] = rep.getStepAttributeString(id_step, i, "file_mask");
            }
            for (i = 0; i < nrFields; ++i) {
                XMLInputField field = new XMLInputField();
                field.setName(rep.getStepAttributeString(id_step, i, "field_name"));
                field.setType(ValueMeta.getType((String)rep.getStepAttributeString(id_step, i, "field_type")));
                field.setFormat(rep.getStepAttributeString(id_step, i, "field_format"));
                field.setCurrencySymbol(rep.getStepAttributeString(id_step, i, "field_currency"));
                field.setDecimalSymbol(rep.getStepAttributeString(id_step, i, "field_decimal"));
                field.setGroupSymbol(rep.getStepAttributeString(id_step, i, "field_group"));
                field.setLength((int)rep.getStepAttributeInteger(id_step, i, "field_length"));
                field.setPrecision((int)rep.getStepAttributeInteger(id_step, i, "field_precision"));
                field.setTrimType(XMLInputField.getTrimTypeByCode(rep.getStepAttributeString(id_step, i, "field_trim_type")));
                field.setRepeated(rep.getStepAttributeBoolean(id_step, i, "field_repeat"));
                String fieldPositionCode = rep.getStepAttributeString(id_step, i, "field_position_code");
                if (fieldPositionCode != null) {
                    field.setFieldPosition(fieldPositionCode);
                }
                this.inputFields[i] = field;
            }
            for (i = 0; i < nrPositions; ++i) {
                this.inputPosition[i] = rep.getStepAttributeString(id_step, i, "input_position");
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"XMLInputMeta.Exception.ErrorReadingRepository", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            int i;
            rep.saveStepAttribute(id_transformation, id_step, "include", this.includeFilename);
            rep.saveStepAttribute(id_transformation, id_step, "include_field", this.filenameField);
            rep.saveStepAttribute(id_transformation, id_step, "rownum", this.includeRowNumber);
            rep.saveStepAttribute(id_transformation, id_step, "rownum_field", this.rowNumberField);
            rep.saveStepAttribute(id_transformation, id_step, "limit", this.rowLimit);
            rep.saveStepAttribute(id_transformation, id_step, "skip", this.nrRowsToSkip);
            rep.saveStepAttribute(id_transformation, id_step, "file_base_uri", this.fileBaseURI);
            rep.saveStepAttribute(id_transformation, id_step, "ignore_entities", this.ignoreEntities);
            rep.saveStepAttribute(id_transformation, id_step, "namespace_aware", this.namespaceAware);
            for (i = 0; i < this.fileName.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "file_name", this.fileName[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "file_mask", this.fileMask[i]);
            }
            for (i = 0; i < this.inputFields.length; ++i) {
                XMLInputField field = this.inputFields[i];
                rep.saveStepAttribute(id_transformation, id_step, i, "field_name", field.getName());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_type", field.getTypeDesc());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_format", field.getFormat());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_currency", field.getCurrencySymbol());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_decimal", field.getDecimalSymbol());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_group", field.getGroupSymbol());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_length", field.getLength());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_precision", field.getPrecision());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_trim_type", field.getTrimTypeCode());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_repeat", field.isRepeated());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_position_code", field.getFieldPositionsCode());
            }
            for (i = 0; i < this.inputPosition.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "input_position", this.inputPosition[i]);
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"XMLInputMeta.Exception.ErrorSavingToRepository", (String[])new String[]{"" + id_step}), (Throwable)e);
        }
    }

    public FileInputList getFiles(VariableSpace space) {
        String[] required = new String[this.fileName.length];
        boolean[] subdirs = new boolean[this.fileName.length];
        for (int i = 0; i < required.length; ++i) {
            required[i] = "Y";
        }
        return FileInputList.createFileList((VariableSpace)space, (String[])this.fileName, (String[])this.fileMask, (String[])required, (boolean[])subdirs);
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepinfo, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        CheckResult cr;
        if (input.length > 0) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"XMLInputMeta.CheckResult.NoInputExpected", (String[])new String[0]), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"XMLInputMeta.CheckResult.NoInput", (String[])new String[0]), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        }
        FileInputList fileInputList = this.getFiles(transMeta);
        if (fileInputList == null || fileInputList.getFiles().size() == 0) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"XMLInputMeta.CheckResult.NoFiles", (String[])new String[0]), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"XMLInputMeta.CheckResult.FilesOk", (String[])new String[]{"" + fileInputList.getFiles().size()}), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new XMLInput(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new XMLInputData();
    }

    public String[] getInputPosition() {
        return this.inputPosition;
    }

    @Override
    public List<ResourceReference> getResourceDependencies(TransMeta transMeta, StepMeta stepInfo) {
        ArrayList<ResourceReference> references = new ArrayList<ResourceReference>(5);
        ResourceReference reference = new ResourceReference(stepInfo);
        references.add(reference);
        String[] required = new String[this.fileName.length];
        boolean[] subdirs = new boolean[this.fileName.length];
        for (int i = 0; i < required.length; ++i) {
            required[i] = "N";
        }
        String[] textFiles = FileInputList.createFilePathList((VariableSpace)transMeta, (String[])this.fileName, (String[])this.fileMask, (String[])new String[]{null}, (String[])required, (boolean[])subdirs);
        if (textFiles != null) {
            for (int i = 0; i < textFiles.length; ++i) {
                reference.getEntries().add(new ResourceEntry(textFiles[i], ResourceEntry.ResourceType.FILE));
            }
        }
        return references;
    }

    public void setInputPosition(String[] inputPosition) {
        this.inputPosition = inputPosition;
    }

    public String getFileBaseURI() {
        return this.fileBaseURI;
    }

    public void setFileBaseURI(String fileBaseURI) {
        this.fileBaseURI = fileBaseURI;
    }

    public boolean isIgnoreEntities() {
        return this.ignoreEntities;
    }

    public void setIgnoreEntities(boolean ignoreEntities) {
        this.ignoreEntities = ignoreEntities;
    }

    public boolean isNamespaceAware() {
        return this.namespaceAware;
    }

    public void setNamespaceAware(boolean namespaceAware) {
        this.namespaceAware = namespaceAware;
    }

    @Override
    public String exportResources(VariableSpace space, Map<String, ResourceDefinition> definitions, ResourceNamingInterface resourceNamingInterface, Repository repository) throws KettleException {
        try {
            for (int i = 0; i < this.fileName.length; ++i) {
                FileObject fileObject = KettleVFS.getFileObject((String)space.environmentSubstitute(this.fileName[i]), (VariableSpace)space);
                this.fileName[i] = resourceNamingInterface.nameResource(fileObject, space, Const.isEmpty((String)this.fileMask[i]));
            }
            return null;
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
    }
}

