/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.xmlinputstream;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.io.FileUtils;
import org.apache.commons.vfs.FileSystemException;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.xmlinputstream.XMLInputStreamData;
import org.pentaho.di.trans.steps.xmlinputstream.XMLInputStreamMeta;

public class XMLInputStream
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = XMLInputStream.class;
    private static int PARENT_ID_ALLOCATE_SIZE = 1000;
    private XMLInputStreamMeta meta;
    private XMLInputStreamData data;
    static final String[] eventDescription = new String[]{"UNKNOWN", "START_ELEMENT", "END_ELEMENT", "PROCESSING_INSTRUCTION", "CHARACTERS", "COMMENT", "SPACE", "START_DOCUMENT", "END_DOCUMENT", "ENTITY_REFERENCE", "ATTRIBUTE", "DTD", "CDATA", "NAMESPACE", "NOTATION_DECLARATION", "ENTITY_DECLARATION"};

    public XMLInputStream(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        Object[] outputRowData;
        if (this.first) {
            this.first = false;
            this.data.filename = this.environmentSubstitute(this.meta.getFilename());
            this.data.nrRowsToSkip = Const.toLong((String)this.environmentSubstitute(this.meta.getNrRowsToSkip()), (long)0L);
            this.data.rowLimit = Const.toLong((String)this.environmentSubstitute(this.meta.getRowLimit()), (long)0L);
            this.data.encoding = this.environmentSubstitute(this.meta.getEncoding());
            this.data.outputRowMeta = new RowMeta();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this);
            this.data.pos_xml_filename = this.data.outputRowMeta.indexOfValue(this.meta.getFilenameField());
            this.data.pos_xml_row_number = this.data.outputRowMeta.indexOfValue(this.meta.getRowNumberField());
            this.data.pos_xml_data_type_numeric = this.data.outputRowMeta.indexOfValue(this.meta.getXmlDataTypeNumericField());
            this.data.pos_xml_data_type_description = this.data.outputRowMeta.indexOfValue(this.meta.getXmlDataTypeDescriptionField());
            this.data.pos_xml_location_line = this.data.outputRowMeta.indexOfValue(this.meta.getXmlLocationLineField());
            this.data.pos_xml_location_column = this.data.outputRowMeta.indexOfValue(this.meta.getXmlLocationColumnField());
            this.data.pos_xml_element_id = this.data.outputRowMeta.indexOfValue(this.meta.getXmlElementIDField());
            this.data.pos_xml_parent_element_id = this.data.outputRowMeta.indexOfValue(this.meta.getXmlParentElementIDField());
            this.data.pos_xml_element_level = this.data.outputRowMeta.indexOfValue(this.meta.getXmlElementLevelField());
            this.data.pos_xml_path = this.data.outputRowMeta.indexOfValue(this.meta.getXmlPathField());
            this.data.pos_xml_parent_path = this.data.outputRowMeta.indexOfValue(this.meta.getXmlParentPathField());
            this.data.pos_xml_data_name = this.data.outputRowMeta.indexOfValue(this.meta.getXmlDataNameField());
            this.data.pos_xml_data_value = this.data.outputRowMeta.indexOfValue(this.meta.getXmlDataValueField());
            this.data.fileObject = KettleVFS.getFileObject((String)this.data.filename, (VariableSpace)this.getTransMeta());
            try {
                this.data.fileInputStream = new FileInputStream(FileUtils.toFile((URL)this.data.fileObject.getURL()));
            }
            catch (FileNotFoundException e) {
                throw new KettleException((Throwable)e);
            }
            catch (FileSystemException e) {
                throw new KettleException((Throwable)e);
            }
            try {
                this.data.xmlEventReader = this.data.staxInstance.createXMLEventReader(this.data.fileInputStream, this.data.encoding);
            }
            catch (XMLStreamException e) {
                throw new KettleException((Throwable)e);
            }
            if (this.meta.isAddResultFile()) {
                ResultFile resultFile = new ResultFile(0, this.data.fileObject, this.getTransMeta().getName(), this.getStepname());
                resultFile.setComment("File was read by an XML Input Stream step");
                this.addResultFile(resultFile);
            }
            this.resetElementCounters();
        }
        if ((outputRowData = this.getRowFromXML()) == null) {
            this.setOutputDone();
            return false;
        }
        this.putRowOut(outputRowData);
        if (this.data.rowLimit > 0L && this.data.rowNumber >= this.data.rowLimit) {
            this.setOutputDone();
            return false;
        }
        return true;
    }

    private void putRowOut(Object[] r) throws KettleStepException, KettleValueException {
        XMLInputStreamData xMLInputStreamData = this.data;
        Long l = xMLInputStreamData.rowNumber;
        Long l2 = xMLInputStreamData.rowNumber = Long.valueOf(xMLInputStreamData.rowNumber + 1L);
        if (this.data.pos_xml_filename != -1) {
            r[this.data.pos_xml_filename] = new String(this.data.filename);
        }
        if (this.data.pos_xml_row_number != -1) {
            r[this.data.pos_xml_row_number] = new Long(this.data.rowNumber);
        }
        if (this.data.pos_xml_element_id != -1) {
            r[this.data.pos_xml_element_id] = this.data.elementLevelID[this.data.elementLevel];
        }
        if (this.data.pos_xml_element_level != -1) {
            r[this.data.pos_xml_element_level] = new Long(this.data.elementLevel);
        }
        if (this.data.pos_xml_parent_element_id != -1) {
            r[this.data.pos_xml_parent_element_id] = this.data.elementParentID[this.data.elementLevel];
        }
        if (this.data.pos_xml_path != -1) {
            r[this.data.pos_xml_path] = this.data.elementPath[this.data.elementLevel];
        }
        if (this.data.pos_xml_parent_path != -1 && this.data.elementLevel > 0) {
            r[this.data.pos_xml_parent_path] = this.data.elementPath[this.data.elementLevel - 1];
        }
        if (this.data.nrRowsToSkip == 0L || this.data.rowNumber > this.data.nrRowsToSkip) {
            if (this.log.isRowLevel()) {
                this.logRowlevel("Read row: " + this.data.outputRowMeta.getString(r));
            }
            this.putRow(this.data.outputRowMeta, r);
        }
    }

    private Object[] getRowFromXML() throws KettleException {
        Object[] outputRowData = null;
        while (this.data.xmlEventReader.hasNext() && outputRowData == null && !this.isStopped()) {
            outputRowData = this.processEvent();
            this.incrementLinesInput();
            if (!this.checkFeedback(this.getLinesInput()) || !this.isBasic()) continue;
            this.logBasic(BaseMessages.getString(PKG, (String)"XMLInputStream.Log.LineNumber", (String[])new String[]{Long.toString(this.getLinesInput())}));
        }
        return outputRowData;
    }

    private Object[] processEvent() throws KettleException {
        Object[] outputRowData = RowDataUtil.allocateRowData((int)this.data.outputRowMeta.size());
        XMLEvent e = null;
        try {
            e = this.data.xmlEventReader.nextEvent();
        }
        catch (XMLStreamException ex) {
            throw new KettleException((Throwable)ex);
        }
        int eventType = e.getEventType();
        if (this.data.pos_xml_data_type_numeric != -1) {
            outputRowData[this.data.pos_xml_data_type_numeric] = new Long(eventType);
        }
        if (this.data.pos_xml_data_type_description != -1) {
            outputRowData[this.data.pos_xml_data_type_description] = eventType == 0 || eventType > eventDescription.length ? eventDescription[0] + "(" + eventType + ")" : eventDescription[eventType];
        }
        if (this.data.pos_xml_location_line != -1) {
            outputRowData[this.data.pos_xml_location_line] = new Long(e.getLocation().getLineNumber());
        }
        if (this.data.pos_xml_location_column != -1) {
            outputRowData[this.data.pos_xml_location_column] = new Long(e.getLocation().getColumnNumber());
        }
        switch (eventType) {
            case 1: {
                String prefix;
                ++this.data.elementLevel;
                if (this.data.elementLevel > PARENT_ID_ALLOCATE_SIZE - 1) {
                    throw new KettleException("Too many nested XML elements, more than " + PARENT_ID_ALLOCATE_SIZE);
                }
                if (this.data.elementParentID[this.data.elementLevel] == null) {
                    this.data.elementParentID[this.data.elementLevel] = this.data.elementID;
                }
                XMLInputStreamData xMLInputStreamData = this.data;
                Long l = xMLInputStreamData.elementID;
                Long l2 = xMLInputStreamData.elementID = Long.valueOf(xMLInputStreamData.elementID + 1L);
                this.data.elementLevelID[this.data.elementLevel] = this.data.elementID;
                outputRowData[this.data.pos_xml_data_name] = this.meta.isEnableNamespaces() ? (Const.isEmpty((String)(prefix = e.asStartElement().getName().getPrefix())) ? e.asStartElement().getName().getLocalPart() : prefix + ":" + e.asStartElement().getName().getLocalPart()) : e.asStartElement().getName().getLocalPart();
                this.data.elementName[this.data.elementLevel] = new String((String)outputRowData[this.data.pos_xml_data_name]);
                this.data.elementPath[this.data.elementLevel] = this.data.elementPath[this.data.elementLevel - 1] + "/" + outputRowData[this.data.pos_xml_data_name];
                if (this.meta.isEnableNamespaces()) {
                    outputRowData = this.parseNamespaces(outputRowData, e);
                }
                outputRowData = this.parseAttributes(outputRowData, e);
                break;
            }
            case 2: {
                outputRowData[this.data.pos_xml_data_name] = e.asEndElement().getName().getLocalPart();
                this.putRowOut(outputRowData);
                this.data.elementParentID[this.data.elementLevel + 1] = null;
                --this.data.elementLevel;
                outputRowData = null;
                break;
            }
            case 6: {
                outputRowData = null;
                break;
            }
            case 4: {
                outputRowData[this.data.pos_xml_data_name] = this.data.elementName[this.data.elementLevel];
                outputRowData[this.data.pos_xml_data_value] = e.asCharacters().getData();
                if (this.meta.isEnableTrim()) {
                    outputRowData[this.data.pos_xml_data_value] = Const.trim((String)((String)outputRowData[this.data.pos_xml_data_value]));
                }
                if (!Const.isEmpty((String)((String)outputRowData[this.data.pos_xml_data_value]))) break;
                outputRowData = null;
                break;
            }
            case 3: {
                outputRowData = null;
                break;
            }
            case 12: {
                outputRowData[this.data.pos_xml_data_name] = this.data.elementName[this.data.elementLevel];
                outputRowData[this.data.pos_xml_data_value] = e.asCharacters().getData();
                if (this.meta.isEnableTrim()) {
                    outputRowData[this.data.pos_xml_data_value] = Const.trim((String)((String)outputRowData[this.data.pos_xml_data_value]));
                }
                if (!Const.isEmpty((String)((String)outputRowData[this.data.pos_xml_data_value]))) break;
                outputRowData = null;
                break;
            }
            case 5: {
                outputRowData = null;
                break;
            }
            case 9: {
                outputRowData = null;
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                break;
            }
            default: {
                this.logBasic("Event:" + eventType);
                outputRowData = null;
            }
        }
        return outputRowData;
    }

    private Object[] parseNamespaces(Object[] outputRowData, XMLEvent e) throws KettleValueException, KettleStepException {
        Object[] outputRowDataNamespace;
        Iterator<Namespace> iter = e.asStartElement().getNamespaces();
        if (iter.hasNext()) {
            outputRowDataNamespace = this.data.outputRowMeta.cloneRow(outputRowData);
            this.putRowOut(outputRowDataNamespace);
            if (this.data.pos_xml_data_type_numeric != -1) {
                outputRowData[this.data.pos_xml_data_type_numeric] = new Long(13L);
            }
            if (this.data.pos_xml_data_type_description != -1) {
                outputRowData[this.data.pos_xml_data_type_description] = eventDescription[13];
            }
        }
        while (iter.hasNext()) {
            outputRowDataNamespace = this.data.outputRowMeta.cloneRow(outputRowData);
            Namespace n = iter.next();
            outputRowDataNamespace[this.data.pos_xml_data_name] = n.getPrefix();
            outputRowDataNamespace[this.data.pos_xml_data_value] = n.getNamespaceURI();
            if (iter.hasNext()) {
                this.putRowOut(outputRowDataNamespace);
                continue;
            }
            outputRowData = outputRowDataNamespace;
        }
        return outputRowData;
    }

    private Object[] parseAttributes(Object[] outputRowData, XMLEvent e) throws KettleValueException, KettleStepException {
        Object[] outputRowDataAttribute;
        Iterator<Attribute> iter = e.asStartElement().getAttributes();
        if (iter.hasNext()) {
            outputRowDataAttribute = this.data.outputRowMeta.cloneRow(outputRowData);
            this.putRowOut(outputRowDataAttribute);
            if (this.data.pos_xml_data_type_numeric != -1) {
                outputRowData[this.data.pos_xml_data_type_numeric] = new Long(10L);
            }
            if (this.data.pos_xml_data_type_description != -1) {
                outputRowData[this.data.pos_xml_data_type_description] = eventDescription[10];
            }
        }
        while (iter.hasNext()) {
            outputRowDataAttribute = this.data.outputRowMeta.cloneRow(outputRowData);
            Attribute a = iter.next();
            outputRowDataAttribute[this.data.pos_xml_data_name] = a.getName().getLocalPart();
            outputRowDataAttribute[this.data.pos_xml_data_value] = a.getValue();
            if (iter.hasNext()) {
                this.putRowOut(outputRowDataAttribute);
                continue;
            }
            outputRowData = outputRowDataAttribute;
        }
        return outputRowData;
    }

    private void resetElementCounters() {
        this.data.rowNumber = new Long(0L);
        this.data.elementLevel = 0;
        this.data.elementID = new Long(0L);
        this.data.elementLevelID = new Long[PARENT_ID_ALLOCATE_SIZE];
        this.data.elementLevelID[0] = this.data.elementID;
        this.data.elementParentID = new Long[PARENT_ID_ALLOCATE_SIZE];
        this.data.elementName = new String[PARENT_ID_ALLOCATE_SIZE];
        this.data.elementPath = new String[PARENT_ID_ALLOCATE_SIZE];
        this.data.elementPath[0] = "";
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (XMLInputStreamMeta)smi;
        this.data = (XMLInputStreamData)sdi;
        if (super.init(smi, sdi)) {
            this.data.staxInstance = XMLInputFactory.newInstance();
            return true;
        }
        return false;
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (XMLInputStreamMeta)smi;
        this.data = (XMLInputStreamData)sdi;
        if (this.data.xmlEventReader != null) {
            try {
                this.data.xmlEventReader.close();
            }
            catch (XMLStreamException e) {
                // empty catch block
            }
            this.data.xmlEventReader = null;
        }
        if (this.data.fileInputStream != null) {
            try {
                this.data.fileInputStream.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            this.data.fileInputStream = null;
        }
        if (this.data.fileObject != null) {
            try {
                this.data.fileObject.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.data.fileObject = null;
        }
        this.data.staxInstance = null;
        super.dispose(smi, sdi);
    }
}

