/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.xmljoin;

import java.util.List;
import java.util.Map;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.xmljoin.XMLJoin;
import org.pentaho.di.trans.steps.xmljoin.XMLJoinData;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLJoinMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = XMLJoinMeta.class;
    private boolean complexJoin;
    private String targetXMLstep;
    private String targetXMLfield;
    private String sourceXMLfield;
    private String valueXMLfield;
    private String targetXPath;
    private String sourceXMLstep;
    private String joinCompareField;
    private String encoding;
    private boolean omitXMLHeader;
    private boolean omitNullValues;

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        this.readData(stepnode);
    }

    @Override
    public Object clone() {
        XMLJoinMeta retval = (XMLJoinMeta)super.clone();
        return retval;
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            this.valueXMLfield = XMLHandler.getTagValue((Node)stepnode, (String)"valueXMLfield");
            this.targetXMLstep = XMLHandler.getTagValue((Node)stepnode, (String)"targetXMLstep");
            this.targetXMLfield = XMLHandler.getTagValue((Node)stepnode, (String)"targetXMLfield");
            this.sourceXMLstep = XMLHandler.getTagValue((Node)stepnode, (String)"sourceXMLstep");
            this.sourceXMLfield = XMLHandler.getTagValue((Node)stepnode, (String)"sourceXMLfield");
            this.targetXPath = XMLHandler.getTagValue((Node)stepnode, (String)"targetXPath");
            this.joinCompareField = XMLHandler.getTagValue((Node)stepnode, (String)"joinCompareField");
            this.encoding = XMLHandler.getTagValue((Node)stepnode, (String)"encoding");
            this.complexJoin = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"complexJoin"));
            this.omitXMLHeader = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"omitXMLHeader"));
            this.omitNullValues = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"omitNullValues"));
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to load step info from XML", (Throwable)e);
        }
    }

    @Override
    public void setDefault() {
        this.encoding = "UTF-8";
    }

    @Override
    public void getFields(RowMetaInterface row, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space) throws KettleStepException {
        ValueMeta v = new ValueMeta(this.getValueXMLfield(), 2);
        v.setOrigin(name);
        row.addValueMeta((ValueMetaInterface)v);
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(500);
        retval.append("    ").append(XMLHandler.addTagValue((String)"valueXMLField", (String)this.valueXMLfield));
        retval.append("    ").append(XMLHandler.addTagValue((String)"targetXMLstep", (String)this.targetXMLstep));
        retval.append("    ").append(XMLHandler.addTagValue((String)"targetXMLfield", (String)this.targetXMLfield));
        retval.append("    ").append(XMLHandler.addTagValue((String)"sourceXMLstep", (String)this.sourceXMLstep));
        retval.append("    ").append(XMLHandler.addTagValue((String)"sourceXMLfield", (String)this.sourceXMLfield));
        retval.append("    ").append(XMLHandler.addTagValue((String)"complexJoin", (boolean)this.complexJoin));
        retval.append("    ").append(XMLHandler.addTagValue((String)"joinCompareField", (String)this.joinCompareField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"targetXPath", (String)this.targetXPath));
        retval.append("    ").append(XMLHandler.addTagValue((String)"encoding", (String)this.encoding));
        retval.append("    ").append(XMLHandler.addTagValue((String)"omitXMLHeader", (boolean)this.omitXMLHeader));
        retval.append("    ").append(XMLHandler.addTagValue((String)"omitNullValues", (boolean)this.omitNullValues));
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, ObjectId id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        try {
            this.targetXMLstep = rep.getStepAttributeString(id_step, "targetXMLstep");
            this.targetXMLfield = rep.getStepAttributeString(id_step, "targetXMLfield");
            this.sourceXMLstep = rep.getStepAttributeString(id_step, "sourceXMLstep");
            this.sourceXMLfield = rep.getStepAttributeString(id_step, "sourceXMLfield");
            this.targetXPath = rep.getStepAttributeString(id_step, "targetXPath");
            this.complexJoin = rep.getStepAttributeBoolean(id_step, "complexJoin");
            this.joinCompareField = rep.getStepAttributeString(id_step, "joinCompareField");
            this.valueXMLfield = rep.getStepAttributeString(id_step, "valueXMLfield");
            this.encoding = rep.getStepAttributeString(id_step, "encoding");
            this.omitXMLHeader = rep.getStepAttributeBoolean(id_step, "omitXMLHeader");
            this.omitNullValues = rep.getStepAttributeBoolean(id_step, "omitNullValues");
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error reading step information from the repository", (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "valueXMLfield", this.valueXMLfield);
            rep.saveStepAttribute(id_transformation, id_step, "targetXMLstep", this.targetXMLstep);
            rep.saveStepAttribute(id_transformation, id_step, "targetXMLfield", this.targetXMLfield);
            rep.saveStepAttribute(id_transformation, id_step, "sourceXMLstep", this.sourceXMLstep);
            rep.saveStepAttribute(id_transformation, id_step, "sourceXMLfield", this.sourceXMLfield);
            rep.saveStepAttribute(id_transformation, id_step, "complexJoin", this.complexJoin);
            rep.saveStepAttribute(id_transformation, id_step, "targetXPath", this.targetXPath);
            rep.saveStepAttribute(id_transformation, id_step, "joinCompareField", this.joinCompareField);
            rep.saveStepAttribute(id_transformation, id_step, "encoding", this.encoding);
            rep.saveStepAttribute(id_transformation, id_step, "omitXMLHeader", this.omitXMLHeader);
            rep.saveStepAttribute(id_transformation, id_step, "omitNullValues", this.omitNullValues);
        }
        catch (Exception e) {
            throw new KettleException("Unable to save step information to the repository for id_step=" + id_step, (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        CheckResult cr;
        if (this.targetXMLstep == null || this.targetXMLstep.length() == 0) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"XMLJoin.CheckResult.TargetXMLStepNotSpecified", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"XMLJoin.CheckResult.TargetXMLStepSpecified", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (this.targetXMLfield == null || this.targetXMLfield.length() == 0) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"XMLJoin.CheckResult.TargetXMLFieldNotSpecified", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"XMLJoin.CheckResult.TargetXMLFieldSpecified", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (this.sourceXMLstep == null || this.sourceXMLstep.length() == 0) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"XMLJoin.CheckResult.SourceXMLStepNotSpecified", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"XMLJoin.CheckResult.SourceXMLStepSpecified", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (this.sourceXMLfield == null || this.sourceXMLfield.length() == 0) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"XMLJoin.CheckResult.SourceXMLFieldNotSpecified", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"XMLJoin.CheckResult.SourceXMLFieldSpecified", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (this.valueXMLfield == null || this.valueXMLfield.length() == 0) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"XMLJoin.CheckResult.ResultFieldNotSpecified", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"XMLJoin.CheckResult.ResultFieldSpecified", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (this.targetXPath == null || this.targetXPath.length() == 0) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"XMLJoin.CheckResult.TargetXPathNotSpecified", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"XMLJoin.CheckResult.TargetXPathSpecified", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (input.length > 0) {
            boolean targetStepFound = false;
            boolean sourceStepFound = false;
            for (int i = 0; i < input.length; ++i) {
                if (this.targetXMLstep != null && this.targetXMLstep.equals(input[i])) {
                    targetStepFound = true;
                    cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"XMLJoin.CheckResult.TargetXMLStepFound", (String[])new String[]{this.targetXMLstep}), (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr);
                }
                if (this.sourceXMLstep == null || !this.sourceXMLstep.equals(input[i])) continue;
                sourceStepFound = true;
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"XMLJoin.CheckResult.SourceXMLStepFound", (String[])new String[]{this.sourceXMLstep}), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
            if (!targetStepFound) {
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"XMLJoin.CheckResult.TargetXMLStepNotFound", (String[])new String[]{this.targetXMLstep}), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
            if (!sourceStepFound) {
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"XMLJoin.CheckResult.SourceXMLStepNotFound", (String[])new String[]{this.sourceXMLstep}), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"XMLJoin.CheckResult.ExpectedInputError", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new XMLJoin(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new XMLJoinData();
    }

    public boolean isComplexJoin() {
        return this.complexJoin;
    }

    public void setComplexJoin(boolean complexJoin) {
        this.complexJoin = complexJoin;
    }

    public String getTargetXMLstep() {
        return this.targetXMLstep;
    }

    public void setTargetXMLstep(String targetXMLstep) {
        this.targetXMLstep = targetXMLstep;
    }

    public String getTargetXMLfield() {
        return this.targetXMLfield;
    }

    public void setTargetXMLfield(String targetXMLfield) {
        this.targetXMLfield = targetXMLfield;
    }

    public String getSourceXMLstep() {
        return this.sourceXMLstep;
    }

    public void setSourceXMLstep(String targetXMLstep) {
        this.sourceXMLstep = targetXMLstep;
    }

    public String getSourceXMLfield() {
        return this.sourceXMLfield;
    }

    public void setSourceXMLfield(String sourceXMLfield) {
        this.sourceXMLfield = sourceXMLfield;
    }

    public String getValueXMLfield() {
        return this.valueXMLfield;
    }

    public void setValueXMLfield(String valueXMLfield) {
        this.valueXMLfield = valueXMLfield;
    }

    public String getTargetXPath() {
        return this.targetXPath;
    }

    public void setTargetXPath(String targetXPath) {
        this.targetXPath = targetXPath;
    }

    public String getJoinCompareField() {
        return this.joinCompareField;
    }

    public void setJoinCompareField(String joinCompareField) {
        this.joinCompareField = joinCompareField;
    }

    @Override
    public boolean excludeFromRowLayoutVerification() {
        return true;
    }

    public boolean isOmitXMLHeader() {
        return this.omitXMLHeader;
    }

    public void setOmitXMLHeader(boolean omitXMLHeader) {
        this.omitXMLHeader = omitXMLHeader;
    }

    public void setOmitNullValues(boolean omitNullValues) {
        this.omitNullValues = omitNullValues;
    }

    public boolean isOmitNullValues() {
        return this.omitNullValues;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }
}

