/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.xslt;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.xslt.Xslt;
import org.pentaho.di.trans.steps.xslt.XsltData;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XsltMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = XsltMeta.class;
    public static final String[] outputProperties = new String[]{"method", "version", "encoding", "standalone", "indent", "omit-xml-declaration", "doctype-public", "doctype-system", "media-type"};
    private String xslFilename;
    private String fieldName;
    private String resultFieldname;
    private String xslFileField;
    private boolean xslFileFieldUse;
    private boolean xslFieldIsAFile;
    private String xslFactory;
    private String[] outputPropertyName;
    private String[] outputPropertyValue;
    private String[] parameterName;
    private String[] parameterField;

    public String[] getParameterName() {
        return this.parameterName;
    }

    public void setParameterName(String[] argumentDirection) {
        this.parameterName = argumentDirection;
    }

    public String[] getParameterField() {
        return this.parameterField;
    }

    public void setParameterField(String[] argumentDirection) {
        this.parameterField = argumentDirection;
    }

    public String getXslFilename() {
        return this.xslFilename;
    }

    public String[] getOutputPropertyName() {
        return this.outputPropertyName;
    }

    public void setOutputPropertyName(String[] argumentDirection) {
        this.outputPropertyName = argumentDirection;
    }

    public String[] getOutputPropertyValue() {
        return this.outputPropertyValue;
    }

    public void setOutputPropertyValue(String[] argumentDirection) {
        this.outputPropertyValue = argumentDirection;
    }

    public void setXSLFileField(String xslfilefieldin) {
        this.xslFileField = xslfilefieldin;
    }

    public void setXSLFactory(String xslfactoryin) {
        this.xslFactory = xslfactoryin;
    }

    public String getXSLFactory() {
        return this.xslFactory;
    }

    public String getXSLFileField() {
        return this.xslFileField;
    }

    public String getResultfieldname() {
        return this.resultFieldname;
    }

    public String getFieldname() {
        return this.fieldName;
    }

    public void setXslFilename(String xslFilename) {
        this.xslFilename = xslFilename;
    }

    public void setResultfieldname(String resultfield) {
        this.resultFieldname = resultfield;
    }

    public void setFieldname(String fieldnamein) {
        this.fieldName = fieldnamein;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        this.readData(stepnode);
    }

    public void allocate(int nrParameters, int outputProps) {
        this.parameterName = new String[nrParameters];
        this.parameterField = new String[nrParameters];
        this.outputPropertyName = new String[outputProps];
        this.outputPropertyValue = new String[outputProps];
    }

    @Override
    public Object clone() {
        int i;
        XsltMeta retval = (XsltMeta)super.clone();
        int nrparams = this.parameterName.length;
        int nroutputprops = this.outputPropertyName.length;
        retval.allocate(nrparams, nroutputprops);
        for (i = 0; i < nrparams; ++i) {
            retval.parameterName[i] = this.parameterName[i];
            retval.parameterField[i] = this.parameterField[i];
        }
        for (i = 0; i < nroutputprops; ++i) {
            retval.outputPropertyName[i] = this.outputPropertyName[i];
            retval.outputPropertyValue[i] = this.outputPropertyValue[i];
        }
        return retval;
    }

    public boolean useXSLField() {
        return this.xslFileFieldUse;
    }

    public void setXSLField(boolean value) {
        this.xslFileFieldUse = value;
    }

    public void setXSLFieldIsAFile(boolean xslFieldisAFile) {
        this.xslFieldIsAFile = xslFieldisAFile;
    }

    public boolean isXSLFieldIsAFile() {
        return this.xslFieldIsAFile;
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            Node anode;
            int i;
            this.xslFilename = XMLHandler.getTagValue((Node)stepnode, (String)"xslfilename");
            this.fieldName = XMLHandler.getTagValue((Node)stepnode, (String)"fieldname");
            this.resultFieldname = XMLHandler.getTagValue((Node)stepnode, (String)"resultfieldname");
            this.xslFileField = XMLHandler.getTagValue((Node)stepnode, (String)"xslfilefield");
            this.xslFileFieldUse = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"xslfilefielduse"));
            String isAFile = XMLHandler.getTagValue((Node)stepnode, (String)"xslfieldisafile");
            this.xslFieldIsAFile = this.xslFileFieldUse && Const.isEmpty((String)isAFile) ? true : "Y".equalsIgnoreCase(isAFile);
            this.xslFactory = XMLHandler.getTagValue((Node)stepnode, (String)"xslfactory");
            Node parametersNode = XMLHandler.getSubNode((Node)stepnode, (String)"parameters");
            int nrparams = XMLHandler.countNodes((Node)parametersNode, (String)"parameter");
            Node parametersOutputProps = XMLHandler.getSubNode((Node)stepnode, (String)"outputproperties");
            int nroutputprops = XMLHandler.countNodes((Node)parametersOutputProps, (String)"outputproperty");
            this.allocate(nrparams, nroutputprops);
            for (i = 0; i < nrparams; ++i) {
                anode = XMLHandler.getSubNodeByNr((Node)parametersNode, (String)"parameter", (int)i);
                this.parameterField[i] = XMLHandler.getTagValue((Node)anode, (String)"field");
                this.parameterName[i] = XMLHandler.getTagValue((Node)anode, (String)"name");
            }
            for (i = 0; i < nroutputprops; ++i) {
                anode = XMLHandler.getSubNodeByNr((Node)parametersOutputProps, (String)"outputproperty", (int)i);
                this.outputPropertyName[i] = XMLHandler.getTagValue((Node)anode, (String)"name");
                this.outputPropertyValue[i] = XMLHandler.getTagValue((Node)anode, (String)"value");
            }
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"XsltMeta.Exception.UnableToLoadStepInfoFromXML", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void setDefault() {
        int i;
        this.xslFilename = null;
        this.fieldName = null;
        this.resultFieldname = "result";
        this.xslFactory = "JAXP";
        this.xslFileField = null;
        this.xslFileFieldUse = false;
        this.xslFieldIsAFile = true;
        int nrparams = 0;
        int nroutputproperties = 0;
        this.allocate(nrparams, nroutputproperties);
        for (i = 0; i < nrparams; ++i) {
            this.parameterField[i] = "param" + i;
            this.parameterName[i] = "param";
        }
        for (i = 0; i < nroutputproperties; ++i) {
            this.outputPropertyName[i] = "outputprop" + i;
            this.outputPropertyValue[i] = "outputprop";
        }
    }

    @Override
    public void getFields(RowMetaInterface inputRowMeta, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space) throws KettleStepException {
        ValueMeta v = new ValueMeta(space.environmentSubstitute(this.getResultfieldname()), 2);
        v.setOrigin(name);
        inputRowMeta.addValueMeta((ValueMetaInterface)v);
    }

    @Override
    public String getXML() {
        int i;
        StringBuffer retval = new StringBuffer();
        retval.append("    " + XMLHandler.addTagValue((String)"xslfilename", (String)this.xslFilename));
        retval.append("    " + XMLHandler.addTagValue((String)"fieldname", (String)this.fieldName));
        retval.append("    " + XMLHandler.addTagValue((String)"resultfieldname", (String)this.resultFieldname));
        retval.append("    " + XMLHandler.addTagValue((String)"xslfilefield", (String)this.xslFileField));
        retval.append("    " + XMLHandler.addTagValue((String)"xslfilefielduse", (boolean)this.xslFileFieldUse));
        retval.append("    " + XMLHandler.addTagValue((String)"xslfieldisafile", (boolean)this.xslFieldIsAFile));
        retval.append("    " + XMLHandler.addTagValue((String)"xslfactory", (String)this.xslFactory));
        retval.append("    <parameters>").append(Const.CR);
        for (i = 0; i < this.parameterName.length; ++i) {
            retval.append("      <parameter>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"field", (String)this.parameterField[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"name", (String)this.parameterName[i]));
            retval.append("      </parameter>").append(Const.CR);
        }
        retval.append("    </parameters>").append(Const.CR);
        retval.append("    <outputproperties>").append(Const.CR);
        for (i = 0; i < this.outputPropertyName.length; ++i) {
            retval.append("      <outputproperty>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"name", (String)this.outputPropertyName[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"value", (String)this.outputPropertyValue[i]));
            retval.append("      </outputproperty>").append(Const.CR);
        }
        retval.append("    </outputproperties>").append(Const.CR);
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, ObjectId id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        try {
            int i;
            this.xslFilename = rep.getStepAttributeString(id_step, "xslfilename");
            this.fieldName = rep.getStepAttributeString(id_step, "fieldname");
            this.resultFieldname = rep.getStepAttributeString(id_step, "resultfieldname");
            this.xslFileField = rep.getStepAttributeString(id_step, "xslfilefield");
            this.xslFileFieldUse = rep.getStepAttributeBoolean(id_step, "xslfilefielduse");
            String isAfile = rep.getStepAttributeString(id_step, "xslfieldisafile");
            this.xslFieldIsAFile = this.xslFileFieldUse && Const.isEmpty((String)isAfile) ? true : "Y".equalsIgnoreCase(isAfile);
            this.xslFactory = rep.getStepAttributeString(id_step, "xslfactory");
            int nrparams = rep.countNrStepAttributes(id_step, "param_name");
            int nroutputprops = rep.countNrStepAttributes(id_step, "output_property_name");
            this.allocate(nrparams, nroutputprops);
            for (i = 0; i < nrparams; ++i) {
                this.parameterField[i] = rep.getStepAttributeString(id_step, i, "param_field");
                this.parameterName[i] = rep.getStepAttributeString(id_step, i, "param_name");
            }
            for (i = 0; i < nroutputprops; ++i) {
                this.outputPropertyName[i] = rep.getStepAttributeString(id_step, i, "output_property_name");
                this.outputPropertyValue[i] = rep.getStepAttributeString(id_step, i, "output_property_value");
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"XsltMeta.Exception.UnexpectedErrorInReadingStepInfo", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            int i;
            rep.saveStepAttribute(id_transformation, id_step, "xslfilename", this.xslFilename);
            rep.saveStepAttribute(id_transformation, id_step, "fieldname", this.fieldName);
            rep.saveStepAttribute(id_transformation, id_step, "resultfieldname", this.resultFieldname);
            rep.saveStepAttribute(id_transformation, id_step, "xslfilefield", this.xslFileField);
            rep.saveStepAttribute(id_transformation, id_step, "xslfilefielduse", this.xslFileFieldUse);
            rep.saveStepAttribute(id_transformation, id_step, "xslfieldisafile", this.xslFieldIsAFile);
            rep.saveStepAttribute(id_transformation, id_step, "xslfactory", this.xslFactory);
            for (i = 0; i < this.parameterName.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "param_field", this.parameterField[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "param_name", this.parameterName[i]);
            }
            for (i = 0; i < this.outputPropertyName.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "output_property_name", this.outputPropertyName[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "output_property_value", this.outputPropertyValue[i]);
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"XsltMeta.Exception.UnableToSaveStepInfo", (String[])new String[0]) + id_step, (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        CheckResult cr;
        if (prev != null && prev.size() > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"XsltMeta.CheckResult.ConnectedStepOK", (String[])new String[]{String.valueOf(prev.size())}), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"XsltMeta.CheckResult.NoInputReceived", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"XsltMeta.CheckResult.ExpectedInputOk", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"XsltMeta.CheckResult.ExpectedInputError", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (this.getResultfieldname() == null) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"XsltMeta.CheckResult.ErrorResultFieldNameMissing", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (this.xslFileFieldUse) {
            if (this.getXSLFileField() == null) {
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"XsltMeta.CheckResult.ErrorResultXSLFieldNameMissing", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            } else {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"XsltMeta.CheckResult.ErrorResultXSLFieldNameOK", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
        } else if (this.xslFilename == null) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"XsltMeta.CheckResult.ErrorXSLFileNameMissing", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            String RealFilename = transMeta.environmentSubstitute(this.xslFilename);
            File f = new File(RealFilename);
            if (f.exists()) {
                if (f.isFile()) {
                    cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"XsltMeta.CheckResult.FileExists", (String[])new String[]{RealFilename}), (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr);
                } else {
                    cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"XsltMeta.CheckResult.ExistsButNoFile", (String[])new String[]{RealFilename}), (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr);
                }
            } else {
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"XsltMeta.CheckResult.FileNotExists", (String[])new String[]{RealFilename}), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new Xslt(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new XsltData();
    }

    @Override
    public boolean supportsErrorHandling() {
        return true;
    }
}

