/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.CentralLogStore;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.logging.LoggingObjectType;
import org.pentaho.di.core.logging.SimpleLoggingObject;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.RepositoryPluginType;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.RepositoriesMeta;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.RepositoryMeta;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransAdapter;
import org.pentaho.di.trans.TransConfiguration;
import org.pentaho.di.trans.TransExecutionConfiguration;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.www.BaseHttpServlet;
import org.pentaho.di.www.CarteServletInterface;
import org.pentaho.di.www.TransformationMap;
import org.pentaho.di.www.WebResult;

public class ExecuteTransServlet
extends BaseHttpServlet
implements CarteServletInterface {
    private static Class<?> PKG = ExecuteTransServlet.class;
    private static final long serialVersionUID = -5879219287669847357L;
    public static final String CONTEXT_PATH = "/kettle/executeTrans";

    public ExecuteTransServlet() {
    }

    public ExecuteTransServlet(TransformationMap transformationMap) {
        super(transformationMap);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.isJettyMode() && !request.getContextPath().startsWith(CONTEXT_PATH)) {
            return;
        }
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"ExecuteTransServlet.Log.ExecuteTransRequested", (String[])new String[0]));
        }
        String[] knownOptions = new String[]{"rep", "user", "pass", "trans", "level"};
        String repOption = request.getParameter("rep");
        String userOption = request.getParameter("user");
        String passOption = Encr.decryptPasswordOptionallyEncrypted((String)request.getParameter("pass"));
        String transOption = request.getParameter("trans");
        String levelOption = request.getParameter("level");
        response.setStatus(200);
        PrintWriter out = response.getWriter();
        try {
            final Repository repository = this.openRepository(repOption, userOption, passOption);
            TransMeta transMeta = this.loadTransformation(repository, transOption);
            String[] parameters = transMeta.listParameters();
            Enumeration parameterNames = request.getParameterNames();
            while (parameterNames.hasMoreElements()) {
                String parameter = (String)parameterNames.nextElement();
                String[] values = request.getParameterValues(parameter);
                if (Const.indexOfString((String)parameter, (String[])knownOptions) >= 0) continue;
                if (Const.indexOfString((String)parameter, (String[])parameters) < 0) {
                    transMeta.setVariable(parameter, values[0]);
                    continue;
                }
                transMeta.setParameterValue(parameter, values[0]);
            }
            TransExecutionConfiguration transExecutionConfiguration = new TransExecutionConfiguration();
            LogLevel logLevel = LogLevel.getLogLevelForCode((String)levelOption);
            transExecutionConfiguration.setLogLevel(logLevel);
            TransConfiguration transConfiguration = new TransConfiguration(transMeta, transExecutionConfiguration);
            String carteObjectId = UUID.randomUUID().toString();
            SimpleLoggingObject servletLoggingObject = new SimpleLoggingObject(CONTEXT_PATH, LoggingObjectType.CARTE, null);
            servletLoggingObject.setContainerObjectId(carteObjectId);
            servletLoggingObject.setLogLevel(logLevel);
            Trans trans = new Trans(transMeta, (LoggingObjectInterface)servletLoggingObject);
            trans.setRepository(repository);
            trans.setSocketRepository(this.getSocketRepository());
            this.getTransformationMap().addTransformation(transMeta.getName(), carteObjectId, trans, transConfiguration);
            trans.setContainerObjectId(carteObjectId);
            if (repository != null) {
                trans.addTransListener(new TransAdapter(){

                    public void transFinished(Trans trans) {
                        repository.disconnect();
                    }
                });
            }
            trans.setServletPrintWriter(out);
            try {
                this.executeTrans(trans);
                out.flush();
            }
            catch (Exception executionException) {
                String logging = CentralLogStore.getAppender().getBuffer(trans.getLogChannelId(), false).toString();
                throw new KettleException("Error executing transformation: " + logging, (Throwable)executionException);
            }
        }
        catch (Exception ex) {
            out.println(new WebResult("ERROR", BaseMessages.getString(PKG, (String)"ExecuteTransServlet.Error.UnexpectedError", (String[])new String[]{Const.CR + Const.getStackTracker((Throwable)ex)})));
        }
    }

    private TransMeta loadTransformation(Repository repository, String trans) throws KettleException {
        String name;
        String directoryPath;
        if (repository == null) {
            TransMeta transMeta = new TransMeta(trans);
            return transMeta;
        }
        int lastSlash = trans.lastIndexOf("/");
        if (lastSlash < 0) {
            directoryPath = "/";
            name = trans;
        } else {
            directoryPath = trans.substring(0, lastSlash);
            name = trans.substring(lastSlash + 1);
        }
        RepositoryDirectoryInterface directory = repository.loadRepositoryDirectoryTree().findDirectory(directoryPath);
        ObjectId transformationID = repository.getTransformationID(name, directory);
        TransMeta transMeta = repository.loadTransformation(transformationID, null);
        return transMeta;
    }

    private Repository openRepository(String repositoryName, String user, String pass) throws KettleException {
        if (Const.isEmpty((String)repositoryName)) {
            return null;
        }
        RepositoriesMeta repositoriesMeta = new RepositoriesMeta();
        repositoriesMeta.readData();
        RepositoryMeta repositoryMeta = repositoriesMeta.findRepository(repositoryName);
        PluginRegistry registry = PluginRegistry.getInstance();
        Repository repository = (Repository)registry.loadClass(RepositoryPluginType.class, (Object)repositoryMeta, Repository.class);
        repository.init(repositoryMeta);
        repository.connect(user, pass);
        return repository;
    }

    public String toString() {
        return "Start transformation";
    }

    public String getService() {
        return "/kettle/executeTrans (" + this.toString() + ")";
    }

    protected void executeTrans(Trans trans) throws KettleException {
        trans.prepareExecution(null);
        trans.startThreads();
        trans.waitUntilFinished();
    }
}

