/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobConfiguration;
import org.pentaho.di.www.CarteObjectEntry;
import org.pentaho.di.www.SlaveServerConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobMap {
    private Map<CarteObjectEntry, Job> jobMap = new Hashtable<CarteObjectEntry, Job>();
    private Map<CarteObjectEntry, JobConfiguration> configurationMap = new Hashtable<CarteObjectEntry, JobConfiguration>();
    private SlaveServerConfig slaveServerConfig;

    public synchronized void addJob(String jobName, String carteObjectId, Job job, JobConfiguration jobConfiguration) {
        CarteObjectEntry entry = new CarteObjectEntry(jobName, carteObjectId);
        this.jobMap.put(entry, job);
        this.configurationMap.put(entry, jobConfiguration);
    }

    public void replaceJob(CarteObjectEntry entry, Job job, JobConfiguration jobConfiguration) {
        this.jobMap.put(entry, job);
        this.configurationMap.put(entry, jobConfiguration);
    }

    public synchronized Job getJob(String jobName) {
        for (CarteObjectEntry entry : this.jobMap.keySet()) {
            if (!entry.getName().equals(jobName)) continue;
            return this.jobMap.get(entry);
        }
        return null;
    }

    public synchronized Job getJob(CarteObjectEntry entry) {
        return this.jobMap.get(entry);
    }

    public synchronized JobConfiguration getConfiguration(String jobName) {
        for (CarteObjectEntry entry : this.configurationMap.keySet()) {
            if (!entry.getName().equals(jobName)) continue;
            return this.configurationMap.get(entry);
        }
        return null;
    }

    public synchronized JobConfiguration getConfiguration(CarteObjectEntry entry) {
        return this.configurationMap.get(entry);
    }

    public synchronized void removeJob(CarteObjectEntry entry) {
        this.jobMap.remove(entry);
        this.configurationMap.remove(entry);
    }

    public List<CarteObjectEntry> getJobObjects() {
        return new ArrayList<CarteObjectEntry>(this.jobMap.keySet());
    }

    public Map<CarteObjectEntry, JobConfiguration> getConfigurationMap() {
        return this.configurationMap;
    }

    public void setConfigurationMap(Map<CarteObjectEntry, JobConfiguration> configurationMap) {
        this.configurationMap = configurationMap;
    }

    public CarteObjectEntry getFirstCarteObjectEntry(String jobName) {
        for (CarteObjectEntry key : this.jobMap.keySet()) {
            if (!key.getName().equals(jobName)) continue;
            return key;
        }
        return null;
    }

    public SlaveServerConfig getSlaveServerConfig() {
        return this.slaveServerConfig;
    }

    public void setSlaveServerConfig(SlaveServerConfig slaveServerConfig) {
        this.slaveServerConfig = slaveServerConfig;
    }
}

