/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.logging.CentralLogStore;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.Job;
import org.pentaho.di.www.BaseHttpServlet;
import org.pentaho.di.www.CarteObjectEntry;
import org.pentaho.di.www.CarteServletInterface;
import org.pentaho.di.www.JobMap;
import org.pentaho.di.www.WebResult;

public class RemoveJobServlet
extends BaseHttpServlet
implements CarteServletInterface {
    private static Class<?> PKG = RemoveJobServlet.class;
    private static final long serialVersionUID = -2051906998698124039L;
    public static final String CONTEXT_PATH = "/kettle/removeJob";

    public RemoveJobServlet() {
    }

    public RemoveJobServlet(JobMap jobMap) {
        super(jobMap);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Job job;
        CarteObjectEntry entry;
        if (this.isJettyMode() && !request.getContextPath().startsWith(CONTEXT_PATH)) {
            return;
        }
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"RemoveJobServlet.Log.RemoveJobRequested", (String[])new String[0]));
        }
        String jobName = request.getParameter("name");
        String id = request.getParameter("id");
        boolean useXML = "Y".equalsIgnoreCase(request.getParameter("xml"));
        response.setStatus(200);
        if (useXML) {
            response.setContentType("text/xml");
            response.setCharacterEncoding("UTF-8");
        } else {
            response.setContentType("text/html;charset=UTF-8");
        }
        PrintWriter out = response.getWriter();
        if (Const.isEmpty((String)id)) {
            entry = this.getJobMap().getFirstCarteObjectEntry(jobName);
            if (entry == null) {
                job = null;
            } else {
                id = entry.getId();
                job = this.getJobMap().getJob(entry);
            }
        } else {
            entry = new CarteObjectEntry(jobName, id);
            job = this.getJobMap().getJob(entry);
        }
        if (job != null) {
            CentralLogStore.discardLines(job.getLogChannelId(), true);
            this.getJobMap().removeJob(entry);
            if (useXML) {
                response.setContentType("text/xml");
                response.setCharacterEncoding("UTF-8");
                out.print(XMLHandler.getXMLHeader((String)"UTF-8"));
                out.print(WebResult.OK.getXML());
            } else {
                response.setContentType("text/html;charset=UTF-8");
                out.println("<HTML>");
                out.println("<HEAD>");
                out.println("<TITLE>" + BaseMessages.getString(PKG, (String)"RemoveJobServlet.JobRemoved", (String[])new String[0]) + "</TITLE>");
                out.println("<META http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">");
                out.println("</HEAD>");
                out.println("<BODY>");
                out.println("<H3>" + BaseMessages.getString(PKG, (String)"RemoveJobServlet.TheJobWasRemoved", (String[])new String[]{jobName, id}) + "</H3>");
                out.print("<a href=\"" + this.convertContextPath("/kettle/status") + "\">" + BaseMessages.getString(PKG, (String)"TransStatusServlet.BackToStatusPage", (String[])new String[0]) + "</a><br>");
                out.println("<p>");
                out.println("</BODY>");
                out.println("</HTML>");
            }
        } else if (useXML) {
            out.println(new WebResult("ERROR", BaseMessages.getString(PKG, (String)"RemoveJobServlet.Log.CoundNotFindSpecJob", (String[])new String[]{jobName})));
        } else {
            out.println("<H1>" + BaseMessages.getString(PKG, (String)"RemoveJobServlet.JobRemoved.Log.CoundNotFindJob", (String[])new String[]{jobName, id}) + "</H1>");
            out.println("<a href=\"" + this.convertContextPath("/kettle/status") + "\">" + BaseMessages.getString(PKG, (String)"TransStatusServlet.BackToStatusPage", (String[])new String[0]) + "</a><p>");
        }
    }

    public String toString() {
        return "Remove job servlet";
    }

    public String getService() {
        return "/kettle/removeJob (" + this.toString() + ")";
    }
}

