/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.www.SlaveServerJobStatus;
import org.pentaho.di.www.SlaveServerTransStatus;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlaveServerStatus {
    public static final String XML_TAG = "serverstatus";
    private String statusDescription;
    private String errorDescription;
    private List<SlaveServerTransStatus> transStatusList;
    private List<SlaveServerJobStatus> jobStatusList;

    public SlaveServerStatus() {
        this.transStatusList = new ArrayList<SlaveServerTransStatus>();
        this.jobStatusList = new ArrayList<SlaveServerJobStatus>();
    }

    public SlaveServerStatus(String statusDescription) {
        this();
        this.statusDescription = statusDescription;
    }

    public SlaveServerStatus(String statusDescription, List<SlaveServerTransStatus> transStatusList, List<SlaveServerJobStatus> jobStatusList) {
        this.statusDescription = statusDescription;
        this.transStatusList = transStatusList;
        this.jobStatusList = jobStatusList;
    }

    public String getXML() throws KettleException {
        int i;
        StringBuffer xml = new StringBuffer();
        xml.append("<serverstatus>").append(Const.CR);
        xml.append(XMLHandler.addTagValue((String)"statusdesc", (String)this.statusDescription));
        xml.append("  <transstatuslist>").append(Const.CR);
        for (i = 0; i < this.transStatusList.size(); ++i) {
            SlaveServerTransStatus transStatus = this.transStatusList.get(i);
            xml.append("    ").append(transStatus.getXML()).append(Const.CR);
        }
        xml.append("  </transstatuslist>").append(Const.CR);
        xml.append("  <jobstatuslist>").append(Const.CR);
        for (i = 0; i < this.jobStatusList.size(); ++i) {
            SlaveServerJobStatus jobStatus = this.jobStatusList.get(i);
            xml.append("    ").append(jobStatus.getXML()).append(Const.CR);
        }
        xml.append("  </jobstatuslist>").append(Const.CR);
        xml.append("</serverstatus>").append(Const.CR);
        return xml.toString();
    }

    public SlaveServerStatus(Node statusNode) throws KettleException {
        this();
        int i;
        this.statusDescription = XMLHandler.getTagValue((Node)statusNode, (String)"statusdesc");
        Node listTransNode = XMLHandler.getSubNode((Node)statusNode, (String)"transstatuslist");
        Node listJobsNode = XMLHandler.getSubNode((Node)statusNode, (String)"jobstatuslist");
        int nrTrans = XMLHandler.countNodes((Node)listTransNode, (String)"transstatus");
        int nrJobs = XMLHandler.countNodes((Node)listJobsNode, (String)"jobstatus");
        for (i = 0; i < nrTrans; ++i) {
            Node transStatusNode = XMLHandler.getSubNodeByNr((Node)listTransNode, (String)"transstatus", (int)i);
            this.transStatusList.add(new SlaveServerTransStatus(transStatusNode));
        }
        for (i = 0; i < nrJobs; ++i) {
            Node jobStatusNode = XMLHandler.getSubNodeByNr((Node)listJobsNode, (String)"jobstatus", (int)i);
            this.jobStatusList.add(new SlaveServerJobStatus(jobStatusNode));
        }
    }

    public static SlaveServerStatus fromXML(String xml) throws KettleException {
        Document document = XMLHandler.loadXMLString((String)xml);
        return new SlaveServerStatus(XMLHandler.getSubNode((Node)document, (String)XML_TAG));
    }

    public String getStatusDescription() {
        return this.statusDescription;
    }

    public void setStatusDescription(String statusDescription) {
        this.statusDescription = statusDescription;
    }

    public List<SlaveServerTransStatus> getTransStatusList() {
        return this.transStatusList;
    }

    public void setTransStatusList(List<SlaveServerTransStatus> transStatusList) {
        this.transStatusList = transStatusList;
    }

    public String getErrorDescription() {
        return this.errorDescription;
    }

    public void setErrorDescription(String errorDescription) {
        this.errorDescription = errorDescription;
    }

    public SlaveServerTransStatus findTransStatus(String transName, String id) {
        for (int i = 0; i < this.transStatusList.size(); ++i) {
            SlaveServerTransStatus transStatus = this.transStatusList.get(i);
            if (!transStatus.getTransName().equalsIgnoreCase(transName) || !Const.isEmpty((String)id) && !transStatus.getId().equals(id)) continue;
            return transStatus;
        }
        return null;
    }

    public SlaveServerJobStatus findJobStatus(String jobName, String id) {
        for (int i = 0; i < this.jobStatusList.size(); ++i) {
            SlaveServerJobStatus jobStatus = this.jobStatusList.get(i);
            if (!jobStatus.getJobName().equalsIgnoreCase(jobName) || !Const.isEmpty((String)id) && !jobStatus.getId().equals(id)) continue;
            return jobStatus;
        }
        return null;
    }

    public List<SlaveServerJobStatus> getJobStatusList() {
        return this.jobStatusList;
    }

    public void setJobStatusList(List<SlaveServerJobStatus> jobStatusList) {
        this.jobStatusList = jobStatusList;
    }
}

