/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.util.HashMap;
import java.util.Map;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.www.SocketRepositoryEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SocketRepository {
    private Map<Integer, SocketRepositoryEntry> socketMap;
    private LogChannelInterface log;

    public SocketRepository(LogChannelInterface log) {
        this.log = log;
        this.socketMap = new HashMap<Integer, SocketRepositoryEntry>();
    }

    public synchronized ServerSocket openServerSocket(int port, String user) throws IOException {
        SocketRepositoryEntry entry = this.socketMap.get(port);
        if (entry == null) {
            ServerSocket serverSocket = new ServerSocket();
            serverSocket.setPerformancePreferences(1, 2, 3);
            serverSocket.setReuseAddress(true);
            try {
                serverSocket.bind(new InetSocketAddress(port));
            }
            catch (BindException e) {
                long totalWait = 0L;
                long startTime = System.currentTimeMillis();
                IOException ioException = null;
                this.log.logMinimal("Carte socket repository : Starting a retry loop to bind the server socket on port " + port + ".  We retry for 5 minutes until the socket clears in your operating system.");
                while (!serverSocket.isBound() && totalWait < 300000L) {
                    try {
                        totalWait = System.currentTimeMillis() - startTime;
                        this.log.logMinimal("Carte socket repository : Retry binding the server socket on port " + port + " after a " + totalWait / 1000L + " seconds wait...");
                        Thread.sleep(10000L);
                        serverSocket.bind(new InetSocketAddress(port), 100);
                    }
                    catch (IOException ioe) {
                        ioException = ioe;
                    }
                    catch (Exception ex) {
                        throw new IOException(ex.getMessage());
                    }
                    totalWait = System.currentTimeMillis() - startTime;
                }
                if (!serverSocket.isBound()) {
                    throw ioException;
                }
                this.log.logDetailed("Carte socket repository : Succesfully bound the server socket on port " + port + " after " + totalWait / 1000L + " seconds.");
            }
            entry = new SocketRepositoryEntry(port, serverSocket, true, user);
            this.socketMap.put(port, entry);
        } else {
            if (entry.isInUse()) {
                throw new IOException("Server socket on port " + port + " is already in use by [" + entry.getUser() + "]");
            }
            entry.setInUse(true);
        }
        return entry.getServerSocket();
    }

    public synchronized void releaseSocket(int port) throws IOException {
        SocketRepositoryEntry entry = this.socketMap.get(port);
        if (entry == null) {
            throw new IOException("Port to close was not found in the Carte socket repository!");
        }
        entry.setInUse(false);
    }

    public Map<Integer, SocketRepositoryEntry> getSocketMap() {
        return this.socketMap;
    }

    public void setSocketMap(Map<Integer, SocketRepositoryEntry> socketMap) {
        this.socketMap = socketMap;
    }

    public synchronized void closeAll() {
        for (SocketRepositoryEntry entry : this.socketMap.values()) {
            ServerSocket serverSocket = entry.getServerSocket();
            try {
                if (serverSocket == null) continue;
                serverSocket.close();
            }
            catch (IOException e) {
                this.log.logError("Carte socket repository : Failed to close socket during shutdown", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void finalize() throws Throwable {
        try {
            try {
                this.closeAll();
            }
            catch (Exception exception) {
                Object var3_2 = null;
                super.finalize();
                return;
            }
            Object var3_1 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            super.finalize();
            throw throwable;
        }
        super.finalize();
    }
}

