/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.CentralLogStore;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.logging.LoggingObjectType;
import org.pentaho.di.core.logging.SimpleLoggingObject;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.www.BaseHttpServlet;
import org.pentaho.di.www.CarteObjectEntry;
import org.pentaho.di.www.CarteServletInterface;
import org.pentaho.di.www.TransformationMap;
import org.pentaho.di.www.WebResult;

public class StartTransServlet
extends BaseHttpServlet
implements CarteServletInterface {
    private static Class<?> PKG = StartTransServlet.class;
    private static final long serialVersionUID = -5879200987669847357L;
    public static final String CONTEXT_PATH = "/kettle/startTrans";

    public StartTransServlet() {
    }

    public StartTransServlet(TransformationMap transformationMap) {
        super(transformationMap);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.isJettyMode() && !request.getContextPath().startsWith(CONTEXT_PATH)) {
            return;
        }
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"StartTransServlet.Log.StartTransRequested", (String[])new String[0]));
        }
        String transName = request.getParameter("name");
        String id = request.getParameter("id");
        if (StringUtils.isEmpty((String)transName)) {
            transName = "";
        }
        boolean useXML = "Y".equalsIgnoreCase(request.getParameter("xml"));
        response.setStatus(200);
        PrintWriter out = response.getWriter();
        if (useXML) {
            response.setContentType("text/xml");
            response.setCharacterEncoding("UTF-8");
            out.print(XMLHandler.getXMLHeader((String)"UTF-8"));
        } else {
            response.setContentType("text/html;charset=UTF-8");
            out.println("<HTML>");
            out.println("<HEAD>");
            out.println("<TITLE>" + BaseMessages.getString(PKG, (String)"StartTransServlet.Log.StartOfTrans", (String[])new String[0]) + "</TITLE>");
            out.println("<META http-equiv=\"Refresh\" content=\"2;url=" + this.convertContextPath("/kettle/transStatus") + "?name=" + URLEncoder.encode(transName, "UTF-8") + "\">");
            out.println("<META http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">");
            out.println("</HEAD>");
            out.println("<BODY>");
        }
        try {
            Trans trans;
            if (Const.isEmpty((String)id)) {
                CarteObjectEntry entry = this.getTransformationMap().getFirstCarteObjectEntry(transName);
                if (entry == null) {
                    trans = null;
                } else {
                    id = entry.getId();
                    trans = this.getTransformationMap().getTransformation(entry);
                }
            } else {
                CarteObjectEntry entry = new CarteObjectEntry(transName, id);
                trans = this.getTransformationMap().getTransformation(entry);
            }
            if (trans != null) {
                CentralLogStore.discardLines(trans.getLogChannelId(), true);
                String carteObjectId = UUID.randomUUID().toString();
                SimpleLoggingObject servletLoggingObject = new SimpleLoggingObject(CONTEXT_PATH, LoggingObjectType.CARTE, null);
                servletLoggingObject.setContainerObjectId(carteObjectId);
                servletLoggingObject.setLogLevel(trans.getLogLevel());
                trans.setParent((LoggingObjectInterface)servletLoggingObject);
                this.executeTrans(trans);
                String message = BaseMessages.getString(PKG, (String)"StartTransServlet.Log.TransStarted", (String[])new String[]{transName});
                if (useXML) {
                    out.println(new WebResult("OK", message).getXML());
                } else {
                    out.println("<H1>" + message + "</H1>");
                    out.println("<a href=\"" + this.convertContextPath("/kettle/transStatus") + "?name=" + URLEncoder.encode(transName, "UTF-8") + "&id=" + id + "\">" + BaseMessages.getString(PKG, (String)"TransStatusServlet.BackToStatusPage", (String[])new String[0]) + "</a><p>");
                }
            } else {
                String message = BaseMessages.getString(PKG, (String)"TransStatusServlet.Log.CoundNotFindSpecTrans", (String[])new String[]{transName});
                if (useXML) {
                    out.println(new WebResult("ERROR", message, id));
                } else {
                    out.println("<H1>" + message + "</H1>");
                    out.println("<a href=\"" + this.convertContextPath("/kettle/status") + "\">" + BaseMessages.getString(PKG, (String)"TransStatusServlet.BackToStatusPage", (String[])new String[0]) + "</a><p>");
                }
            }
        }
        catch (Exception ex) {
            if (useXML) {
                out.println(new WebResult("ERROR", BaseMessages.getString(PKG, (String)"StartTransServlet.Error.UnexpectedError", (String[])new String[]{Const.CR + Const.getStackTracker((Throwable)ex)})));
            }
            out.println("<p>");
            out.println("<pre>");
            ex.printStackTrace(out);
            out.println("</pre>");
        }
        if (!useXML) {
            out.println("<p>");
            out.println("</BODY>");
            out.println("</HTML>");
        }
    }

    public String toString() {
        return "Start transformation";
    }

    public String getService() {
        return "/kettle/startTrans (" + this.toString() + ")";
    }

    protected void executeTrans(Trans trans) throws KettleException {
        trans.execute(null);
    }
}

