/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop;

import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;

public class HadoopCompression {
    public static final int IO_COMPRESSION_CODEC_SNAPPY_DEFAULT_BUFFERSIZE = 262144;
    private static final String HADOOP_CONFIG_UTIL_CLASS = "org.apache.hadoop.hive.jdbc.HadoopConfigurationUtil";
    private static final String GET_ACTIVE_CONFIGURATION_METHOD = "getActiveConfiguration";
    private static final String GET_SNAPPY_SHIM = "getSnappyShim";

    private static Object getActiveSnappyShim() throws Exception {
        Class<?> hadoopConfigUtilClass = Class.forName(HADOOP_CONFIG_UTIL_CLASS);
        Method getActiveConfiguration = hadoopConfigUtilClass.getMethod(GET_ACTIVE_CONFIGURATION_METHOD, new Class[0]);
        Object hadoopConfiguration = getActiveConfiguration.invoke(null, new Object[0]);
        Method getSnappyShim = hadoopConfiguration.getClass().getMethod(GET_SNAPPY_SHIM, new Class[0]);
        return getSnappyShim.invoke(hadoopConfiguration, new Object[0]);
    }

    public static boolean isHadoopSnappyAvailable() {
        try {
            Object snappyShim = HadoopCompression.getActiveSnappyShim();
            Method m = snappyShim.getClass().getMethod("isHadoopSnappyAvailable", new Class[0]);
            return (Boolean)m.invoke(snappyShim, new Object[0]);
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static InputStream getSnappyInputStream(InputStream in) throws Exception {
        return HadoopCompression.getSnappyInputStream(262144, in);
    }

    public static InputStream getSnappyInputStream(int bufferSize, InputStream in) throws Exception {
        if (!HadoopCompression.isHadoopSnappyAvailable()) {
            throw new Exception("Hadoop-snappy does not seem to be available");
        }
        Object snappyShim = HadoopCompression.getActiveSnappyShim();
        Method getSnappyInputStream = snappyShim.getClass().getMethod("getSnappyInputStream", Integer.TYPE, InputStream.class);
        return (InputStream)getSnappyInputStream.invoke(snappyShim, bufferSize, in);
    }

    public OutputStream getSnappyOutputStream(OutputStream out) throws Exception {
        return HadoopCompression.getSnappyOutputStream(262144, out);
    }

    public static OutputStream getSnappyOutputStream(int bufferSize, OutputStream out) throws Exception {
        if (!HadoopCompression.isHadoopSnappyAvailable()) {
            throw new Exception("Hadoop-snappy does not seem to be available");
        }
        Object snappyShim = HadoopCompression.getActiveSnappyShim();
        Method getSnappyOutputStream = snappyShim.getClass().getMethod("getSnappyOutputStream", Integer.TYPE, OutputStream.class);
        return (OutputStream)getSnappyOutputStream.invoke(snappyShim, bufferSize, out);
    }
}

