/*
 * Decompiled with CFR 0.152.
 */
package org.productivity.java.syslog4j.server.impl.event.structured;

import java.net.InetAddress;
import org.productivity.java.syslog4j.impl.message.structured.StructuredSyslogMessage;
import org.productivity.java.syslog4j.server.impl.event.SyslogServerEvent;
import org.productivity.java.syslog4j.util.RFC3339TimestampUtility;

public class StructuredSyslogServerEvent
extends SyslogServerEvent {
    private static final long serialVersionUID = 1676499796406044315L;
    protected String applicationName = "unknown";
    protected String processId = null;

    public StructuredSyslogServerEvent(byte[] byArray, int n, InetAddress inetAddress) {
        this.initialize(byArray, n, inetAddress);
        this.parse();
    }

    protected void parseApplicationName() {
        int n = this.message.indexOf(32);
        if (n > -1) {
            this.applicationName = this.message.substring(0, n).trim();
            this.message = this.message.substring(n + 1);
            this.parseProcessId();
        }
        if ("-".equals(this.applicationName)) {
            this.applicationName = null;
        }
    }

    protected void parseProcessId() {
        int n = this.message.indexOf(32);
        if (n > -1) {
            this.processId = this.message.substring(0, n).trim();
            this.message = this.message.substring(n + 1);
        }
        if ("-".equals(this.processId)) {
            this.processId = null;
        }
    }

    protected void parseDate() {
        int n = this.message.indexOf(32);
        this.message = this.message.substring(n + 1);
        n = this.message.indexOf(32);
        if (n > -1) {
            String string = this.message.substring(0, n).trim();
            try {
                this.date = RFC3339TimestampUtility.parse(string);
                this.message = this.message.substring(string.length() + 1);
            }
            catch (Exception exception) {
                super.parseDate();
            }
        }
    }

    protected void parseHost() {
        int n = this.message.indexOf(32);
        if (n > -1) {
            this.host = this.message.substring(0, n).trim();
            this.message = this.message.substring(n + 1);
        }
        if ("-".equals(this.host)) {
            this.host = null;
        }
        this.parseApplicationName();
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getProcessId() {
        return this.processId;
    }

    public StructuredSyslogMessage getStructuredMessage() {
        try {
            return StructuredSyslogMessage.fromString(this.getMessage());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return new StructuredSyslogMessage(null, null, this.getMessage());
        }
    }
}

