/*
 * Decompiled with CFR 0.152.
 */
package org.productivity.java.syslog4j.server.impl.net.udp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.List;
import org.productivity.java.syslog4j.SyslogRuntimeException;
import org.productivity.java.syslog4j.server.SyslogServerEventHandlerIF;
import org.productivity.java.syslog4j.server.SyslogServerEventIF;
import org.productivity.java.syslog4j.server.impl.AbstractSyslogServer;

public class UDPNetSyslogServer
extends AbstractSyslogServer {
    protected DatagramSocket ds = null;

    public void initialize() throws SyslogRuntimeException {
    }

    public void shutdown() {
        super.shutdown();
        if (this.syslogServerConfig.getShutdownWait() > 0) {
            try {
                Thread.sleep(this.syslogServerConfig.getShutdownWait());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.ds != null && !this.ds.isClosed()) {
            this.ds.close();
        }
    }

    protected DatagramSocket createDatagramSocket() throws SocketException, UnknownHostException {
        DatagramSocket datagramSocket = null;
        if (this.syslogServerConfig.getHost() != null) {
            InetAddress inetAddress = InetAddress.getByName(this.syslogServerConfig.getHost());
            datagramSocket = new DatagramSocket(this.syslogServerConfig.getPort(), inetAddress);
        } else {
            datagramSocket = new DatagramSocket(this.syslogServerConfig.getPort());
        }
        return datagramSocket;
    }

    public void run() {
        try {
            this.ds = this.createDatagramSocket();
            this.shutdown = false;
        }
        catch (SocketException socketException) {
            return;
        }
        catch (UnknownHostException unknownHostException) {
            return;
        }
        byte[] byArray = new byte[1024];
        while (!this.shutdown) {
            try {
                DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
                this.ds.receive(datagramPacket);
                SyslogServerEventIF syslogServerEventIF = UDPNetSyslogServer.createEvent(this.getConfig(), byArray, datagramPacket.getLength(), datagramPacket.getAddress());
                List list = this.syslogServerConfig.getEventHandlers();
                for (int i = 0; i < list.size(); ++i) {
                    SyslogServerEventHandlerIF syslogServerEventHandlerIF = (SyslogServerEventHandlerIF)list.get(i);
                    syslogServerEventHandlerIF.event(this, syslogServerEventIF);
                }
            }
            catch (SocketException socketException) {
            }
            catch (IOException iOException) {
            }
        }
    }
}

