/*
 * Decompiled with CFR 0.152.
 */
package org.ftp4che.commands;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PipedInputStream;
import java.nio.ByteBuffer;
import org.ftp4che.commands.DataConnectionCommand;
import org.ftp4che.io.ReplyWorker;
import org.ftp4che.reply.Reply;
import org.ftp4che.util.ftpfile.FTPFile;

public class RetrieveCommand
extends DataConnectionCommand {
    public static final int FILE_BASED = 0;
    public static final int STREAM_BASED = 1;
    public static final int BYTEBUFFER_BASED = 2;
    private FTPFile fromFile;
    private FTPFile toFile;
    private PipedInputStream inputPipe;
    private ByteBuffer byteBuffer;
    private long resumePosition = -1L;

    public RetrieveCommand(String command, FTPFile fromFile) {
        super(command, fromFile.getName());
        this.setFromFile(fromFile);
    }

    public RetrieveCommand(String command, FTPFile fromFile, FTPFile toFile) {
        super(command, fromFile.toString());
        this.setFromFile(fromFile);
        this.setToFile(toFile);
    }

    public RetrieveCommand(String command, FTPFile fromFile, PipedInputStream is) {
        super(command, fromFile.toString());
        this.setFromFile(fromFile);
        this.setInputPipe(is);
    }

    public RetrieveCommand(String command, FTPFile fromFile, ByteBuffer bb) {
        super(command, fromFile.toString());
        this.setFromFile(fromFile);
        this.setByteBuffer(bb);
    }

    public Reply fetchDataConnectionReply() throws FileNotFoundException, IOException {
        return this.fetchDataConnectionReply(0);
    }

    public Reply fetchDataConnectionReply(int method) throws FileNotFoundException, IOException {
        ReplyWorker worker = null;
        switch (method) {
            case 1: {
                worker = new ReplyWorker(this.getDataSocket(), this, this.inputPipe, method);
                break;
            }
            case 2: {
                worker = new ReplyWorker(this.getDataSocket(), this, this.byteBuffer, method);
                break;
            }
            default: {
                worker = new ReplyWorker(this.getDataSocket(), this, null, 0);
            }
        }
        worker.start();
        while (worker.getStatus() == -1) {
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (worker.getStatus() == 1) {
            return worker.getReply();
        }
        if (worker.getCaughtException() instanceof FileNotFoundException) {
            throw (FileNotFoundException)worker.getCaughtException();
        }
        throw (IOException)worker.getCaughtException();
    }

    public FTPFile getFromFile() {
        return this.fromFile;
    }

    public void setFromFile(FTPFile file) {
        this.fromFile = file;
    }

    public FTPFile getToFile() {
        return this.toFile;
    }

    public void setToFile(FTPFile toFile) {
        this.toFile = toFile;
    }

    public long getResumePosition() {
        return this.resumePosition;
    }

    public void setResumePosition(long resumePosition) {
        this.resumePosition = resumePosition;
    }

    public void setInputPipe(PipedInputStream inputPipe) {
        this.inputPipe = inputPipe;
    }

    public void setByteBuffer(ByteBuffer byteBuffer) {
        this.byteBuffer = byteBuffer;
    }
}

