/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data;

import com.google.gdata.data.TextConstruct;
import com.google.gdata.util.Namespaces;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.XmlBlob;
import com.google.gdata.util.XmlParser;
import com.google.gdata.util.common.html.HtmlToText;
import com.google.gdata.util.common.xml.XmlWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;

public class XhtmlTextConstruct
extends TextConstruct {
    protected XmlBlob xhtml;

    public XhtmlTextConstruct() {
    }

    public XhtmlTextConstruct(XmlBlob xhtml) {
        this.xhtml = xhtml;
    }

    public XhtmlTextConstruct(XmlBlob xhtml, String lang) {
        this.xhtml = xhtml;
        this.lang = lang;
    }

    public int getType() {
        return 3;
    }

    public boolean isEmpty() {
        return this.xhtml == null;
    }

    public XmlBlob getXhtml() {
        if (this.xhtml == null) {
            this.xhtml = new XmlBlob();
        }
        return this.xhtml;
    }

    public void setXhtml(XmlBlob v) {
        this.xhtml = v;
    }

    public String getPlainText() {
        if (this.xhtml == null) {
            return null;
        }
        try {
            StringWriter sw = new StringWriter();
            XmlWriter xw = new XmlWriter(sw);
            xw.innerXml(this.xhtml.getBlob());
            return HtmlToText.htmlToPlainText(sw.toString());
        }
        catch (IOException e) {
            return null;
        }
    }

    public void generateAtom(XmlWriter w, String elementName) throws IOException {
        ArrayList<XmlWriter.Attribute> attrs = new ArrayList<XmlWriter.Attribute>(2);
        attrs.add(new XmlWriter.Attribute("type", "xhtml"));
        if (this.lang != null) {
            attrs.add(new XmlWriter.Attribute("xml:lang", this.lang));
        }
        XmlBlob.startElement(w, Namespaces.atomNs, elementName, this.xhtml, attrs, null);
        XmlBlob.endElement(w, Namespaces.atomNs, elementName, this.xhtml);
    }

    public void generateRss(XmlWriter w, String elementName, TextConstruct.RssFormat rssFormat) throws IOException {
        switch (rssFormat) {
            case FULL_HTML: {
                StringWriter sw = new StringWriter();
                XmlWriter xw = new XmlWriter(sw);
                xw.innerXml(this.xhtml.getBlob());
                w.simpleElement(Namespaces.rssNs, elementName, null, sw.toString());
                break;
            }
            case PLAIN_TEXT: {
                w.simpleElement(Namespaces.rssNs, elementName, null, this.getPlainText());
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    public class AtomHandler
    extends XmlParser.ElementHandler {
        public AtomHandler() throws IOException {
            XhtmlTextConstruct.this.xhtml = new XmlBlob();
            this.initializeXmlBlob(XhtmlTextConstruct.this.xhtml, true, true);
            XhtmlTextConstruct.this.lang = this.xmlLang;
        }

        public void processAttribute(String namespace, String localName, String value) throws ParseException {
            if (namespace.equals("http://www.w3.org/XML/1998/namespace") && localName.equals("lang")) {
                XhtmlTextConstruct.this.lang = this.xmlLang;
            }
        }
    }
}

