/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.wireformats;

import com.google.common.collect.Maps;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.model.ElementMetadata;
import com.google.gdata.util.ContentType;
import com.google.gdata.wireformats.AltRegistry;
import com.google.gdata.wireformats.StreamProperties;
import java.util.Collection;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StreamPropertiesBuilder<T extends StreamPropertiesBuilder<T>> {
    protected AltRegistry altRegistry;
    protected ContentType contentType;
    protected ExtensionProfile extensionProfile;
    protected ElementMetadata<?, ?> rootMetadata;
    protected final Map<String, String> queryMap;

    protected StreamPropertiesBuilder() {
        this.queryMap = Maps.newHashMap();
    }

    protected StreamPropertiesBuilder(StreamProperties source) {
        this.altRegistry = source.getAltRegistry();
        this.contentType = source.getContentType();
        this.extensionProfile = source.getExtensionProfile();
        this.rootMetadata = source.getRootMetadata();
        this.queryMap = Maps.newHashMap();
        for (String name : source.getQueryParameterNames()) {
            this.queryMap.put(name, source.getQueryParameter(name));
        }
    }

    public final T thisInstance() {
        return (T)this;
    }

    public T setAltRegistry(AltRegistry altRegistry) {
        this.altRegistry = altRegistry;
        return this.thisInstance();
    }

    public T setContentType(ContentType contentType) {
        this.contentType = contentType;
        return this.thisInstance();
    }

    public T setExtensionProfile(ExtensionProfile extensionProfile) {
        this.extensionProfile = extensionProfile;
        return this.thisInstance();
    }

    public T setQueryParameter(String name, String value) {
        ((StreamPropertiesBuilder)this.thisInstance()).queryMap.put(name, value);
        return this.thisInstance();
    }

    public T setQueryParameters(Map<String, String> queryMap) {
        this.queryMap.putAll(queryMap);
        return this.thisInstance();
    }

    public T setElementMetadata(ElementMetadata<?, ?> elementMetadata) {
        this.rootMetadata = elementMetadata;
        return this.thisInstance();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class StreamPropertiesImpl
    implements StreamProperties {
        private final AltRegistry altRegistry;
        private final ContentType contentType;
        private final ExtensionProfile extensionProfile;
        private final Map<String, String> queryMap;
        private final ElementMetadata<?, ?> elementMetadata;

        protected StreamPropertiesImpl(StreamPropertiesBuilder<?> builder) {
            this.altRegistry = builder.altRegistry;
            this.contentType = builder.contentType;
            this.extensionProfile = builder.extensionProfile;
            this.queryMap = builder.queryMap;
            this.elementMetadata = builder.rootMetadata;
        }

        @Override
        public AltRegistry getAltRegistry() {
            return this.altRegistry;
        }

        @Override
        public ContentType getContentType() {
            return this.contentType;
        }

        @Override
        public ExtensionProfile getExtensionProfile() {
            return this.extensionProfile;
        }

        @Override
        public Collection<String> getQueryParameterNames() {
            return this.queryMap.keySet();
        }

        @Override
        public String getQueryParameter(String name) {
            return this.queryMap.get(name);
        }

        @Override
        public ElementMetadata<?, ?> getRootMetadata() {
            return this.elementMetadata;
        }
    }
}

