/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.function;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.pentaho.reporting.libraries.formula.function.FunctionDescription;

public abstract class AbstractFunctionDescription
implements FunctionDescription {
    private String bundleName;
    private String cannonicalName;
    private static final long serialVersionUID = 6174633076234746415L;

    protected AbstractFunctionDescription(String cannonicalName, String bundleName) {
        if (bundleName == null) {
            throw new NullPointerException();
        }
        if (cannonicalName == null) {
            throw new NullPointerException();
        }
        this.bundleName = bundleName;
        this.cannonicalName = cannonicalName;
    }

    public String getCanonicalName() {
        return this.cannonicalName;
    }

    public boolean isVolatile() {
        return false;
    }

    public Object getDefaultValue(int position) {
        return null;
    }

    public boolean isInfiniteParameterCount() {
        return false;
    }

    protected ResourceBundle getBundle(Locale locale) {
        try {
            return ResourceBundle.getBundle(this.bundleName, locale);
        }
        catch (MissingResourceException mre) {
            return ResourceBundle.getBundle(this.bundleName, Locale.ENGLISH);
        }
    }

    public String getDisplayName(Locale locale) {
        return this.getBundle(locale).getString("display-name");
    }

    public String getDescription(Locale locale) {
        return this.getBundle(locale).getString("description");
    }

    public String getParameterDisplayName(int position, Locale locale) {
        return this.getBundle(locale).getString("parameter." + position + ".display-name");
    }

    public String getParameterDescription(int position, Locale locale) {
        return this.getBundle(locale).getString("parameter." + position + ".description");
    }

    public boolean isDeprecated() {
        return false;
    }

    public boolean isExperimental() {
        return false;
    }
}

