/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.function.information;

import java.math.BigDecimal;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.ArrayCallback;
import org.pentaho.reporting.libraries.formula.typing.Sequence;
import org.pentaho.reporting.libraries.formula.typing.coretypes.NumberType;
import org.pentaho.reporting.libraries.formula.typing.sequence.RecursiveSequence;

public class CountAFunction
implements Function {
    public String getCanonicalName() {
        return "COUNTA";
    }

    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        int parameterCount = parameters.getParameterCount();
        if (parameterCount == 0) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        int count = 0;
        for (int paramIdx = 0; paramIdx < parameterCount; ++paramIdx) {
            try {
                Object value = parameters.getValue(paramIdx);
                RecursiveSequence sequence = new RecursiveSequence(value, context);
                while (sequence.hasNext()) {
                    Object o = sequence.next();
                    count += this.countElement(o);
                }
                continue;
            }
            catch (EvaluationException e) {
                ++count;
            }
        }
        return new TypeValuePair(NumberType.GENERIC_NUMBER, new BigDecimal(count));
    }

    private int countElement(Object o) throws EvaluationException {
        int count = 0;
        if (o instanceof ArrayCallback) {
            ArrayCallback callback = (ArrayCallback)o;
            int rowCount = callback.getRowCount();
            int colCount = callback.getColumnCount();
            for (int r = 0; r < rowCount; ++r) {
                for (int c = 0; c < colCount; ++c) {
                    Object val = callback.getValue(r, c);
                    if (val == null) continue;
                    count += this.countElement(val);
                }
            }
        } else if (o instanceof Sequence) {
            Sequence s = (Sequence)o;
            while (s.hasNext()) {
                count += this.countElement(s.next());
            }
        } else if (o != null) {
            ++count;
        }
        return count;
    }
}

