/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.function.text;

import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.TypeRegistry;
import org.pentaho.reporting.libraries.formula.typing.coretypes.TextType;

public class CleanFunction
implements Function {
    public String getCanonicalName() {
        return "CLEAN";
    }

    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        int parameterCount = parameters.getParameterCount();
        if (parameterCount < 1 || parameterCount > 2) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        Type type1 = parameters.getType(0);
        Object value1 = parameters.getValue(0);
        TypeRegistry typeRegistry = context.getTypeRegistry();
        String result = typeRegistry.convertToText(type1, value1);
        if (result == null) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
        }
        if (parameterCount == 2) {
            Type typeEncoding = parameters.getType(1);
            Object valueEncoding = parameters.getValue(1);
            result = this.pruneUnprintableChars(typeRegistry, result, typeEncoding, valueEncoding);
        }
        char[] chars = result.toCharArray();
        StringBuffer b = new StringBuffer(chars.length);
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            this.convert(c, b);
        }
        return new TypeValuePair(TextType.TYPE, b.toString());
    }

    private String pruneUnprintableChars(TypeRegistry typeRegistry, String result, Type typeEncoding, Object valueEncoding) throws EvaluationException {
        String encoding = typeRegistry.convertToText(typeEncoding, valueEncoding);
        if (StringUtils.isEmpty((String)encoding)) {
            return result;
        }
        if (!Charset.isSupported(encoding)) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
        }
        Charset charset = Charset.forName(encoding);
        if (charset.canEncode()) {
            CharsetEncoder charsetEncoder = charset.newEncoder();
            char[] chars = result.toCharArray();
            StringBuilder b = new StringBuilder(chars.length);
            for (int i = 0; i < chars.length; ++i) {
                char c = chars[i];
                if (!charsetEncoder.canEncode(c)) continue;
                b.append(c);
            }
            return b.toString();
        }
        return result;
    }

    private void convert(char c, StringBuffer b) {
        if (Character.isISOControl(c) || Character.getType(c) == 0) {
            return;
        }
        b.append(c);
    }
}

