/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.lvalues;

import java.util.ArrayList;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.lvalues.AbstractLValue;
import org.pentaho.reporting.libraries.formula.lvalues.LValue;
import org.pentaho.reporting.libraries.formula.lvalues.ParsePosition;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.operators.InfixOperator;

public class Term
extends AbstractLValue {
    private static final LValue[] EMPTY_L_VALUE = new LValue[0];
    private static final InfixOperator[] EMPTY_OPERATOR = new InfixOperator[0];
    private static final long serialVersionUID = -1854082494425470979L;
    private LValue optimizedHeadValue;
    private LValue headValue;
    private ArrayList operators;
    private ArrayList operands;
    private InfixOperator[] operatorArray;
    private LValue[] operandsArray;
    private boolean initialized;

    public Term(LValue headValue) {
        if (headValue == null) {
            throw new NullPointerException();
        }
        this.headValue = headValue;
    }

    public TypeValuePair evaluate() throws EvaluationException {
        TypeValuePair result = this.optimizedHeadValue.evaluate();
        for (int i = 0; i < this.operandsArray.length; ++i) {
            LValue value = this.operandsArray[i];
            InfixOperator op = this.operatorArray[i];
            result = op.evaluate(this.getContext(), result, value.evaluate());
        }
        return result;
    }

    public void add(InfixOperator operator, LValue operand) {
        if (operator == null) {
            throw new NullPointerException();
        }
        if (operand == null) {
            throw new NullPointerException();
        }
        if (this.operands == null || this.operators == null) {
            this.operands = new ArrayList();
            this.operators = new ArrayList();
        }
        this.operands.add(operand);
        this.operators.add(operator);
        this.initialized = false;
    }

    public void initialize(FormulaContext context) throws EvaluationException {
        super.initialize(context);
        if (this.operands == null || this.operators == null) {
            this.optimizedHeadValue = this.headValue;
            this.optimizedHeadValue.initialize(context);
            this.operandsArray = EMPTY_L_VALUE;
            this.operatorArray = EMPTY_OPERATOR;
            return;
        }
        if (this.initialized) {
            this.optimizedHeadValue.initialize(context);
            for (int i = 0; i < this.operandsArray.length; ++i) {
                LValue lValue = this.operandsArray[i];
                lValue.initialize(context);
            }
            return;
        }
        this.optimize();
        this.optimizedHeadValue.initialize(context);
        for (int i = 0; i < this.operandsArray.length; ++i) {
            LValue value = this.operandsArray[i];
            value.initialize(context);
        }
        this.initialized = true;
    }

    private void optimize() {
        if (this.operands == null || this.operators == null) {
            this.optimizedHeadValue = this.headValue;
            this.operandsArray = EMPTY_L_VALUE;
            this.operatorArray = EMPTY_OPERATOR;
            return;
        }
        ArrayList operators = (ArrayList)this.operators.clone();
        ArrayList operands = (ArrayList)this.operands.clone();
        this.optimizedHeadValue = this.headValue;
        block0: while (true) {
            InfixOperator op = (InfixOperator)operators.get(0);
            int level = op.getLevel();
            boolean moreThanOne = false;
            for (int i = 1; i < operators.size(); ++i) {
                InfixOperator operator = (InfixOperator)operators.get(i);
                int opLevel = operator.getLevel();
                if (opLevel == level) continue;
                moreThanOne = true;
                level = Math.min(opLevel, level);
            }
            if (!moreThanOne) break;
            Term subTerm = null;
            int i = 0;
            while (true) {
                if (i >= operators.size()) continue block0;
                InfixOperator operator = (InfixOperator)operators.get(i);
                if (operator.getLevel() != level) {
                    subTerm = null;
                } else {
                    if (subTerm == null) {
                        if (i == 0) {
                            subTerm = new Term(this.optimizedHeadValue);
                            this.optimizedHeadValue = subTerm;
                        } else {
                            LValue lval = (LValue)operands.get(i - 1);
                            subTerm = new Term(lval);
                            operands.set(i - 1, subTerm);
                        }
                    }
                    LValue operand = (LValue)operands.get(i);
                    subTerm.add(operator, operand);
                    operands.remove(i);
                    operators.remove(i);
                    --i;
                }
                ++i;
            }
            break;
        }
        this.operatorArray = operators.toArray(new InfixOperator[operators.size()]);
        this.operandsArray = operands.toArray(new LValue[operands.size()]);
    }

    public LValue[] getChildValues() {
        if (this.operandsArray == null) {
            this.optimize();
        }
        LValue[] values = new LValue[this.operandsArray.length + 1];
        values[0] = this.headValue;
        System.arraycopy(this.operandsArray, 0, values, 1, this.operandsArray.length);
        return values;
    }

    public String toString() {
        StringBuilder b = new StringBuilder(100);
        b.append('(');
        b.append(this.headValue);
        if (this.operands != null && this.operators != null) {
            for (int i = 0; i < this.operands.size(); ++i) {
                InfixOperator op = (InfixOperator)this.operators.get(i);
                LValue value = (LValue)this.operands.get(i);
                b.append(op);
                b.append(value);
            }
        }
        b.append(')');
        return b.toString();
    }

    public boolean isConstant() {
        if (!this.headValue.isConstant()) {
            return false;
        }
        for (int i = 0; i < this.operands.size(); ++i) {
            LValue value = (LValue)this.operands.get(i);
            if (value.isConstant()) continue;
            return false;
        }
        return true;
    }

    public Object clone() throws CloneNotSupportedException {
        Term o = (Term)super.clone();
        if (this.operands != null) {
            o.operands = (ArrayList)this.operands.clone();
        }
        if (this.operators != null) {
            o.operators = (ArrayList)this.operators.clone();
        }
        o.headValue = (LValue)this.headValue.clone();
        o.optimizedHeadValue = null;
        o.operandsArray = null;
        o.operatorArray = null;
        o.initialized = false;
        return o;
    }

    public LValue[] getOperands() {
        return this.operands.toArray(new LValue[this.operands.size()]);
    }

    public InfixOperator[] getOperators() {
        return this.operators.toArray(new InfixOperator[this.operators.size()]);
    }

    public LValue getHeadValue() {
        return this.headValue;
    }

    public LValue getOptimizedHeadValue() {
        return this.optimizedHeadValue;
    }

    public ParsePosition getParsePosition() {
        ParsePosition parsePosition = super.getParsePosition();
        if (parsePosition == null) {
            int startColumn = this.headValue.getParsePosition().getStartColumn();
            int startLine = this.headValue.getParsePosition().getStartLine();
            ParsePosition lastParsePos = this.operandsArray[this.operandsArray.length - 1].getParsePosition();
            int endColumn = lastParsePos.getEndColumn();
            int endLine = lastParsePos.getEndLine();
            this.setParsePosition(new ParsePosition(startLine, startColumn, endLine, endColumn));
        }
        return super.getParsePosition();
    }
}

