/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.parser;

public class TokenMgrError
extends Error {
    public static final int LEXICAL_ERROR = 0;
    public static final int STATIC_LEXER_ERROR = 1;
    public static final int INVALID_LEXICAL_STATE = 2;
    public static final int LOOP_DETECTED = 3;
    private static final long serialVersionUID = -4952285962531386774L;
    private int errorCode;
    private boolean EOFSeen;
    private int lexState;
    private int errorLine;
    private int errorColumn;
    private String errorAfter;
    private char curChar;
    private int reason;

    protected static String addEscapes(String str) {
        StringBuilder retval = new StringBuilder();
        block11: for (int i = 0; i < str.length(); ++i) {
            switch (str.charAt(i)) {
                case '\u0000': {
                    continue block11;
                }
                case '\b': {
                    retval.append("\\b");
                    continue block11;
                }
                case '\t': {
                    retval.append("\\t");
                    continue block11;
                }
                case '\n': {
                    retval.append("\\n");
                    continue block11;
                }
                case '\f': {
                    retval.append("\\f");
                    continue block11;
                }
                case '\r': {
                    retval.append("\\r");
                    continue block11;
                }
                case '\"': {
                    retval.append("\\\"");
                    continue block11;
                }
                case '\'': {
                    retval.append("\\'");
                    continue block11;
                }
                case '\\': {
                    retval.append("\\\\");
                    continue block11;
                }
                default: {
                    char ch = str.charAt(i);
                    if (ch < ' ' || ch > '~') {
                        String s = "0000" + Integer.toString(ch, 16);
                        retval.append("\\u" + s.substring(s.length() - 4, s.length()));
                        continue block11;
                    }
                    retval.append(ch);
                    continue block11;
                }
            }
        }
        return retval.toString();
    }

    protected static String LexicalError(boolean EOFSeen, int lexState, int errorLine, int errorColumn, String errorAfter, char curChar) {
        return "Lexical error at line " + errorLine + ", column " + errorColumn + ".  Encountered: " + (EOFSeen ? "<EOF> " : '\"' + TokenMgrError.addEscapes(String.valueOf(curChar)) + '\"' + " (" + curChar + "), ") + "after : \"" + TokenMgrError.addEscapes(errorAfter) + '\"';
    }

    public String getMessage() {
        return super.getMessage();
    }

    public TokenMgrError() {
    }

    public TokenMgrError(String message, int reason) {
        super(message);
        this.errorCode = reason;
    }

    public TokenMgrError(boolean EOFSeen, int lexState, int errorLine, int errorColumn, String errorAfter, char curChar, int reason) {
        this(TokenMgrError.LexicalError(EOFSeen, lexState, errorLine, errorColumn, errorAfter, curChar), reason);
        this.EOFSeen = EOFSeen;
        this.lexState = lexState;
        this.errorLine = errorLine;
        this.errorColumn = errorColumn;
        this.errorAfter = errorAfter;
        this.curChar = curChar;
        this.reason = reason;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public boolean isEOFSeen() {
        return this.EOFSeen;
    }

    public int getLexState() {
        return this.lexState;
    }

    public int getErrorLine() {
        return this.errorLine;
    }

    public int getErrorColumn() {
        return this.errorColumn;
    }

    public String getErrorAfter() {
        return this.errorAfter;
    }

    public char getCurChar() {
        return this.curChar;
    }

    public int getReason() {
        return this.reason;
    }
}

