/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import org.odftoolkit.odfdom.NamespaceName;

public class OdfNamespace
implements Comparable,
NamespaceContext {
    private static Map<String, String> mURIsByPrefix = new HashMap<String, String>();
    private static Map<String, String> mPrefixesByURI = new HashMap<String, String>();
    private static Map<String, OdfNamespace> mNamespacesByURI = new HashMap<String, OdfNamespace>();
    private String mUri;
    private String mPrefix;

    private OdfNamespace() {
    }

    private OdfNamespace(String prefix, String uri) {
        this.mUri = uri;
        this.mPrefix = prefix;
    }

    public static OdfNamespace newNamespace(NamespaceName name) {
        OdfNamespace ns = null;
        if (name != null) {
            ns = OdfNamespace.newNamespace(name.getPrefix(), name.getUri());
        }
        return ns;
    }

    public static OdfNamespace newNamespace(String prefix, String uri) {
        OdfNamespace odfNamespace = null;
        if (uri != null && uri.length() > 0 && prefix != null && prefix.length() > 0 && (odfNamespace = mNamespacesByURI.get(uri)) == null) {
            odfNamespace = new OdfNamespace(prefix, uri);
            mPrefixesByURI.put(uri, prefix);
            mURIsByPrefix.put(prefix, uri);
            mNamespacesByURI.put(uri, odfNamespace);
        }
        return odfNamespace;
    }

    public static OdfNamespace getNamespace(String uri) {
        OdfNamespace ns = null;
        if (uri != null) {
            ns = mNamespacesByURI.get(uri);
        }
        return ns;
    }

    public String getPrefix() {
        return this.mPrefix;
    }

    public String getUri() {
        return this.mUri;
    }

    public boolean equals(Object obj) {
        if (this.mUri != null) {
            return this.mUri.equals(obj.toString());
        }
        return this.mUri == obj;
    }

    public int hashCode() {
        if (this.mUri != null) {
            return this.mUri.hashCode();
        }
        return 0;
    }

    public String toString() {
        return this.mUri;
    }

    public static String[] splitQName(String qname) throws IllegalArgumentException {
        String localpart = qname;
        String prefix = null;
        int colon = qname.indexOf(58);
        if (colon <= 0) {
            throw new IllegalArgumentException("A qualified name was required, but '" + qname + "' was given!");
        }
        localpart = qname.substring(colon + 1);
        prefix = qname.substring(0, colon);
        return new String[]{prefix, localpart};
    }

    public static String getPrefixPart(String qname) {
        return OdfNamespace.splitQName(qname)[0];
    }

    public static String getLocalPart(String qname) {
        return OdfNamespace.splitQName(qname)[1];
    }

    public int compareTo(Object o) {
        return this.toString().compareTo(o.toString());
    }

    public String getNamespaceURI(String prefix) {
        String nsURI = null;
        nsURI = mURIsByPrefix.get(prefix);
        if (nsURI == null) {
            nsURI = "";
        }
        return nsURI;
    }

    public String getPrefix(String namespaceUri) {
        return mPrefixesByURI.get(namespaceUri);
    }

    public Iterator getPrefixes(String namespaceuri) {
        return mURIsByPrefix.keySet().iterator();
    }

    public static String getNamespaceURIByPrefix(String prefix) {
        return mURIsByPrefix.get(prefix);
    }
}

