/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.doc.number;

import org.odftoolkit.odfdom.OdfFileDom;
import org.odftoolkit.odfdom.doc.number.OdfNumberAmPm;
import org.odftoolkit.odfdom.doc.number.OdfNumberHours;
import org.odftoolkit.odfdom.doc.number.OdfNumberMinutes;
import org.odftoolkit.odfdom.doc.number.OdfNumberSeconds;
import org.odftoolkit.odfdom.doc.number.OdfNumberText;
import org.odftoolkit.odfdom.dom.attribute.number.NumberFormatSourceAttribute;
import org.odftoolkit.odfdom.dom.element.number.NumberTimeStyleElement;
import org.w3c.dom.Node;

public class OdfNumberTimeStyle
extends NumberTimeStyleElement {
    private String styleName;

    public OdfNumberTimeStyle(OdfFileDom ownerDoc) {
        super(ownerDoc);
    }

    public OdfNumberTimeStyle(OdfFileDom ownerDoc, String format, String styleName) {
        super(ownerDoc);
        this.styleName = styleName;
        this.buildFromFormat(format);
    }

    public void buildFromFormat(String format) {
        String actionChars = "GyQMwdEaHhms";
        int actionCount = 0;
        String textBuffer = "";
        boolean endQuote = false;
        int i = 0;
        this.setStyleNameAttribute(this.styleName);
        this.setNumberFormatSourceAttribute(NumberFormatSourceAttribute.Value.LANGUAGE.toString());
        while (i < format.length()) {
            char ch = format.charAt(i);
            if (actionChars.indexOf(ch) >= 0) {
                this.appendText(textBuffer);
                textBuffer = "";
                actionCount = 0;
                while (i < format.length() && format.charAt(i) == ch) {
                    ++actionCount;
                    ++i;
                }
                this.processChar(ch, actionCount);
                continue;
            }
            if (ch == '\'') {
                endQuote = false;
                ++i;
                while (i < format.length() && !endQuote) {
                    ch = format.charAt(i);
                    if (ch == '\'') {
                        if (i + 1 < format.length() && format.charAt(i + 1) == '\'') {
                            ++i;
                            textBuffer = textBuffer + "'";
                        } else {
                            endQuote = true;
                        }
                    } else {
                        textBuffer = textBuffer + ch;
                    }
                    ++i;
                }
                continue;
            }
            textBuffer = textBuffer + ch;
            ++i;
        }
        this.appendText(textBuffer);
    }

    private void appendText(String textBuffer) {
        OdfNumberText textElement = null;
        if (!textBuffer.equals("")) {
            textElement = new OdfNumberText((OdfFileDom)((Object)this.getOwnerDocument()));
            textElement.setTextContent(textBuffer);
            this.appendChild((Node)((Object)textElement));
        }
    }

    private void processChar(char ch, int count) {
        OdfFileDom ownerDoc = (OdfFileDom)((Object)this.getOwnerDocument());
        switch (ch) {
            case 'a': {
                OdfNumberAmPm ampm = new OdfNumberAmPm(ownerDoc);
                this.appendChild((Node)((Object)ampm));
                break;
            }
            case 'H': 
            case 'h': {
                OdfNumberHours hours = new OdfNumberHours(ownerDoc);
                hours.setNumberStyleAttribute(this.isLongIf(count > 1));
                this.appendChild((Node)((Object)hours));
                break;
            }
            case 'm': {
                OdfNumberMinutes minutes = new OdfNumberMinutes(ownerDoc);
                minutes.setNumberStyleAttribute(this.isLongIf(count > 1));
                this.appendChild((Node)((Object)minutes));
                break;
            }
            case 's': {
                OdfNumberSeconds seconds = new OdfNumberSeconds(ownerDoc);
                seconds.setNumberStyleAttribute(this.isLongIf(count > 1));
                this.appendChild((Node)((Object)seconds));
            }
        }
    }

    private String isLongIf(boolean isLong) {
        return isLong ? "long" : "short";
    }
}

