/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metadata.model;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.metadata.model.IPhysicalTable;
import org.pentaho.metadata.model.LogicalColumn;
import org.pentaho.metadata.model.LogicalModel;
import org.pentaho.metadata.model.concept.Concept;
import org.pentaho.metadata.model.concept.IConcept;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogicalTable
extends Concept {
    private static final long serialVersionUID = -2655375483724689568L;
    private LogicalModel logicalModel;
    private IPhysicalTable physicalTable;
    private List<LogicalColumn> logicalColumns = new ArrayList<LogicalColumn>();
    private static final String CLASS_ID = "LogicalTable";

    public LogicalTable() {
    }

    public LogicalTable(LogicalModel logicalModel, IPhysicalTable physicalTable) {
        this.logicalModel = logicalModel;
        this.physicalTable = physicalTable;
    }

    @Override
    public IConcept getParent() {
        return this.logicalModel;
    }

    @Override
    public List<IConcept> getChildren() {
        ArrayList<IConcept> children = new ArrayList<IConcept>();
        children.addAll(this.logicalColumns);
        return children;
    }

    @Override
    public List<String> getUniqueId() {
        ArrayList<String> uid = new ArrayList<String>(this.logicalModel.getUniqueId());
        uid.add(CLASS_ID.concat("-") + this.getId());
        return uid;
    }

    public void setLogicalModel(LogicalModel logicalModel) {
        this.logicalModel = logicalModel;
    }

    public LogicalModel getLogicalModel() {
        return this.logicalModel;
    }

    public IPhysicalTable getPhysicalTable() {
        return this.physicalTable;
    }

    public void setPhysicalTable(IPhysicalTable physicalTable) {
        this.physicalTable = physicalTable;
    }

    public List<LogicalColumn> getLogicalColumns() {
        return this.logicalColumns;
    }

    public List<String> getColumnNames(String locale) {
        ArrayList<String> list = new ArrayList<String>();
        for (LogicalColumn column : this.logicalColumns) {
            list.add(column.getName(locale));
        }
        return list;
    }

    public void setLogicalColumns(List<LogicalColumn> columns) {
        this.logicalColumns = columns;
    }

    public void addLogicalColumn(LogicalColumn column) {
        this.logicalColumns.add(column);
    }

    @Override
    public IConcept getInheritedConcept() {
        return this.physicalTable;
    }

    @Override
    public IConcept getSecurityParentConcept() {
        return this.getLogicalModel();
    }

    public LogicalColumn findLogicalColumn(String id) {
        for (LogicalColumn col : this.logicalColumns) {
            if (!id.equals(col.getId())) continue;
            return col;
        }
        return null;
    }

    public boolean equals(Object obj) {
        LogicalTable other = (LogicalTable)obj;
        return other.getId().equals(this.getId());
    }

    @Override
    public Object clone() {
        LogicalTable clone = new LogicalTable();
        this.clone(clone);
        clone.setLogicalModel(this.logicalModel);
        clone.physicalTable = this.physicalTable;
        clone.setLogicalColumns(new ArrayList<LogicalColumn>());
        for (LogicalColumn col : this.logicalColumns) {
            clone.addLogicalColumn(col);
        }
        return clone;
    }
}

