/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metadata.model.olap;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.pentaho.metadata.model.LogicalColumn;
import org.pentaho.metadata.model.LogicalTable;
import org.pentaho.metadata.model.olap.OlapDimension;
import org.pentaho.metadata.model.olap.OlapHierarchyLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OlapHierarchy
implements Cloneable,
Serializable {
    private String name;
    private LogicalTable logicalTable;
    private LogicalColumn primaryKey;
    private List<OlapHierarchyLevel> hierarchyLevels;
    private boolean havingAll;
    private OlapDimension olapDimension;

    public OlapHierarchy() {
    }

    public OlapHierarchy(OlapDimension olapDimension) {
        this.olapDimension = olapDimension;
        this.hierarchyLevels = new ArrayList<OlapHierarchyLevel>();
        this.havingAll = true;
    }

    public OlapHierarchy(OlapDimension olapDimension, String name, List<OlapHierarchyLevel> hierarchyLevels) {
        this(olapDimension);
        this.name = name;
        this.hierarchyLevels = hierarchyLevels;
    }

    public Object clone() {
        OlapHierarchy hierarchy = new OlapHierarchy(this.olapDimension);
        hierarchy.name = this.name;
        if (this.logicalTable != null) {
            hierarchy.logicalTable = (LogicalTable)this.logicalTable.clone();
        }
        if (this.primaryKey != null) {
            hierarchy.primaryKey = (LogicalColumn)this.primaryKey.clone();
        }
        for (int i = 0; i < this.hierarchyLevels.size(); ++i) {
            OlapHierarchyLevel hierarchyLevel = this.hierarchyLevels.get(i);
            hierarchy.hierarchyLevels.add((OlapHierarchyLevel)hierarchyLevel.clone());
        }
        hierarchy.havingAll = this.havingAll;
        return hierarchy;
    }

    public boolean equals(Object obj) {
        return this.name.equals(((OlapHierarchy)obj).getName());
    }

    public List<OlapHierarchyLevel> getHierarchyLevels() {
        return this.hierarchyLevels;
    }

    public void setHierarchyLevels(List<OlapHierarchyLevel> hierarchyLevels) {
        this.hierarchyLevels = hierarchyLevels;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isHavingAll() {
        return this.havingAll;
    }

    public void setHavingAll(boolean havingAll) {
        this.havingAll = havingAll;
    }

    public LogicalColumn getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(LogicalColumn primaryKey) {
        this.primaryKey = primaryKey;
    }

    public OlapHierarchyLevel findOlapHierarchyLevel(String thisName) {
        for (int i = 0; i < this.hierarchyLevels.size(); ++i) {
            OlapHierarchyLevel level = this.hierarchyLevels.get(i);
            if (!level.getName().equalsIgnoreCase(thisName)) continue;
            return level;
        }
        return null;
    }

    public OlapDimension getOlapDimension() {
        return this.olapDimension;
    }

    public void setOlapDimension(OlapDimension olapDimension) {
        this.olapDimension = olapDimension;
    }

    public LogicalTable getLogicalTable() {
        return this.logicalTable;
    }

    public void setLogicalTable(LogicalTable logicalTable) {
        this.logicalTable = logicalTable;
    }

    public List<String> getUnusedColumnNames(String locale) {
        List<String> names = this.logicalTable.getColumnNames(locale);
        for (int i = names.size() - 1; i >= 0; --i) {
            String columnName = names.get(i);
            if (this.findLogicalColumn(locale, columnName) == null) continue;
            names.remove(i);
        }
        return names;
    }

    public LogicalColumn findLogicalColumn(String locale, String columnName) {
        for (int i = 0; i < this.hierarchyLevels.size(); ++i) {
            OlapHierarchyLevel level = this.hierarchyLevels.get(i);
            LogicalColumn logicalColumn = level.findLogicalColumn(locale, columnName);
            if (logicalColumn == null) continue;
            return logicalColumn;
        }
        return null;
    }
}

