/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metadata.model.olap;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.pentaho.metadata.model.LogicalColumn;
import org.pentaho.metadata.model.olap.OlapAnnotation;
import org.pentaho.metadata.model.olap.OlapHierarchy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OlapHierarchyLevel
implements Cloneable,
Serializable {
    private String name;
    private LogicalColumn referenceColumn;
    private List<LogicalColumn> logicalColumns;
    private boolean havingUniqueMembers;
    private List<OlapAnnotation> annotations;
    private OlapHierarchy olapHierarchy;

    public OlapHierarchyLevel() {
    }

    public OlapHierarchyLevel(OlapHierarchy olapHierarchy) {
        this.olapHierarchy = olapHierarchy;
        this.logicalColumns = new ArrayList<LogicalColumn>();
        this.annotations = new ArrayList<OlapAnnotation>();
    }

    public OlapHierarchyLevel(OlapHierarchy olapHierarchy, String name, LogicalColumn referenceColumn, List<LogicalColumn> logicalColumns) {
        this(olapHierarchy);
        this.name = name;
        this.referenceColumn = referenceColumn;
        this.logicalColumns = logicalColumns;
        this.annotations = new ArrayList<OlapAnnotation>();
    }

    public OlapHierarchyLevel(OlapHierarchy olapHierarchy, String name, LogicalColumn referenceColumn, List<LogicalColumn> logicalColumns, List<OlapAnnotation> annotations) {
        this(olapHierarchy);
        this.name = name;
        this.referenceColumn = referenceColumn;
        this.logicalColumns = logicalColumns;
        this.annotations = annotations;
    }

    public Object clone() {
        OlapHierarchyLevel hierarchyLevel = new OlapHierarchyLevel(this.olapHierarchy);
        hierarchyLevel.name = this.name;
        if (this.referenceColumn != null) {
            hierarchyLevel.referenceColumn = (LogicalColumn)this.referenceColumn.clone();
        }
        for (int i = 0; i < this.logicalColumns.size(); ++i) {
            LogicalColumn logicalColumn = this.logicalColumns.get(i);
            hierarchyLevel.logicalColumns.add((LogicalColumn)logicalColumn.clone());
        }
        hierarchyLevel.havingUniqueMembers = this.havingUniqueMembers;
        return hierarchyLevel;
    }

    public boolean equals(Object obj) {
        return this.name.equals(((OlapHierarchyLevel)obj).getName());
    }

    public List<LogicalColumn> getLogicalColumns() {
        return this.logicalColumns;
    }

    public void setLogicalColumns(List<LogicalColumn> logicalColumns) {
        this.logicalColumns = logicalColumns;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public LogicalColumn getReferenceColumn() {
        return this.referenceColumn;
    }

    public void setReferenceColumn(LogicalColumn referenceColumn) {
        this.referenceColumn = referenceColumn;
    }

    public LogicalColumn findLogicalColumn(String locale, String thisName) {
        if (this.referenceColumn != null && this.referenceColumn.getName(locale).equalsIgnoreCase(thisName)) {
            return this.referenceColumn;
        }
        for (int i = 0; i < this.logicalColumns.size(); ++i) {
            LogicalColumn column = this.logicalColumns.get(i);
            if (!column.getName(locale).equalsIgnoreCase(thisName)) continue;
            return column;
        }
        return null;
    }

    public OlapHierarchy getOlapHierarchy() {
        return this.olapHierarchy;
    }

    public void setOlapHierarchy(OlapHierarchy olapHierarchy) {
        this.olapHierarchy = olapHierarchy;
    }

    public boolean isHavingUniqueMembers() {
        return this.havingUniqueMembers;
    }

    public void setHavingUniqueMembers(boolean havingUniqueMembers) {
        this.havingUniqueMembers = havingUniqueMembers;
    }

    public List<OlapAnnotation> getAnnotations() {
        if (this.annotations == null) {
            this.annotations = new ArrayList<OlapAnnotation>();
        }
        return this.annotations;
    }

    public void setAnnotations(List<OlapAnnotation> annotations) {
        this.annotations = annotations;
    }
}

