/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metadata.query.example;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.metadata.messages.Messages;
import org.pentaho.metadata.model.LogicalModel;
import org.pentaho.metadata.model.LogicalRelationship;
import org.pentaho.metadata.model.LogicalTable;
import org.pentaho.metadata.model.concept.types.RelationshipType;
import org.pentaho.metadata.model.concept.types.TargetColumnType;
import org.pentaho.metadata.query.example.AliasAwareSqlOpenFormula;
import org.pentaho.metadata.query.example.AliasedSelection;
import org.pentaho.metadata.query.impl.sql.MappedQuery;
import org.pentaho.metadata.query.impl.sql.Path;
import org.pentaho.metadata.query.impl.sql.SqlAndTables;
import org.pentaho.metadata.query.impl.sql.SqlGenerator;
import org.pentaho.metadata.query.model.Constraint;
import org.pentaho.metadata.query.model.Order;
import org.pentaho.metadata.query.model.Selection;
import org.pentaho.pms.core.exception.PentahoMetadataException;
import org.pentaho.pms.mql.dialect.JoinType;
import org.pentaho.pms.mql.dialect.SQLDialectFactory;
import org.pentaho.pms.mql.dialect.SQLDialectInterface;
import org.pentaho.pms.mql.dialect.SQLQueryModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdvancedSqlGenerator
extends SqlGenerator {
    public static final String DEFAULT_ALIAS = "__DEFAULT__";

    @Override
    protected MappedQuery getSQL(LogicalModel model, List<Selection> selections, List<Constraint> constraints, List<Order> orderbys, DatabaseMeta databaseMeta, String locale, Map<String, Object> parameters, boolean genAsPreparedStatement, boolean disableDistinct, int limit, Constraint securityConstraint) throws PentahoMetadataException {
        SQLAndAliasedTables sqlAndTables;
        AliasAwareSqlOpenFormula formula;
        SQLAndAliasedTables sqlAndTables2;
        int i;
        int i2;
        HashMap<Constraint, AliasAwareSqlOpenFormula> constraintFormulaMap = new HashMap<Constraint, AliasAwareSqlOpenFormula>();
        HashMap<AliasedSelection, AliasAwareSqlOpenFormula> selectionFormulaMap = new HashMap<AliasedSelection, AliasAwareSqlOpenFormula>();
        for (Constraint constraint : constraints) {
            AliasAwareSqlOpenFormula formula2 = new AliasAwareSqlOpenFormula(model, databaseMeta, constraint.getFormula(), selections, DEFAULT_ALIAS);
            formula2.parseAndValidate();
            constraintFormulaMap.put(constraint, formula2);
        }
        HashMap<String, String> columnsMap = new HashMap<String, String>();
        if (model == null || selections.size() == 0) {
            return null;
        }
        ArrayList<AliasedSelection> defaultList = null;
        ArrayList lists = new ArrayList();
        ArrayList<String> aliasNames = new ArrayList<String>();
        HashMap listlookup = new HashMap();
        ArrayList<Selection> selectionsAndOrderBys = new ArrayList<Selection>();
        selectionsAndOrderBys.addAll(selections);
        for (Order orderBy : orderbys) {
            selectionsAndOrderBys.add(orderBy.getSelection());
        }
        for (Selection selection : selectionsAndOrderBys) {
            ArrayList<AliasedSelection> list;
            AliasedSelection sel = (AliasedSelection)selection;
            if (sel.hasFormula()) {
                AliasAwareSqlOpenFormula formula3 = new AliasAwareSqlOpenFormula(model, databaseMeta, sel.getFormula(), selections, DEFAULT_ALIAS);
                formula3.setAllowAggregateFunctions(true);
                formula3.parseAndValidate();
                selectionFormulaMap.put(sel, formula3);
            }
            if (sel.alias == null) {
                sel.alias = DEFAULT_ALIAS;
            }
            if ((list = (ArrayList<AliasedSelection>)listlookup.get(sel.alias)) == null) {
                list = new ArrayList<AliasedSelection>();
                if (sel.alias.equals(DEFAULT_ALIAS)) {
                    defaultList = list;
                    lists.add(0, list);
                    aliasNames.add(0, DEFAULT_ALIAS);
                } else {
                    lists.add(list);
                    aliasNames.add(sel.alias);
                }
                listlookup.put(sel.alias, list);
            }
            if (list.contains(sel)) continue;
            list.add(sel);
        }
        if (!listlookup.containsKey(DEFAULT_ALIAS)) {
            throw new PentahoMetadataException("No non-aliased columns selected");
        }
        ArrayList<AliasedLogicalRelationship> allRelationships = new ArrayList<AliasedLogicalRelationship>();
        List<LogicalTable> defaultTables = this.getTablesInvolved(model, defaultList, constraints, orderbys, databaseMeta, locale, selectionFormulaMap, constraintFormulaMap);
        Path defaultPath = this.getShortestPathBetween(model, defaultTables);
        List<LogicalTable> tbls = defaultPath.getUsedTables();
        ArrayList<AliasedPathLogicalTable> allTables = new ArrayList<AliasedPathLogicalTable>();
        for (LogicalTable tbl : tbls) {
            allTables.add(new AliasedPathLogicalTable(DEFAULT_ALIAS, tbl));
        }
        if (tbls.size() == 0) {
            allTables.add(new AliasedPathLogicalTable(DEFAULT_ALIAS, defaultTables.get(0)));
        }
        if (defaultPath == null) {
            throw new PentahoMetadataException(Messages.getErrorString("SqlGenerator.ERROR_0002_FAILED_TO_FIND_PATH", new Object[0]));
        }
        for (i2 = 0; i2 < defaultPath.size(); ++i2) {
            allRelationships.add(new AliasedLogicalRelationship(DEFAULT_ALIAS, DEFAULT_ALIAS, defaultPath.getRelationship(i2)));
        }
        for (i2 = 1; i2 < lists.size(); ++i2) {
            List aliasedColumns = (List)lists.get(i2);
            ArrayList<Selection> aliasedAndDefaultColumns = new ArrayList<Selection>();
            aliasedAndDefaultColumns.addAll(aliasedColumns);
            aliasedAndDefaultColumns.addAll(defaultList);
            List<LogicalTable> aliasedTables = this.getTablesInvolved(model, aliasedColumns, null, null, databaseMeta, locale, selectionFormulaMap, constraintFormulaMap);
            List<LogicalTable> aliasedAndDefaultTables = this.getTablesInvolved(model, aliasedAndDefaultColumns, null, null, databaseMeta, locale, selectionFormulaMap, constraintFormulaMap);
            Path aliasedAndDefaultPath = this.getShortestPathBetween(model, aliasedAndDefaultTables);
            for (LogicalTable aliasedTable : aliasedTables) {
                this.traversePath((String)aliasNames.get(i2), aliasedTable, aliasedAndDefaultPath, aliasedTables, defaultTables, allTables, allRelationships);
            }
        }
        SQLQueryModel sqlquery = new SQLQueryModel();
        boolean group = this.hasFactsInIt(selections, constraints, selectionFormulaMap, constraintFormulaMap);
        sqlquery.setDistinct(!disableDistinct && !group);
        sqlquery.setLimit(limit);
        for (i = 0; i < selections.size(); ++i) {
            String formula4;
            Selection selection = (AliasedSelection)selections.get(i);
            if (((AliasedSelection)selection).hasFormula()) {
                try {
                    formula4 = ((AliasAwareSqlOpenFormula)selectionFormulaMap.get(selection)).generateSQL(locale);
                }
                catch (PentahoMetadataException e) {
                    throw new RuntimeException(e);
                }
            } else {
                sqlAndTables2 = AdvancedSqlGenerator.getSelectionSQL(model, (AliasedSelection)selection, databaseMeta, locale);
                formula4 = sqlAndTables2.getSql();
            }
            String alias = null;
            if (columnsMap != null) {
                if (selection.getLogicalColumn() != null && ((AliasedSelection)selection).getAlias().equals(DEFAULT_ALIAS)) {
                    columnsMap.put("COL" + i, selection.getLogicalColumn().getId());
                } else {
                    columnsMap.put("COL" + i, "CUSTOM_" + i);
                }
                alias = databaseMeta.quoteField("COL" + Integer.toString(i));
            } else {
                alias = databaseMeta.quoteField(selection.getLogicalColumn().getId());
            }
            sqlquery.addSelection(formula4, alias);
        }
        for (i = 0; i < allTables.size(); ++i) {
            AliasedPathLogicalTable tbl = (AliasedPathLogicalTable)allTables.get(i);
            String alias = tbl.getLogicalTable().getId();
            if (!tbl.getAlias().equals(DEFAULT_ALIAS)) {
                alias = alias + "_" + tbl.getAlias();
            }
            String schemaName = null;
            if (tbl.getLogicalTable().getProperty("target_schema") != null) {
                schemaName = databaseMeta.quoteField((String)tbl.getLogicalTable().getProperty("target_schema"));
            }
            String tableName = databaseMeta.quoteField((String)tbl.getLogicalTable().getProperty("target_table"));
            sqlquery.addTable(databaseMeta.getSchemaTableCombination(schemaName, tableName), databaseMeta.quoteField(alias));
        }
        for (i = 0; i < allRelationships.size(); ++i) {
            JoinType joinType;
            AliasedLogicalRelationship aliasedRelation = (AliasedLogicalRelationship)allRelationships.get(i);
            String joinFormula = this.getJoin(model, aliasedRelation, databaseMeta, locale, selections);
            String joinOrderKey = aliasedRelation.relation.getJoinOrderKey();
            switch (RelationshipType.getJoinType(aliasedRelation.relation.getRelationshipType())) {
                case LEFT_OUTER: {
                    joinType = JoinType.LEFT_OUTER_JOIN;
                    break;
                }
                case RIGHT_OUTER: {
                    joinType = JoinType.RIGHT_OUTER_JOIN;
                    break;
                }
                case FULL_OUTER: {
                    joinType = JoinType.FULL_OUTER_JOIN;
                    break;
                }
                default: {
                    joinType = JoinType.INNER_JOIN;
                }
            }
            String leftSchema = (String)aliasedRelation.relation.getFromTable().getProperty("target_schema");
            String leftTable = (String)aliasedRelation.relation.getFromTable().getProperty("target_table");
            String rightSchema = (String)aliasedRelation.relation.getToTable().getProperty("target_schema");
            String rightTable = (String)aliasedRelation.relation.getToTable().getProperty("target_table");
            String leftTableName = databaseMeta.getQuotedSchemaTableCombination(leftSchema, leftTable);
            String rightTableName = databaseMeta.getQuotedSchemaTableCombination(rightSchema, rightTable);
            String leftTableAlias = aliasedRelation.relation.getFromTable().getId();
            if (!aliasedRelation.leftAlias.equals(DEFAULT_ALIAS)) {
                leftTableAlias = leftTableAlias + "_" + aliasedRelation.leftAlias;
            }
            String rightTableAlias = aliasedRelation.relation.getToTable().getId();
            if (!aliasedRelation.rightAlias.equals(DEFAULT_ALIAS)) {
                rightTableAlias = rightTableAlias + "_" + aliasedRelation.rightAlias;
            }
            sqlquery.addJoin(leftTableName, leftTableAlias, rightTableName, rightTableAlias, joinType, joinFormula, joinOrderKey);
        }
        if (constraints != null) {
            boolean first = true;
            for (Constraint constraint : constraints) {
                formula = (AliasAwareSqlOpenFormula)constraintFormulaMap.get(constraint);
                if (!formula.hasAggregate() && !formula.hasAggregateFunction()) {
                    String sql = formula.generateSQL(locale);
                    String[] usedTables = formula.getTableAliasNames();
                    sqlquery.addWhereFormula(sql, first ? "AND" : constraint.getCombinationType().toString(), usedTables);
                    first = false;
                    continue;
                }
                sqlquery.addHavingFormula(formula.generateSQL(locale), constraint.getCombinationType().toString());
            }
        }
        if (group) {
            for (Selection selection : selections) {
                Selection aliasedSelection = selection;
                if (((AliasedSelection)aliasedSelection).hasFormula()) {
                    formula = (AliasAwareSqlOpenFormula)selectionFormulaMap.get(aliasedSelection);
                    if (formula.hasAggregate() || formula.hasAggregateFunction()) continue;
                    sqlAndTables = AdvancedSqlGenerator.getSelectionSQL(model, (AliasedSelection)aliasedSelection, databaseMeta, locale);
                    sqlquery.addGroupBy(sqlAndTables.getSql(), null);
                    continue;
                }
                if (aliasedSelection.hasAggregate()) continue;
                sqlAndTables2 = AdvancedSqlGenerator.getSelectionSQL(model, (AliasedSelection)aliasedSelection, databaseMeta, locale);
                sqlquery.addGroupBy(sqlAndTables2.getSql(), null);
            }
        }
        if (orderbys != null) {
            for (Order orderItem : orderbys) {
                AliasedSelection selection = (AliasedSelection)orderItem.getSelection();
                String sqlSelection = null;
                if (!selection.hasFormula()) {
                    sqlAndTables = AdvancedSqlGenerator.getSelectionSQL(model, selection, databaseMeta, locale);
                    sqlSelection = sqlAndTables.getSql();
                } else {
                    AliasAwareSqlOpenFormula formula5 = (AliasAwareSqlOpenFormula)selectionFormulaMap.get(selection);
                    sqlSelection = formula5.generateSQL(locale);
                }
                sqlquery.addOrderBy(sqlSelection, null, orderItem.getType() != Order.Type.ASC ? SQLQueryModel.OrderType.DESCENDING : null);
            }
        }
        SQLDialectInterface dialect = SQLDialectFactory.getSQLDialect(databaseMeta);
        String sql = dialect.generateSelectStatement(sqlquery);
        MappedQuery query = new MappedQuery(sql, columnsMap, selections, null);
        return query;
    }

    protected boolean hasFactsInIt(List<Selection> selections, List<Constraint> conditions, Map<AliasedSelection, AliasAwareSqlOpenFormula> selectionFormulaMap, Map<Constraint, AliasAwareSqlOpenFormula> constraintFormulaMap) {
        for (Selection selection : selections) {
            AliasedSelection aliasedSelection = (AliasedSelection)selection;
            if (aliasedSelection.hasFormula()) {
                AliasAwareSqlOpenFormula formula = selectionFormulaMap.get(aliasedSelection);
                if (formula.hasAggregate()) {
                    return true;
                }
                if (!formula.hasAggregateFunction()) continue;
                return true;
            }
            if (!aliasedSelection.hasAggregate()) continue;
            return true;
        }
        if (conditions != null) {
            for (Constraint condition : conditions) {
                AliasAwareSqlOpenFormula formula = constraintFormulaMap.get(condition);
                if (formula.hasAggregate()) {
                    return true;
                }
                if (!formula.hasAggregateFunction()) continue;
                return true;
            }
        }
        return false;
    }

    protected List<LogicalTable> getTablesInvolved(LogicalModel model, List<Selection> selections, List<Constraint> conditions, List<Order> orderBys, DatabaseMeta databaseMeta, String locale, Map<AliasedSelection, AliasAwareSqlOpenFormula> selectionFormulaMap, Map<Constraint, AliasAwareSqlOpenFormula> constraintFormulaMap) {
        SQLAndAliasedTables sqlAndTables;
        LogicalTable LogicalTable2;
        List<Selection> cols;
        AliasAwareSqlOpenFormula formula;
        AliasedSelection aliasedSelection;
        TreeSet<LogicalTable> treeSet = new TreeSet<LogicalTable>();
        for (Selection selection : selections) {
            aliasedSelection = (AliasedSelection)selection;
            if (aliasedSelection.hasFormula()) {
                formula = selectionFormulaMap.get(aliasedSelection);
                cols = formula.getSelections();
                for (Selection sel : cols) {
                    LogicalTable2 = sel.getLogicalColumn().getLogicalTable();
                    treeSet.add(LogicalTable2);
                }
                continue;
            }
            sqlAndTables = AdvancedSqlGenerator.getSelectionSQL(model, aliasedSelection, databaseMeta, locale);
            for (AliasedPathLogicalTable LogicalTable3 : sqlAndTables.getAliasedLogicalTables()) {
                treeSet.add(LogicalTable3.getLogicalTable());
            }
        }
        if (conditions != null) {
            for (Constraint condition : conditions) {
                AliasAwareSqlOpenFormula formula2 = constraintFormulaMap.get(condition);
                List<Selection> cols2 = formula2.getSelections();
                for (Selection sel : cols2) {
                    LogicalTable LogicalTable4 = sel.getLogicalColumn().getLogicalTable();
                    treeSet.add(LogicalTable4);
                }
            }
        }
        if (orderBys != null) {
            for (Order order : orderBys) {
                aliasedSelection = (AliasedSelection)order.getSelection();
                if (aliasedSelection.hasFormula()) {
                    formula = selectionFormulaMap.get(aliasedSelection);
                    cols = formula.getSelections();
                    for (Selection sel : cols) {
                        LogicalTable2 = sel.getLogicalColumn().getLogicalTable();
                        treeSet.add(LogicalTable2);
                    }
                    continue;
                }
                sqlAndTables = AdvancedSqlGenerator.getSelectionSQL(model, (AliasedSelection)order.getSelection(), databaseMeta, locale);
                for (AliasedPathLogicalTable LogicalTable3 : sqlAndTables.getAliasedLogicalTables()) {
                    treeSet.add(LogicalTable3.getLogicalTable());
                }
            }
        }
        return new ArrayList<LogicalTable>(treeSet);
    }

    public static SQLAndAliasedTables getSelectionSQL(LogicalModel LogicalModel2, AliasedSelection selection, DatabaseMeta databaseMeta, String locale) {
        String columnStr = (String)selection.getLogicalColumn().getProperty("target_column");
        if (selection.getLogicalColumn().getProperty("target_column_type") == TargetColumnType.OPEN_FORMULA) {
            try {
                AliasAwareSqlOpenFormula formula = new AliasAwareSqlOpenFormula(LogicalModel2, selection.getLogicalColumn().getLogicalTable(), databaseMeta, columnStr, selection.getAlias());
                formula.parseAndValidate();
                return new SQLAndAliasedTables(formula.generateSQL(locale), formula.getUsedAliasedTables());
            }
            catch (PentahoMetadataException e) {
                throw new RuntimeException(Messages.getErrorString("SqlGenerator.ERROR_0001_FAILED_TO_PARSE_FORMULA", columnStr));
            }
        }
        String tableColumn = "";
        String tblName = selection.getLogicalColumn().getLogicalTable().getId();
        if (!selection.getAlias().equals(DEFAULT_ALIAS)) {
            tblName = tblName + "_" + selection.getAlias();
        }
        tableColumn = tableColumn + databaseMeta.quoteField(tblName);
        tableColumn = tableColumn + ".";
        tableColumn = tableColumn + databaseMeta.quoteField(columnStr);
        if (selection.hasAggregate()) {
            return new SQLAndAliasedTables(AdvancedSqlGenerator.getFunctionExpression(selection, tableColumn, databaseMeta), new AliasedPathLogicalTable(tblName, selection.getLogicalColumn().getLogicalTable()));
        }
        return new SQLAndAliasedTables(tableColumn, new AliasedPathLogicalTable(tblName, selection.getLogicalColumn().getLogicalTable()));
    }

    public String getJoin(LogicalModel LogicalModel2, AliasedLogicalRelationship relation, DatabaseMeta databaseMeta, String locale, List<Selection> selections) throws PentahoMetadataException {
        String join = "";
        if (relation.relation.isComplex().booleanValue()) {
            String formulaString = relation.relation.getComplexJoin();
            AliasAwareSqlOpenFormula formula = new AliasAwareSqlOpenFormula(LogicalModel2, databaseMeta, formulaString, selections, DEFAULT_ALIAS);
            if (!relation.rightAlias.equals(DEFAULT_ALIAS) || !relation.leftAlias.equals(DEFAULT_ALIAS)) {
                HashMap<String, String> LogicalTableToAliasMap = new HashMap<String, String>();
                if (!relation.rightAlias.equals(DEFAULT_ALIAS)) {
                    LogicalTableToAliasMap.put(relation.relation.getToTable().getId(), relation.rightAlias);
                }
                if (!relation.leftAlias.equals(DEFAULT_ALIAS)) {
                    LogicalTableToAliasMap.put(relation.relation.getFromTable().getId(), relation.leftAlias);
                }
                formula.setLogicalTableToAliasMap(LogicalTableToAliasMap);
            }
            formula.parseAndValidate();
            join = formula.generateSQL(locale);
        } else if (relation.relation.getFromTable() != null && relation.relation.getToTable() != null && relation.relation.getFromColumn() != null && relation.relation.getToColumn() != null) {
            String rightAlias = relation.relation.getToTable().getId();
            if (!relation.rightAlias.equals(DEFAULT_ALIAS)) {
                rightAlias = rightAlias + "_" + relation.rightAlias;
            }
            String leftAlias = relation.relation.getFromTable().getId();
            if (!relation.leftAlias.equals(DEFAULT_ALIAS)) {
                leftAlias = leftAlias + "_" + relation.leftAlias;
            }
            join = databaseMeta.quoteField(leftAlias);
            join = join + ".";
            join = join + databaseMeta.quoteField((String)relation.relation.getFromColumn().getProperty("target_column"));
            join = join + " = ";
            join = join + databaseMeta.quoteField(rightAlias);
            join = join + ".";
            join = join + databaseMeta.quoteField((String)relation.relation.getToColumn().getProperty("target_column"));
        }
        return join;
    }

    protected void traversePath(String alias, LogicalTable aliasedTable, Path aliasedPath, List<LogicalTable> aliasedTables, List<LogicalTable> defaultTables, List<AliasedPathLogicalTable> allTables, List<AliasedLogicalRelationship> allRelationships) {
        int i;
        AliasedPathLogicalTable aliasedPathTable = new AliasedPathLogicalTable(alias, aliasedTable);
        if (allTables.contains(aliasedPathTable)) {
            allTables.add(aliasedPathTable);
        }
        allTables.add(aliasedPathTable);
        ArrayList<LogicalRelationship> cachedAliasedPath = new ArrayList<LogicalRelationship>();
        for (i = 0; i < aliasedPath.size(); ++i) {
            cachedAliasedPath.add(aliasedPath.getRelationship(i));
        }
        for (i = 0; i < cachedAliasedPath.size(); ++i) {
            LogicalRelationship rel = (LogicalRelationship)cachedAliasedPath.get(i);
            int index = -1;
            for (int j = 0; j < aliasedPath.size(); ++j) {
                if (aliasedPath.getRelationship(j) != rel) continue;
                index = j;
                break;
            }
            if (index == -1 || !rel.isUsingTable(aliasedTable)) continue;
            boolean joinsToADefaultTable = false;
            for (LogicalTable defaultTable : defaultTables) {
                if (!rel.isUsingTable(defaultTable)) continue;
                boolean inAliasedTables = false;
                for (LogicalTable aliased : aliasedTables) {
                    if (!defaultTable.equals(aliased)) continue;
                    inAliasedTables = true;
                }
                if (inAliasedTables) continue;
                joinsToADefaultTable = true;
                aliasedPath.removeRelationship(index);
                String leftAlias = null;
                String rightAlias = null;
                if (aliasedTable.equals(rel.getFromTable())) {
                    leftAlias = alias;
                    rightAlias = DEFAULT_ALIAS;
                } else {
                    leftAlias = DEFAULT_ALIAS;
                    rightAlias = alias;
                }
                allRelationships.add(new AliasedLogicalRelationship(leftAlias, rightAlias, rel));
            }
            if (joinsToADefaultTable) continue;
            aliasedPath.removeRelationship(index);
            allRelationships.add(new AliasedLogicalRelationship(alias, alias, rel));
            LogicalTable tbl = rel.getFromTable() == aliasedTable ? rel.getToTable() : rel.getFromTable();
            this.traversePath(alias, tbl, aliasedPath, aliasedTables, defaultTables, allTables, allRelationships);
        }
    }

    class AliasedLogicalRelationship {
        String leftAlias;
        String rightAlias;
        LogicalRelationship relation;

        AliasedLogicalRelationship(String left, String right, LogicalRelationship rel) {
            this.leftAlias = left;
            this.rightAlias = right;
            this.relation = rel;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SQLAndAliasedTables
    extends SqlAndTables {
        final List<AliasedPathLogicalTable> aliasedTables;

        public SQLAndAliasedTables(String sql, AliasedPathLogicalTable aliasedTable) {
            super(sql, (LogicalTable)null, (Selection)null);
            this.aliasedTables = new ArrayList<AliasedPathLogicalTable>();
            this.aliasedTables.add(aliasedTable);
        }

        public SQLAndAliasedTables(String sql, List<AliasedPathLogicalTable> aliasedTables) {
            super(sql, (LogicalTable)null, (Selection)null);
            this.aliasedTables = aliasedTables;
        }

        public List<AliasedPathLogicalTable> getAliasedLogicalTables() {
            return this.aliasedTables;
        }

        @Override
        public List<LogicalTable> getUsedTables() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setUsedTables(List<LogicalTable> tables) {
            throw new UnsupportedOperationException();
        }
    }

    static class AliasedPathLogicalTable {
        private String alias;
        private LogicalTable table;

        AliasedPathLogicalTable(String alias, LogicalTable table) {
            this.alias = alias;
            this.table = table;
        }

        public boolean equals(Object obj) {
            AliasedPathLogicalTable apbt = (AliasedPathLogicalTable)obj;
            return apbt.alias.equals(this.alias) && apbt.table.equals(this.table);
        }

        public String getAlias() {
            return this.alias;
        }

        public LogicalTable getLogicalTable() {
            return this.table;
        }
    }
}

