/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metadata.query.example;

import org.pentaho.metadata.model.Category;
import org.pentaho.metadata.model.LogicalColumn;
import org.pentaho.metadata.model.concept.types.AggregationType;
import org.pentaho.metadata.query.model.Selection;
import org.pentaho.pms.core.exception.PentahoMetadataException;

public class AliasedSelection
extends Selection {
    private static final long serialVersionUID = -4952224256796071909L;
    protected String alias;
    protected String formula;

    public String toString() {
        return "[bc=" + this.getLogicalColumn() + "; alias=" + this.alias + "; formula=" + this.formula + "]";
    }

    public AliasedSelection(Category category, LogicalColumn column, AggregationType agg, String alias) {
        super(category, column, agg);
        this.alias = alias;
    }

    public AliasedSelection(String formula) throws PentahoMetadataException {
        super(null, null, null);
        this.formula = formula;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getFormula() {
        return this.formula;
    }

    public boolean hasFormula() {
        return this.formula != null;
    }

    public int hashCode() {
        if (this.getLogicalColumn() != null) {
            return this.getLogicalColumn().getId().hashCode();
        }
        return this.formula.hashCode();
    }

    public boolean equals(Object selection) {
        AliasedSelection sel = (AliasedSelection)selection;
        if (this.hasFormula() && sel.hasFormula()) {
            return this.formula.equals(sel.getFormula());
        }
        if (!this.hasFormula() && !sel.hasFormula()) {
            return super.equals(selection);
        }
        return false;
    }
}

