/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metadata.query.impl.sql;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import org.pentaho.metadata.model.LogicalRelationship;
import org.pentaho.metadata.model.LogicalTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Path {
    private List<LogicalRelationship> path = new ArrayList<LogicalRelationship>();

    public void addRelationship(LogicalRelationship rel) {
        this.path.add(rel);
    }

    public void removeRelationship() {
        this.path.remove(this.size() - 1);
    }

    public LogicalRelationship removeRelationship(int i) {
        return this.path.remove(i);
    }

    public LogicalRelationship getLastRelationship() {
        return this.path.get(this.size() - 1);
    }

    public int size() {
        return this.path.size();
    }

    public int nrTables() {
        return this.getUsedTables().size();
    }

    public int score() {
        LogicalTable to;
        int score = 0;
        Number relSize = null;
        for (int i = 0; i < this.size(); ++i) {
            LogicalRelationship rel = this.getRelationship(i);
            LogicalTable from = rel.getFromTable();
            relSize = (Number)from.getProperty("relative_size");
            if (relSize == null || relSize.intValue() <= 0) continue;
            score += relSize.intValue();
        }
        if (this.size() > 0 && (relSize = (Number)(to = this.getLastRelationship().getToTable()).getProperty("relative_size")) != null && relSize.intValue() > 0) {
            score += relSize.intValue();
        }
        return score;
    }

    public LogicalRelationship getRelationship(int i) {
        return this.path.get(i);
    }

    public boolean contains(Path in) {
        if (in.size() == 0) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            int nr;
            for (nr = 0; this.getRelationship(i + nr).equals(in.getRelationship(nr)) && nr < in.size() && i + nr < this.size(); ++nr) {
            }
            if (nr != in.size()) continue;
            return true;
        }
        return false;
    }

    public boolean contains(LogicalRelationship rel) {
        if (rel == null) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            LogicalRelationship check = this.getRelationship(i);
            LogicalTable from = check.getFromTable();
            LogicalTable to = check.getToTable();
            if ((!rel.getFromTable().equals(from) || !rel.getToTable().equals(to)) && (!rel.getFromTable().equals(to) || !rel.getToTable().equals(from))) continue;
            return true;
        }
        return false;
    }

    public boolean contains(LogicalTable tab) {
        if (tab == null) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            LogicalRelationship check = this.getRelationship(i);
            if (!check.isUsingTable(tab)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        String thisPath = "";
        for (int i = 0; i < this.size(); ++i) {
            LogicalRelationship relationship = this.getRelationship(i);
            if (i > 0) {
                thisPath = thisPath + ", ";
            }
            thisPath = thisPath + "[" + relationship.getFromTable().getId() + "-" + relationship.getToTable().getId() + "]";
        }
        return thisPath;
    }

    public int compare(Path thisPath) {
        int diff = this.size() - thisPath.size();
        if (diff == 0 && (diff = this.nrTables() - thisPath.nrTables()) == 0) {
            diff = this.score() - thisPath.score();
        }
        if (diff < 0) {
            return -1;
        }
        if (diff > 0) {
            return 1;
        }
        return 0;
    }

    public List<LogicalTable> getUsedTables() {
        TreeSet<LogicalTable> treeSet = new TreeSet<LogicalTable>();
        for (int i = 0; i < this.size(); ++i) {
            LogicalRelationship rel = this.getRelationship(i);
            treeSet.add(rel.getFromTable());
            treeSet.add(rel.getToTable());
        }
        return new ArrayList<LogicalTable>(treeSet);
    }
}

