/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metadata.query.impl.sql.graph;

import org.pentaho.metadata.model.LogicalRelationship;
import org.pentaho.metadata.query.impl.sql.graph.ConsistencyException;
import org.pentaho.metadata.query.impl.sql.graph.GraphElement;
import org.pentaho.metadata.query.impl.sql.graph.GraphElementChangeListener;
import org.pentaho.metadata.query.impl.sql.graph.GraphElementDomain;
import org.pentaho.metadata.query.impl.sql.graph.GraphElementRequirement;
import org.pentaho.metadata.query.impl.sql.graph.Node;

public class Arc
implements GraphElement {
    private Node left;
    private Node right;
    private GraphElementDomain domain;
    private GraphElementChangeListener listener;
    private LogicalRelationship relationship;
    private boolean queued;

    public Arc(Node left, Node right, LogicalRelationship relationship, GraphElementChangeListener listener) {
        this.left = left;
        this.right = right;
        this.relationship = relationship;
        this.listener = listener;
        this.domain = new GraphElementDomain(this);
    }

    public boolean isRequired() {
        return this.domain.getRequirement() == GraphElementRequirement.REQUIRED;
    }

    public boolean isNotRequired() {
        return this.domain.getRequirement() == GraphElementRequirement.NOT_REQUIRED;
    }

    public boolean isRequirementKnown() {
        return this.domain.getRequirement() != GraphElementRequirement.UNKNOWN;
    }

    public Node getLeft() {
        return this.left;
    }

    public Node getRight() {
        return this.right;
    }

    public LogicalRelationship getRelationship() {
        return this.relationship;
    }

    public boolean isQueued() {
        return this.queued;
    }

    public void setQueued(boolean queued) {
        this.queued = queued;
    }

    public void setRequirement(boolean required) throws ConsistencyException {
        if (this.domain.setRequirement(required)) {
            if (required) {
                this.left.setRequirement(true);
                this.right.setRequirement(true);
            } else {
                this.left.prune();
                this.right.prune();
            }
            this.listener.graphElementChanged(this);
        }
    }

    public void clearRequirement() {
        this.domain.clearRequirement();
    }

    public void propagate(Node source) throws ConsistencyException {
        Node target;
        Node node = target = source == this.left ? this.right : this.left;
        if (source.isNotRequired()) {
            this.setRequirement(false);
        }
        switch (this.domain.getRequirement()) {
            case REQUIRED: {
                target.setRequirement(true);
                return;
            }
            case NOT_REQUIRED: {
                target.prune();
                return;
            }
        }
        if (source.isRequired() && !source.canReachNode(target, null)) {
            this.setRequirement(true);
        }
    }

    public String toString() {
        return "Arc: Left[" + this.left.getId() + "] -> Right[" + this.right.getId() + "]";
    }
}

