/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metadata.query.model.util;

import java.util.Comparator;
import org.apache.commons.math.MathException;
import org.apache.commons.math.util.DefaultTransformer;
import org.pentaho.metadata.messages.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BooleanComparator
implements Comparator<Object> {
    private static BooleanComparator _instance = new BooleanComparator();

    private BooleanComparator() {
    }

    public static Comparator<Object> getComparator() {
        return _instance;
    }

    public static Comparable<Object> getComparable(Object object) {
        final Boolean b = BooleanComparator.toBoolean(object);
        return new Comparable<Object>(){

            @Override
            public int compareTo(Object o) {
                return _instance.compare(b, o);
            }

            public String toString() {
                return "BooleanComparable[boolean=" + b + "]";
            }
        };
    }

    @Override
    public int compare(Object o1, Object o2) {
        Boolean b1 = BooleanComparator.toBoolean(o1);
        Boolean b2 = BooleanComparator.toBoolean(o2);
        return b1.compareTo(b2);
    }

    private static Boolean toBoolean(Object o) {
        if (o != null) {
            if (o instanceof Boolean) {
                return (Boolean)o;
            }
            if (o instanceof String) {
                try {
                    return BooleanComparator.parseBoolean((String)o);
                }
                catch (IllegalArgumentException e) {
                    return false;
                }
            }
            if (o instanceof Number) {
                try {
                    double number = new DefaultTransformer().transform(o);
                    if (number >= 1.0) {
                        return true;
                    }
                }
                catch (MathException mathException) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    public static boolean parseBoolean(String string) throws IllegalArgumentException {
        if ("true".equalsIgnoreCase(string = string.trim()) || "1".equals(string) || "y".equalsIgnoreCase(string) || "yes".equalsIgnoreCase(string)) {
            return true;
        }
        if ("false".equalsIgnoreCase(string) || "0".equals(string) || "n".equalsIgnoreCase(string) || "no".equalsIgnoreCase(string)) {
            return false;
        }
        throw new IllegalArgumentException(Messages.getErrorString("BooleanComparator.ERROR_0001_UNABLE_TO_DETECT_BOOLEAN_VAL", string));
    }
}

