/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metadata.query.model.util;

import java.util.Date;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.pentaho.metadata.messages.Messages;
import org.pentaho.metadata.model.concept.types.DataType;
import org.pentaho.metadata.query.model.util.BooleanComparator;

public class DataTypeDetector {
    public static final String[] COMMON_DATE_FORMATS = new String[]{"MM-dd-yyyy", "MM/dd/yyyy HH:mm:ss", "MM/dd/yyyy", "dd-MM-yyyy", "dd/MM/yyyy", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd", "yyyy/MM/dd", "MM-dd-yy", "MM/dd/yy", "dd-MM-yy", "dd/MM/yy"};

    public static DataType getDataType(String valueAsString) {
        DataType returnType = null;
        boolean _booleanPossible = true;
        boolean _integerPossible = true;
        boolean _doublePossible = true;
        boolean _datePossible = true;
        boolean _timePossible = true;
        boolean _nullPossible = false;
        if (valueAsString == null) {
            _nullPossible = true;
        } else {
            if (_booleanPossible) {
                try {
                    BooleanComparator.parseBoolean(valueAsString);
                }
                catch (IllegalArgumentException e) {
                    _booleanPossible = false;
                }
            }
            if (_doublePossible) {
                try {
                    Double.parseDouble(valueAsString);
                }
                catch (NumberFormatException e) {
                    _doublePossible = false;
                    _integerPossible = false;
                }
                if (_integerPossible) {
                    try {
                        Integer.parseInt(valueAsString);
                    }
                    catch (NumberFormatException e) {
                        _integerPossible = false;
                    }
                }
            }
            if (_datePossible) {
                DateTimeFormatter fmt = null;
                for (String mask : COMMON_DATE_FORMATS) {
                    try {
                        fmt = DateTimeFormat.forPattern((String)mask);
                        fmt.parseDateTime(valueAsString);
                        _datePossible = true;
                        break;
                    }
                    catch (IllegalArgumentException e) {
                        _datePossible = false;
                    }
                }
            }
            if (_timePossible) {
                try {
                    new LocalTime((Object)valueAsString);
                }
                catch (IllegalArgumentException e) {
                    _timePossible = false;
                }
            }
        }
        returnType = _booleanPossible ? DataType.BOOLEAN : (_integerPossible ? DataType.NUMERIC : (_doublePossible ? DataType.NUMERIC : (_datePossible ? DataType.DATE : (_timePossible ? DataType.DATE : DataType.STRING))));
        return returnType;
    }

    public static Object getValue(String valueAsString) {
        if (valueAsString != null) {
            DataType type = DataTypeDetector.getDataType(valueAsString);
            switch (type) {
                case STRING: {
                    return valueAsString;
                }
                case BOOLEAN: {
                    return BooleanComparator.parseBoolean(valueAsString);
                }
                case NUMERIC: {
                    return Integer.parseInt(valueAsString);
                }
                case DATE: {
                    LocalDate localDate = new LocalDate((Object)valueAsString);
                    return new Date(new DateTime(localDate.getYear(), localDate.getMonthOfYear(), localDate.getDayOfMonth(), 0, 0, 0, 0).getMillis());
                }
            }
            throw new IllegalStateException(Messages.getErrorString("DataTypeDetector.ERROR_0001_UNSUPPORTED_COLUMN_TYPE", new Object[]{type}));
        }
        return null;
    }
}

