/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metadata.query.model.util;

import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.pentaho.commons.connection.memory.MemoryMetaData;
import org.pentaho.metadata.messages.Messages;
import org.pentaho.metadata.model.LogicalColumn;
import org.pentaho.metadata.query.model.Selection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryModelMetaData
extends MemoryMetaData {
    private List<? extends Selection> columns;

    public QueryModelMetaData(Map columnsMap, Object[][] columnHeaders, Object[][] rowHeaders, List<? extends Selection> selections) {
        super(columnHeaders, rowHeaders);
        this.columns = selections;
        Object[][] newHeaders = columnHeaders;
        if (columnsMap != null) {
            TreeSet<String> existingHeaders = new TreeSet<String>();
            newHeaders = new Object[columnHeaders.length][];
            String newHeader = null;
            for (int i = 0; i < columnHeaders.length; ++i) {
                newHeaders[i] = new Object[columnHeaders[i].length];
                for (int j = 0; j < columnHeaders[i].length; ++j) {
                    Object key = columnHeaders[i][j];
                    if (key == null) continue;
                    newHeader = (String)columnsMap.get(key.toString().toUpperCase());
                    if (newHeader == null) {
                        newHeader = (String)columnsMap.get(key.toString());
                    }
                    if (newHeader == null) {
                        throw new RuntimeException(Messages.getErrorString("QueryModelMetaData.ERROR_0001_MetadataColumnNotFound", key.toString()));
                    }
                    newHeader = this.getUniqueHeader(newHeader, existingHeaders);
                    existingHeaders.add(newHeader);
                    newHeaders[i][j] = newHeader;
                }
            }
            this.columnHeaders = newHeaders;
        }
    }

    private String getUniqueHeader(String header, TreeSet<String> existingHeaders) {
        String newHeader = header;
        int count = 1;
        while (existingHeaders.contains(newHeader)) {
            newHeader = header + "_" + count++;
        }
        return newHeader;
    }

    public Object getAttribute(int rowNo, int columnNo, String attributeName) {
        if (rowNo == 0 && columnNo < this.columns.size()) {
            LogicalColumn column = this.columns.get(columnNo).getLogicalColumn();
            return column.getProperty(attributeName);
        }
        return null;
    }
}

