/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metadata.registry;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringEscapeUtils;
import org.pentaho.metadata.registry.Entity;
import org.pentaho.metadata.registry.Link;
import org.pentaho.metadata.registry.SimpleFileRegistry;

public class OrderedFileRegistry
extends SimpleFileRegistry {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws Exception {
        int idx = 0;
        Map<String, Map<String, Entity>> entities = this.getEntities();
        ArrayList<Entity> entityList = new ArrayList<Entity>();
        for (Map.Entry<String, Map<String, Entity>> entry : entities.entrySet()) {
            Map<String, Entity> typeMap = entry.getValue();
            Set<Map.Entry<String, Entity>> typeSet = typeMap.entrySet();
            for (Map.Entry<String, Entity> typeEntry : typeSet) {
                Entity entity = typeEntry.getValue();
                entityList.add(entity);
            }
        }
        Collections.sort(entityList);
        File file = new File(this.getFilePath());
        FileOutputStream out = new FileOutputStream(file);
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("");
            buffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            buffer.append("<!DOCTYPE properties SYSTEM \"http://java.sun.com/dtd/properties.dtd\">\n");
            buffer.append("<properties>\n");
            idx = 0;
            for (Entity entity : entityList) {
                this.addToBuffer(entity, buffer, idx);
                ++idx;
            }
            List<Link> links = this.getLinks();
            idx = 0;
            for (Link link : links) {
                this.addToBuffer(link, buffer, idx);
                ++idx;
            }
            buffer.append("</properties>");
            ((OutputStream)out).write(buffer.toString().getBytes());
        }
        finally {
            ((OutputStream)out).close();
        }
    }

    protected void addToBuffer(Entity entity, StringBuffer buffer, int idx) {
        this.addToBuffer("entity-" + idx + "-id", entity.getId(), buffer);
        this.addToBuffer("entity-" + idx + "-type", entity.getTypeId(), buffer);
        if (entity.getTitle() != null) {
            this.addToBuffer("entity-" + idx + "-title", entity.getTitle(), buffer);
        } else {
            this.addToBuffer("entity-" + idx + "-title", entity.getId(), buffer);
        }
        Map<String, String> attrMap = entity.getAttributes();
        int idx2 = 0;
        for (Map.Entry<String, String> attrEntry : attrMap.entrySet()) {
            String key = attrEntry.getKey();
            String value = attrEntry.getValue();
            this.addToBuffer("entity-" + idx + "-attrkey-" + idx2, key, buffer);
            this.addToBuffer("entity-" + idx + "-attrvalue-" + idx2, StringEscapeUtils.escapeJava((String)value), buffer);
            ++idx2;
        }
    }

    protected void addToBuffer(Link link, StringBuffer buffer, int idx) {
        this.addToBuffer("link-" + idx + "-subId", link.getSubjectId(), buffer);
        this.addToBuffer("link-" + idx + "-subType", link.getSubjectTypeId(), buffer);
        this.addToBuffer("link-" + idx + "-verb", link.getVerbId(), buffer);
        this.addToBuffer("link-" + idx + "-objId", link.getObjectId(), buffer);
        this.addToBuffer("link-" + idx + "-objType", link.getObjectTypeId(), buffer);
    }

    protected void addToBuffer(String id, String value, StringBuffer buffer) {
        buffer.append("<entry key=\"").append(id).append("\">").append(value).append("</entry>\n");
    }
}

