/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metadata.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.metadata.messages.Messages;
import org.pentaho.metadata.model.Domain;
import org.pentaho.metadata.model.concept.IConcept;
import org.pentaho.metadata.model.concept.types.LocaleType;
import org.pentaho.metadata.model.concept.types.LocalizedString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalizationUtil {
    private static final Log logger = LogFactory.getLog(LocalizationUtil.class);

    protected void exportLocalizedPropertiesRecursively(Properties props, IConcept parent, String locale) {
        for (String propName : parent.getChildProperties().keySet()) {
            if (!(parent.getChildProperty(propName) instanceof LocalizedString)) continue;
            String key = this.stringizeTokens(parent.getUniqueId()) + ".[" + this.escapeKey(propName) + "]";
            LocalizedString lstr = (LocalizedString)parent.getChildProperty(propName);
            String value = lstr.getLocalizedString(locale);
            if (value == null) {
                value = "";
            }
            props.setProperty(key, value);
        }
        if (parent.getChildren() != null) {
            for (IConcept child : parent.getChildren()) {
                this.exportLocalizedPropertiesRecursively(props, child, locale);
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("concept " + this.stringizeTokens(parent.getUniqueId()) + " does not have children"));
        }
    }

    public Properties exportLocalizedProperties(Domain domain, String locale) {
        Properties props = new Properties();
        this.exportLocalizedPropertiesRecursively(props, domain, locale);
        return props;
    }

    protected int findCloseBracket(String key, int start) {
        int end = key.indexOf("]", start);
        if (end == -1) {
            return -1;
        }
        if (end != key.length() - 1 && key.charAt(end + 1) == ']') {
            return this.findCloseBracket(key, end + 2);
        }
        return end;
    }

    protected String escapeKey(String key) {
        if (key.indexOf("]") < 0) {
            return key;
        }
        return key.replaceAll("\\]", "\\]\\]");
    }

    protected String unescapeKey(String key) {
        if (key.indexOf("]") < 0) {
            return key;
        }
        return key.replaceAll("\\]\\]", "\\]");
    }

    protected String stringizeTokens(List<String> keys) {
        if (keys.size() == 0) {
            return null;
        }
        String key = "[" + this.escapeKey(keys.get(0)) + "]";
        for (int i = 1; i < keys.size(); ++i) {
            key = key + ".[" + this.escapeKey(keys.get(i)) + "]";
        }
        return key;
    }

    protected List<String> splitTokens(String key) {
        ArrayList<String> tokens = new ArrayList<String>();
        int start = key.indexOf("[");
        while (start >= 0) {
            int end = this.findCloseBracket(key, start + 1);
            if (end == -1) {
                return null;
            }
            tokens.add(this.unescapeKey(key.substring(start + 1, end)));
            start = key.indexOf("[", end);
        }
        return tokens;
    }

    public List<String> analyzeImport(Domain domain, Properties props, String locale) {
        ArrayList<String> messages = new ArrayList<String>();
        Properties origProps = this.exportLocalizedProperties(domain, locale);
        Properties cloneOrig = (Properties)origProps.clone();
        for (Object key : origProps.keySet()) {
            if (!props.containsKey(key)) continue;
            cloneOrig.remove(key);
        }
        for (Object key : cloneOrig.keySet()) {
            messages.add(Messages.getString("LocalizationUtil.MISSING_KEY_MESSAGE", key));
        }
        Properties cloneProps = (Properties)props.clone();
        for (Object key : props.keySet()) {
            if (!origProps.containsKey(key)) continue;
            cloneProps.remove(key);
        }
        for (Object key : cloneProps.keySet()) {
            messages.add(Messages.getString("LocalizationUtil.EXTRA_KEY_MESSAGE", key));
        }
        return messages;
    }

    public void importLocalizedProperties(Domain domain, Properties props, String locale) {
        if (null == domain || null == props || StringUtils.isEmpty((String)locale)) {
            return;
        }
        List<LocaleType> localeTypes = domain.getLocales();
        boolean addLocale = true;
        if (localeTypes != null) {
            for (LocaleType localeType : localeTypes) {
                if (!localeType.getCode().equals(locale)) continue;
                addLocale = false;
                break;
            }
        }
        if (addLocale) {
            LocaleType localeType = new LocaleType();
            localeType.setCode(locale);
            domain.addLocale(localeType);
        }
        for (Object key : props.keySet()) {
            LocalizedString localizedString;
            List<String> tokens;
            String k = (String)key;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("importing key " + k + "=" + props.getProperty(k)));
            }
            if ((tokens = this.splitTokens(k)) == null || tokens.size() < 1) continue;
            String property = tokens.remove(tokens.size() - 1);
            IConcept concept = domain.getChildByUniqueId(tokens);
            if (concept == null || (localizedString = (LocalizedString)concept.getProperty(property)) == null) continue;
            localizedString.setString(locale, props.getProperty(k));
        }
    }
}

