/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pms.core;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.jmi.model.ModelPackage;
import javax.jmi.model.MofPackage;
import javax.jmi.reflect.RefObject;
import javax.jmi.reflect.RefPackage;
import javax.jmi.xmi.MalformedXMIException;
import org.netbeans.api.mdr.MDRepository;
import org.netbeans.api.xmi.XMIReader;
import org.netbeans.api.xmi.XMIReaderFactory;
import org.netbeans.api.xmi.XMIWriter;
import org.netbeans.api.xmi.XMIWriterFactory;
import org.netbeans.mdr.NBMDRepositoryImpl;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.BtreeFactory;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.pms.core.exception.CWMException;
import org.pentaho.pms.cwm.pentaho.PentahoPackage;
import org.pentaho.pms.cwm.pentaho.meta.MetaPackage;
import org.pentaho.pms.cwm.pentaho.meta.behavioral.BehavioralPackage;
import org.pentaho.pms.cwm.pentaho.meta.behavioral.CwmEvent;
import org.pentaho.pms.cwm.pentaho.meta.behavioral.CwmParameter;
import org.pentaho.pms.cwm.pentaho.meta.businessinformation.BusinessInformationPackage;
import org.pentaho.pms.cwm.pentaho.meta.businessinformation.CwmDescription;
import org.pentaho.pms.cwm.pentaho.meta.businessinformation.CwmDocument;
import org.pentaho.pms.cwm.pentaho.meta.businessinformation.ModelElementDescription;
import org.pentaho.pms.cwm.pentaho.meta.core.CorePackage;
import org.pentaho.pms.cwm.pentaho.meta.core.CwmAttribute;
import org.pentaho.pms.cwm.pentaho.meta.core.CwmClass;
import org.pentaho.pms.cwm.pentaho.meta.core.CwmClassifier;
import org.pentaho.pms.cwm.pentaho.meta.core.CwmDataType;
import org.pentaho.pms.cwm.pentaho.meta.core.CwmExpression;
import org.pentaho.pms.cwm.pentaho.meta.core.CwmModelElement;
import org.pentaho.pms.cwm.pentaho.meta.core.CwmNamespace;
import org.pentaho.pms.cwm.pentaho.meta.core.CwmPackage;
import org.pentaho.pms.cwm.pentaho.meta.core.CwmTaggedValue;
import org.pentaho.pms.cwm.pentaho.meta.core.TaggedElement;
import org.pentaho.pms.cwm.pentaho.meta.instance.CwmExtent;
import org.pentaho.pms.cwm.pentaho.meta.instance.InstancePackage;
import org.pentaho.pms.cwm.pentaho.meta.keysindexes.CwmKeyRelationship;
import org.pentaho.pms.cwm.pentaho.meta.keysindexes.KeysIndexesPackage;
import org.pentaho.pms.cwm.pentaho.meta.multidimensional.CwmDimension;
import org.pentaho.pms.cwm.pentaho.meta.multidimensional.CwmDimensionedObject;
import org.pentaho.pms.cwm.pentaho.meta.multidimensional.MultidimensionalPackage;
import org.pentaho.pms.cwm.pentaho.meta.olap.CwmCube;
import org.pentaho.pms.cwm.pentaho.meta.olap.CwmCubeDimensionAssociation;
import org.pentaho.pms.cwm.pentaho.meta.olap.CwmHierarchyLevelAssociation;
import org.pentaho.pms.cwm.pentaho.meta.olap.CwmLevel;
import org.pentaho.pms.cwm.pentaho.meta.olap.CwmLevelBasedHierarchy;
import org.pentaho.pms.cwm.pentaho.meta.olap.CwmMeasure;
import org.pentaho.pms.cwm.pentaho.meta.olap.CwmSchema;
import org.pentaho.pms.cwm.pentaho.meta.olap.OlapPackage;
import org.pentaho.pms.cwm.pentaho.meta.relational.CwmCatalog;
import org.pentaho.pms.cwm.pentaho.meta.relational.CwmColumn;
import org.pentaho.pms.cwm.pentaho.meta.relational.CwmTable;
import org.pentaho.pms.cwm.pentaho.meta.relational.RelationalPackage;
import org.pentaho.pms.messages.Messages;
import org.pentaho.pms.util.Const;

public class CWM {
    public static final LogChannelInterface log = new LogChannel((Object)Messages.getString("CWM.INFO_TITLE"));
    public static final String CWM = "CWM-Model-M3";
    public static final String PENTAHO = "Pentaho";
    public static final String META = "Meta";
    public static final String TAG_TABLE_TARGET_TABLE = "TABLE_TARGET_TABLE";
    public static final String TAG_TABLE_TARGET_DATABASE = "TABLE_TARGET_DATABASE_NAME";
    public static final String TAG_TABLE_IS_DRAWN = "TABLE_IS_DRAWN";
    public static final String TAG_TABLE_TYPE = "TABLE_TYPE";
    public static final String TAG_TABLE_SIZE = "TABLE_SIZE";
    public static final String TAG_COLUMN_FORMULA = "COLUMN_FORMULA";
    public static final String TAG_COLUMN_AGGREGATION_TYPE = "TAG_COLUMN_AGGREGATION_TYPE";
    public static final String TAG_COLUMN_FIELD_TYPE = "COLUMN_FIELD_TYPE";
    public static final String TAG_COLUMN_IS_HIDDEN = "COLUMN_IS_HIDDEN";
    public static final String TAG_COLUMN_IS_EXACT = "COLUMN_IS_EXACT";
    public static final String TAG_DATABASE_SERVER = "DATABASE_SERVER";
    public static final String TAG_DATABASE_TYPE = "DATABASE_TYPE";
    public static final String TAG_DATABASE_ACCESS = "DATABASE_ACCESS";
    public static final String TAG_DATABASE_DATABASE = "DATABASE_DATABASE";
    public static final String TAG_DATABASE_PORT = "DATABASE_PORT";
    public static final String TAG_DATABASE_USERNAME = "DATABASE_USERNAME";
    public static final String TAG_DATABASE_PASSWORD = "DATABASE_PASSWORD";
    public static final String TAG_DATABASE_SERVERNAME = "DATABASE_SERVERNAME";
    public static final String TAG_DATABASE_DATA_TABLESPACE = "DATABASE_DATA_TABLESPACE";
    public static final String TAG_DATABASE_INDEX_TABLESPACE = "DATABASE_INDEX_TABLESPACE";
    public static final String TAG_DATABASE_ATTRIBUTE_PREFIX = "DATABASE_ATTRIBUTE_PREFIX_";
    public static final String TAG_DATABASE_JDBC_URL = "DATABASE_JDBC_URL";
    private static final String TAG_POSITION_X = "TAG_POSITION_X";
    private static final String TAG_POSITION_Y = "TAG_POSITION_Y";
    private static final String TAG_POSITION_WIDTH = "TAG_POSITION_WIDTH";
    private static final String TAG_POSITION_HEIGHT = "TAG_POSITION_HEIGHT";
    public static final String TAG_RELATIONSHIP_TABLENAME_PARENT = "RELATIONSHIP_TABLENAME_PARENT";
    public static final String TAG_RELATIONSHIP_TABLENAME_CHILD = "RELATIONSHIP_TABLENAME_CHILD";
    public static final String TAG_RELATIONSHIP_FIELDNAME_PARENT = "RELATIONSHIP_FIELDNAME_PARENT";
    public static final String TAG_RELATIONSHIP_FIELDNAME_CHILD = "RELATIONSHIP_FIELDNAME_CHILD";
    public static final String TAG_RELATIONSHIP_COMPLEX_JOIN = "RELATIONSHIP_COMPLEX_JOIN";
    public static final String TAG_RELATIONSHIP_IS_COMPLEX = "RELATIONSHIP_IS_COMPLEX";
    public static final String TAG_RELATIONSHIP_TYPE = "RELATIONSHIP_TYPE";
    public static final String TAG_RELATIONSHIP_JOIN_ORDER_KEY = "RELATIONSHIP_JOIN_ORDER_KEY";
    public static final String TAG_RELATIONSHIP_DESCRIPTION = "RELATIONSHIP_DESCRIPTION";
    public static final String TAG_DOCUMENT_CONTENT = "DOCUMENT_CONTENT";
    public static final String TAG_BUSINESS_TABLE_PHYSICAL_TABLE_NAME = "BUSINESS_TABLE_PHYSICAL_TABLE_NAME";
    public static final String TAG_BUSINESS_COLUMN_PHYSICAL_COLUMN_NAME = "BUSINESS_COLUMN_PHYSICAL_COLUMN_NAME";
    public static final String TAG_BUSINESS_COLUMN_BUSINESS_TABLE = "BUSINESS_COLUMN_BUSINESS_TABLE";
    public static final String TAG_BUSINESS_CATEGORY_ROOT = "BUSINESS_CATEGORY_ROOT";
    public static final String TAG_BUSINESS_CATEGORY_TYPE = "BUSINESS_CATEGORY_TYPE";
    public static final String VALUE_BUSINESS_TYPE_CATEGORY = "Category";
    public static final String VALUE_BUSINESS_TYPE_COLUMN = "Column";
    public static final String TAG_CONCEPT_PARENT_NAME = "CONCEPT_PARENT_NAME";
    public static final String TAG_LOCALE_DESCRIPTION = "LOCALE_DESCRIPTION";
    public static final String TAG_LOCALE_ORDER = "LOCALE_ORDER";
    public static final String TAG_LOCALE_IS_ACTIVE = "LOCALE_IS_DEFAULT";
    public static final String LANGUAGE_PENTAHO_MODEL = "PENTAHO_MODEL";
    public static final String DESCRIPTION_TYPE_NOTEPAD = "NOTEPAD";
    public static final String EVENT_SECURITY_SERVICE = "SECURITY_SERVICE";
    public static final String TAG_SECURITY_SERVICE_URL = "SECURITY_SERVICE_URL";
    public static final String TAG_SECURITY_DETAILS_NAME = "SECURITY_DETAILS_NAME";
    public static final String TAG_SECURITY_DETAIL_NAME = "SECURITY_DETAIL_NAME";
    public static final String TAG_SECURITY_DETAIL_TYPE = "SECURITY_DETAIL_TYPE";
    public static final String TAG_SECURITY_USERNAME = "SECURITY_USERNAME";
    public static final String TAG_SECURITY_PASSWORD = "SECURITY_PASSWORD";
    public static final String TAG_SECURITY_PROXY_HOST = "SECURITY_PROXY_HOST";
    public static final String TAG_SECURITY_PROXY_PORT = "SECURITY_PROXY_PORT";
    public static final String TAG_SECURITY_NON_PROXY_HOSTS = "SECURITY_NON_PROXY_HOSTS";
    public static final String TAG_SECURITY_FILENAME = "SECURITY_FILENAME";
    public static final String TAG_SECURITY_URL = "SECURITY_URL";
    public static final String TAG_HIERARCHY_BUSINESS_TABLE = "HIERARCHY_BUSINESS_TABLE";
    public static final String TAG_HIERARCHY_PRIMARY_KEY = "HIERARCHY_PRIMARY_KEY";
    public static final String TAG_HIERARCHY_HAVING_ALL = "HIERARCHY_HAVING_ALL";
    public static final String TAG_HIERARCHY_LEVEL_UNIQUE_MEMBERS = "HIERARCHY_LEVEL_UNIQUE_MEMBERS";
    public static final String TAG_HIERARCHY_LEVEL_REFERENCE_COLUMN = "HIERARCHY_LEVEL_REFERENCE_COLUMN";
    public static final String TAG_CUBE_BUSINESS_TABLE = "CUBE_BUSINESS_TABLE";
    public static final String TAG_MEASURE_BUSINESS_COLUMN = "MEASURE_BUSINESS_COLUMN";
    private static Map<String, CWM> domains = Collections.synchronizedMap(new HashMap());
    private String domainName;
    private static MDRepository repository;
    private PentahoPackage pentahoPackage;
    private MetaPackage metaPackage;
    private RelationalPackage relationalPackage;
    private CorePackage corePackage;
    private BusinessInformationPackage businessInformationPackage;
    private KeysIndexesPackage keysIndexesPackage;
    private MultidimensionalPackage multiDimensionalPackage;
    private InstancePackage instancePackage;
    private BehavioralPackage behavioralPackage;
    private OlapPackage olapPackage;
    private boolean reversingOrder;

    private CWM(String domainName, boolean autoCreate) {
        this.domainName = domainName;
        try {
            RefPackage cwmPackageM3;
            repository = org.pentaho.pms.core.CWM.getRepositoryInstance();
            String storageFactoryClassName = System.getProperty("org.netbeans.mdr.storagemodel.StorageFactoryClassName", "");
            if (BtreeFactory.class.getName().equals(storageFactoryClassName)) {
                this.reversingOrder = true;
            }
            if ((cwmPackageM3 = repository.getExtent(CWM)) == null && autoCreate) {
                cwmPackageM3 = repository.createExtent(CWM);
                BufferedInputStream inputStream = new BufferedInputStream(this.getClass().getResourceAsStream("PentahoCWM.xml"));
                XMIReaderFactory.getDefault().createXMIReader().read((InputStream)inputStream, null, cwmPackageM3);
                log.logBasic(Messages.getString("CWM.INFO_TITLE"), new Object[]{Messages.getString("CWM.INFO_LOADED_CWM_MODEL"), null});
            }
            RefPackage refPackage = repository.getExtent(domainName);
            try {
                this.pentahoPackage = (PentahoPackage)refPackage;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (this.pentahoPackage == null) {
                if (autoCreate) {
                    this.pentahoPackage = (PentahoPackage)repository.createExtent(domainName, (RefObject)this.getModelPackage(PENTAHO));
                    log.logDebug(Messages.getString("CWM.INFO_INSTANCED_TOP_PACKAGE"));
                } else {
                    throw new CWMException(Messages.getErrorString("CWM.ERROR_0004_DOMAIN_NOT_FOUND", domainName));
                }
            }
            this.metaPackage = this.pentahoPackage.getMeta();
            this.corePackage = this.metaPackage.getCore();
            this.relationalPackage = this.metaPackage.getRelational();
            this.businessInformationPackage = this.metaPackage.getBusinessInformation();
            this.keysIndexesPackage = this.metaPackage.getKeysIndexes();
            this.multiDimensionalPackage = this.metaPackage.getMultidimensional();
            this.instancePackage = this.metaPackage.getInstance();
            this.behavioralPackage = this.metaPackage.getBehavioral();
            this.olapPackage = this.metaPackage.getOlap();
        }
        catch (Throwable e) {
            throw new RuntimeException(Messages.getErrorString("CWM.ERROR_0001_CANT_INITIALIZE_PMS"), e);
        }
    }

    public static final synchronized MDRepository getRepositoryInstance(Properties properties, InputStream xmiInputStream) throws CWMException {
        if (repository != null) {
            return repository;
        }
        repository = org.pentaho.pms.core.CWM.getRepository(properties, xmiInputStream);
        return repository;
    }

    public static final synchronized MDRepository getRepositoryInstance() throws CWMException {
        if (repository != null) {
            return repository;
        }
        repository = org.pentaho.pms.core.CWM.getRepository();
        return repository;
    }

    private static final MDRepository getRepository() throws CWMException {
        try {
            Properties properties = new Properties();
            properties.load(new FileInputStream("jdbc/repository.properties"));
            return org.pentaho.pms.core.CWM.getRepository(properties, null);
        }
        catch (Exception e) {
            throw new CWMException(Messages.getErrorString("CWM.ERROR_0002_CANT_ACCESS_REPOSITORY"), e);
        }
    }

    private static final MDRepository getRepository(Properties properties, InputStream xmiInputStream) throws CWMException {
        try {
            Properties systemProperties = System.getProperties();
            Properties backup = new Properties();
            Map m = (Map)systemProperties.clone();
            backup.putAll(m);
            systemProperties.putAll((Map<?, ?>)properties);
            String storageFactoryClassName = System.getProperty("org.netbeans.mdr.storagemodel.StorageFactoryClassName", "");
            try {
                NBMDRepositoryImpl mdRepository = new NBMDRepositoryImpl();
                RefPackage cwmPackageM3 = mdRepository.getExtent(CWM);
                if (cwmPackageM3 == null && xmiInputStream != null) {
                    cwmPackageM3 = mdRepository.createExtent(CWM);
                    BufferedInputStream inputStream = new BufferedInputStream(xmiInputStream);
                    XMIReaderFactory.getDefault().createXMIReader().read((InputStream)inputStream, null, cwmPackageM3);
                    log.logDebug(Messages.getString("CWM.INFO_LOADED_CWM_MODEL"));
                }
                return mdRepository;
            }
            catch (Exception e) {
                throw new CWMException(Messages.getErrorString("CWM.ERROR_0003_UNABLE_TO_ACCESS_CLASS", storageFactoryClassName), e);
            }
        }
        catch (Exception e) {
            throw new CWMException(Messages.getErrorString("CWM.ERROR_0002_CANT_ACCESS_REPOSITORY"), e);
        }
    }

    public static final CWM getInstance(String domainName) {
        return org.pentaho.pms.core.CWM.getInstance(domainName, true);
    }

    public static final synchronized CWM getInstance(String domainName, boolean autoCreate) throws IllegalArgumentException {
        if (domainName == null) {
            throw new IllegalArgumentException(Messages.getErrorString("CWM.ERROR_0005_DOMAIN_NAME_CANNOT_BE_NULL"));
        }
        CWM cwm = null;
        cwm = domains.get(domainName);
        if (null == cwm) {
            cwm = new CWM(domainName, autoCreate);
            domains.put(domainName, cwm);
        }
        return cwm;
    }

    public static final boolean exists(String domainName) throws CWMException {
        return org.pentaho.pms.core.CWM.getRepositoryInstance().getExtent(domainName) != null;
    }

    public static final String[] getDomainNames() throws CWMException {
        String[] ext = org.pentaho.pms.core.CWM.getRepositoryInstance().getExtentNames();
        ArrayList<String> domainNames = new ArrayList<String>();
        for (int i = 0; i < ext.length; ++i) {
            if (ext[i].equals("MOF") || ext[i].equals(CWM)) continue;
            domainNames.add(ext[i]);
        }
        return Const.sortStrings(domainNames.toArray(new String[domainNames.size()]));
    }

    public synchronized void removeDomain() throws CWMException {
        repository.beginTrans(true);
        repository.endTrans(false);
        RefPackage refPackage = repository.getExtent(this.domainName);
        if (refPackage != null) {
            refPackage.refDelete();
            this.removeFromList();
        }
    }

    public void beginTransaction() {
        repository.beginTrans(true);
    }

    public void endTransaction() {
        repository.endTrans();
    }

    public void rollback() {
        repository.endTrans(true);
    }

    public void removeFromList() {
        domains.remove(this.domainName);
    }

    public static final synchronized void quitAndSync() throws CWMException {
        org.pentaho.pms.core.CWM.getRepositoryInstance().shutdown();
        repository = null;
    }

    public static final synchronized void clearCache() throws CWMException {
        org.pentaho.pms.core.CWM.getRepositoryInstance().shutdown();
        repository = org.pentaho.pms.core.CWM.getRepository();
    }

    public static final synchronized void clearCache(Properties properties, InputStream xmiInputStream) throws CWMException {
        org.pentaho.pms.core.CWM.getRepositoryInstance().shutdown();
        repository = org.pentaho.pms.core.CWM.getRepository(properties, xmiInputStream);
    }

    public CwmTable createTable(String tableName) {
        CwmTable table = this.relationalPackage.getCwmTable().createCwmTable();
        table.setName(tableName);
        return table;
    }

    public CwmTable createTable(String tableName, RowMetaInterface fields) {
        CwmTable table = this.createTable(tableName);
        Collection collection = table.getOwnedElement();
        for (int i = fields.size() - 1; i >= 0; --i) {
            ValueMetaInterface field = fields.getValueMeta(i);
            CwmColumn column = this.createColumn(field);
            collection.add(column);
        }
        return table;
    }

    public CwmColumn createColumn(String columnName) {
        CwmColumn column = this.relationalPackage.getCwmColumn().createCwmColumn();
        column.setName(columnName);
        return column;
    }

    public CwmColumn createColumn(ValueMetaInterface value) {
        CwmColumn column = this.relationalPackage.getCwmColumn().createCwmColumn();
        column.setName(value.getName());
        column.setType((CwmClassifier)this.createDataType(value));
        column.setLength(new Integer(value.getLength()));
        column.setPrecision(new Integer(value.getPrecision()));
        return column;
    }

    public CwmDataType createDataType(ValueMetaInterface value) {
        return this.createDataType(value.getTypeDesc());
    }

    public CwmDataType createDataType(String dataTypeDesc) {
        CwmDataType dataType = this.corePackage.getCwmDataType().createCwmDataType();
        dataType.setName(dataTypeDesc);
        return dataType;
    }

    public CwmDescription createDescription(String body) {
        CwmDescription description = this.businessInformationPackage.getCwmDescription().createCwmDescription();
        description.setBody(body);
        return description;
    }

    public void setDescription(CwmModelElement modelElement, CwmDescription description) {
        ModelElementDescription modelElementDescription = this.businessInformationPackage.getModelElementDescription();
        modelElementDescription.add(modelElement, description);
    }

    public CwmTaggedValue createTaggedValue(String key, String value) {
        return this.corePackage.getCwmTaggedValue().createCwmTaggedValue(key, value);
    }

    public void addTaggedValue(CwmModelElement modelElement, String key, String value) {
        CwmTaggedValue taggedValue = this.createTaggedValue(key, value);
        TaggedElement taggedElement = this.corePackage.getTaggedElement();
        taggedElement.add(modelElement, taggedValue);
    }

    public CwmPackage createPackage(String packageName) {
        CwmPackage p = this.corePackage.getCwmPackage().createCwmPackage();
        p.setName(packageName);
        return p;
    }

    public CwmExpression createExpression(String body, String language) {
        return this.corePackage.getCwmExpression().createCwmExpression(body, language);
    }

    public CwmCatalog createCatalog(String name) {
        CwmCatalog catalog = this.relationalPackage.getCwmCatalog().createCwmCatalog();
        catalog.setName(name);
        return catalog;
    }

    public CwmParameter createParameter(String name) {
        CwmParameter paramter = this.behavioralPackage.getCwmParameter().createCwmParameter();
        paramter.setName(name);
        return paramter;
    }

    public void setPosition(CwmModelElement modelElement, int x, int y) {
        this.addTaggedValue(modelElement, TAG_POSITION_X, Integer.toString(x));
        this.addTaggedValue(modelElement, TAG_POSITION_Y, Integer.toString(y));
    }

    public void setWidth(CwmModelElement modelElement, int width) {
        this.addTaggedValue(modelElement, TAG_POSITION_WIDTH, Integer.toString(width));
    }

    public void setHeight(CwmModelElement modelElement, int height) {
        this.addTaggedValue(modelElement, TAG_POSITION_HEIGHT, Integer.toString(height));
    }

    public CwmKeyRelationship createRelationship() {
        return this.keysIndexesPackage.getCwmKeyRelationship().createCwmKeyRelationship();
    }

    public CwmDocument createDocument() {
        return this.businessInformationPackage.getCwmDocument().createCwmDocument();
    }

    public org.pentaho.pms.cwm.pentaho.meta.multidimensional.CwmSchema createSchema(String name) {
        org.pentaho.pms.cwm.pentaho.meta.multidimensional.CwmSchema cwmSchema = this.multiDimensionalPackage.getCwmSchema().createCwmSchema();
        cwmSchema.setName(name);
        return cwmSchema;
    }

    public CwmDimension createDimension(org.pentaho.pms.cwm.pentaho.meta.multidimensional.CwmSchema cwmSchema, String name) {
        CwmDimension cwmDimension = this.multiDimensionalPackage.getCwmDimension().createCwmDimension();
        cwmDimension.setSchema(cwmSchema);
        cwmDimension.setName(name);
        return cwmDimension;
    }

    public CwmDimensionedObject createDimensionedObject(String name) {
        CwmDimensionedObject cwmDimensionedObject = this.multiDimensionalPackage.getCwmDimensionedObject().createCwmDimensionedObject();
        cwmDimensionedObject.setName(name);
        return cwmDimensionedObject;
    }

    public CwmExtent createExtent(String name) {
        CwmExtent cwmExtent = this.instancePackage.getCwmExtent().createCwmExtent();
        cwmExtent.setName(name);
        return cwmExtent;
    }

    public CwmAttribute createAttribute(String name) {
        CwmAttribute cwmAttribute = this.corePackage.getCwmAttribute().createCwmAttribute();
        cwmAttribute.setName(name);
        return cwmAttribute;
    }

    public CwmClass createClass(String name) {
        CwmClass cwmClass = this.corePackage.getCwmClass().createCwmClass();
        cwmClass.setName(name);
        return cwmClass;
    }

    public org.pentaho.pms.cwm.pentaho.meta.olap.CwmDimension createOlapDimension(String name) {
        org.pentaho.pms.cwm.pentaho.meta.olap.CwmDimension cwmDimension = this.olapPackage.getCwmDimension().createCwmDimension();
        cwmDimension.setName(name);
        return cwmDimension;
    }

    public CwmSchema createOlapSchema(String name) {
        CwmSchema cwmSchema = this.olapPackage.getCwmSchema().createCwmSchema();
        cwmSchema.setName(name);
        return cwmSchema;
    }

    public CwmSchema findOlapSchema(String name) {
        Collection collection = this.olapPackage.getCwmSchema().refAllOfClass();
        for (CwmSchema cwmOlapSchema : collection) {
            if (!cwmOlapSchema.getName().equals(name)) continue;
            return cwmOlapSchema;
        }
        return null;
    }

    public CwmLevelBasedHierarchy createLevelBasedHierarchy(String name) {
        CwmLevelBasedHierarchy lbh = this.olapPackage.getCwmLevelBasedHierarchy().createCwmLevelBasedHierarchy();
        lbh.setName(name);
        return lbh;
    }

    public CwmLevel createLevel(String name) {
        CwmLevel cwmLevel = this.olapPackage.getCwmLevel().createCwmLevel();
        cwmLevel.setName(name);
        return cwmLevel;
    }

    public CwmHierarchyLevelAssociation createHierarchyLevelAssociation(String name) {
        CwmHierarchyLevelAssociation hla = this.olapPackage.getCwmHierarchyLevelAssociation().createCwmHierarchyLevelAssociation();
        hla.setName(name);
        return hla;
    }

    public CwmEvent createEvent(String name) {
        CwmEvent cwmEvent = this.behavioralPackage.getCwmEvent().createCwmEvent();
        cwmEvent.setName(name);
        return cwmEvent;
    }

    public boolean createEventParameter(CwmEvent cwmEvent, CwmParameter cwmParameter) {
        return this.behavioralPackage.getEventParameter().add(cwmEvent, cwmParameter);
    }

    public CwmCube createOlapCube(String name) {
        CwmCube cwmCube = this.olapPackage.getCwmCube().createCwmCube();
        cwmCube.setName(name);
        return cwmCube;
    }

    public CwmCubeDimensionAssociation createCubeDimensionAssocation(String name) {
        CwmCubeDimensionAssociation association = this.olapPackage.getCwmCubeDimensionAssociation().createCwmCubeDimensionAssociation();
        association.setName(name);
        return association;
    }

    public CwmMeasure createMeasure(String name) {
        CwmMeasure cwmMeasure = this.olapPackage.getCwmMeasure().createCwmMeasure();
        cwmMeasure.setName(name);
        return cwmMeasure;
    }

    public void removeTable(String tableName) {
        CwmTable table = this.getTable(tableName);
        if (table != null) {
            table.refDelete();
            log.logBasic(Messages.getString("CWM.INFO_REMOVED_TABLE", tableName));
        }
    }

    public void removePackage(String packageName) {
        CwmPackage p = this.getPackage(packageName);
        if (p != null) {
            p.refDelete();
        }
    }

    public CwmTable getTable(String tableName) {
        CwmTable[] tables = this.getTables();
        for (int i = 0; i < tables.length; ++i) {
            if (!tables[i].getName().equals(tableName)) continue;
            return tables[i];
        }
        return null;
    }

    public CwmTable[] getTables() {
        Collection collection = this.relationalPackage.getCwmTable().refAllOfClass();
        return collection.toArray(new CwmTable[collection.size()]);
    }

    public CwmDescription[] getDescription(CwmModelElement modelElement) {
        ModelElementDescription modelElementDescription = this.businessInformationPackage.getModelElementDescription();
        Collection collection = modelElementDescription.getDescription(modelElement);
        return collection.toArray(new CwmDescription[collection.size()]);
    }

    public CwmDescription[] getDescriptions() {
        Collection descriptions = this.businessInformationPackage.getCwmDescription().refAllOfClass();
        return descriptions.toArray(new CwmDescription[descriptions.size()]);
    }

    public CwmPackage[] getPackages() {
        Collection packages = this.corePackage.getCwmPackage().refAllOfClass();
        return packages.toArray(new CwmPackage[packages.size()]);
    }

    public CwmPackage getPackage(String packageName) {
        Collection packages = this.corePackage.getCwmPackage().refAllOfClass();
        for (CwmPackage p : packages) {
            if (!p.getName().equals(packageName)) continue;
            return p;
        }
        return null;
    }

    public CwmTaggedValue[] getTaggedValues(CwmModelElement modelElement) {
        Collection pairs = this.corePackage.getTaggedElement().getTaggedValue(modelElement);
        return pairs.toArray(new CwmTaggedValue[pairs.size()]);
    }

    public String getFirstTaggedValue(CwmModelElement modelElement, String tag) {
        Collection pairs = this.corePackage.getTaggedElement().getTaggedValue(modelElement);
        CwmTaggedValue[] found = org.pentaho.pms.core.CWM.findTaggedValues(pairs, tag);
        if (found.length > 0) {
            return found[0].getValue();
        }
        return null;
    }

    public String[] getTaggedValues(CwmModelElement modelElement, String tag) {
        Collection pairs = this.corePackage.getTaggedElement().getTaggedValue(modelElement);
        CwmTaggedValue[] found = org.pentaho.pms.core.CWM.findTaggedValues(pairs, tag);
        ArrayList<String> strings = new ArrayList<String>();
        for (int i = 0; i < found.length; ++i) {
            strings.add(found[i].getValue());
        }
        return strings.toArray(new String[strings.size()]);
    }

    public CwmCatalog[] getCatalogs() {
        Collection catalogs = this.relationalPackage.getCwmCatalog().refAllOfClass();
        return catalogs.toArray(new CwmCatalog[catalogs.size()]);
    }

    public int getPositionX(CwmModelElement modelElement) {
        try {
            return Integer.parseInt(this.getFirstTaggedValue(modelElement, TAG_POSITION_X));
        }
        catch (Exception e) {
            return -1;
        }
    }

    public int getPositionY(CwmModelElement modelElement) {
        try {
            return Integer.parseInt(this.getFirstTaggedValue(modelElement, TAG_POSITION_Y));
        }
        catch (Exception e) {
            return -1;
        }
    }

    public int getPositionWidth(CwmModelElement modelElement) {
        try {
            return Integer.parseInt(this.getFirstTaggedValue(modelElement, TAG_POSITION_WIDTH));
        }
        catch (Exception e) {
            return -1;
        }
    }

    public int getPositionHeight(CwmModelElement modelElement) {
        try {
            return Integer.parseInt(this.getFirstTaggedValue(modelElement, TAG_POSITION_HEIGHT));
        }
        catch (Exception e) {
            return -1;
        }
    }

    public CwmKeyRelationship[] getRelationships(org.pentaho.pms.cwm.pentaho.meta.multidimensional.CwmSchema cwmSchema) {
        ArrayList<CwmKeyRelationship> relationships = new ArrayList<CwmKeyRelationship>();
        Collection allElements = cwmSchema.getOwnedElement();
        for (Object element : allElements) {
            if (!(element instanceof CwmKeyRelationship)) continue;
            relationships.add((CwmKeyRelationship)element);
        }
        return relationships.toArray(new CwmKeyRelationship[relationships.size()]);
    }

    public org.pentaho.pms.cwm.pentaho.meta.multidimensional.CwmSchema[] getSchemas() {
        Collection schemas = this.multiDimensionalPackage.getCwmSchema().refAllOfClass();
        return schemas.toArray(new org.pentaho.pms.cwm.pentaho.meta.multidimensional.CwmSchema[schemas.size()]);
    }

    public CwmDimension[] getDimensions(org.pentaho.pms.cwm.pentaho.meta.multidimensional.CwmSchema cwmSchema) {
        ArrayList<CwmDimension> dimensions = new ArrayList<CwmDimension>();
        Collection allDimensions = this.multiDimensionalPackage.getCwmDimension().refAllOfClass();
        for (CwmDimension cwmDimension : allDimensions) {
            org.pentaho.pms.cwm.pentaho.meta.multidimensional.CwmSchema schema = cwmDimension.getSchema();
            if (schema == null || !schema.equals(cwmSchema)) continue;
            dimensions.add(cwmDimension);
        }
        return dimensions.toArray(new CwmDimension[dimensions.size()]);
    }

    public CwmExtent[] getRootExtents(org.pentaho.pms.cwm.pentaho.meta.multidimensional.CwmSchema cwmSchema) {
        ArrayList<CwmExtent> extents = new ArrayList<CwmExtent>();
        Collection allExtents = this.instancePackage.getCwmExtent().refAllOfClass();
        for (CwmExtent cwmExtent : allExtents) {
            String isRoot;
            CwmNamespace namespace = cwmExtent.getNamespace();
            if (namespace == null || !namespace.getName().equals(cwmSchema.getName()) || !(isRoot = org.pentaho.pms.core.CWM.findFirstTaggedValue(cwmExtent.getTaggedValue(), TAG_BUSINESS_CATEGORY_ROOT)).equalsIgnoreCase("Y")) continue;
            extents.add(cwmExtent);
        }
        return extents.toArray(new CwmExtent[extents.size()]);
    }

    public CwmClass[] getClasses() {
        Collection classes = this.corePackage.getCwmClass().refAllOfClass();
        return classes.toArray(new CwmClass[classes.size()]);
    }

    public CwmParameter[] getParameters() {
        Collection parameters = this.behavioralPackage.getCwmParameter().refAllOfClass();
        return parameters.toArray(new CwmParameter[parameters.size()]);
    }

    public CwmParameter getFirstParameterWithName(String name) {
        Collection parameters = this.behavioralPackage.getCwmParameter().refAllOfClass();
        for (CwmParameter cwmParameter : parameters) {
            if (!cwmParameter.getName().equals(name)) continue;
            return cwmParameter;
        }
        return null;
    }

    public CwmEvent getFirstEventWithName(String name) {
        Collection parameters = this.behavioralPackage.getCwmEvent().refAllOfClass();
        for (CwmEvent cwmEvent : parameters) {
            if (!cwmEvent.getName().equals(name)) continue;
            return cwmEvent;
        }
        return null;
    }

    private MofPackage getModelPackage(String packageName) {
        ModelPackage mofPackage = (ModelPackage)repository.getExtent(CWM);
        for (MofPackage result : mofPackage.getMofPackage().refAllOfClass()) {
            if (!result.getName().equals(packageName)) continue;
            return result;
        }
        return null;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public static final CwmTaggedValue[] findTaggedValues(Collection pairs, String tag) {
        ArrayList<CwmTaggedValue> found = new ArrayList<CwmTaggedValue>();
        for (CwmTaggedValue pair : pairs) {
            if (!pair.getTag().equals(tag)) continue;
            found.add(pair);
        }
        return found.toArray(new CwmTaggedValue[found.size()]);
    }

    public static final String findFirstTaggedValue(Collection pairs, String tag) {
        CwmTaggedValue[] found = org.pentaho.pms.core.CWM.findTaggedValues(pairs, tag);
        if (found.length > 0) {
            return found[0].getValue();
        }
        return null;
    }

    public PentahoPackage getPentahoPackage() {
        return this.pentahoPackage;
    }

    public void setPentahoPackage(PentahoPackage pentahoPackage) {
        this.pentahoPackage = pentahoPackage;
    }

    public BehavioralPackage getBehavioralPackage() {
        return this.behavioralPackage;
    }

    public BusinessInformationPackage getBusinessInformationPackage() {
        return this.businessInformationPackage;
    }

    public CorePackage getCorePackage() {
        return this.corePackage;
    }

    public InstancePackage getInstancePackage() {
        return this.instancePackage;
    }

    public KeysIndexesPackage getKeysIndexesPackage() {
        return this.keysIndexesPackage;
    }

    public MetaPackage getMetaPackage() {
        return this.metaPackage;
    }

    public MultidimensionalPackage getMultiDimensionalPackage() {
        return this.multiDimensionalPackage;
    }

    public RelationalPackage getRelationalPackage() {
        return this.relationalPackage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportToXMI(String filename) throws IOException, CWMException, MalformedXMIException {
        if (this.isReversingOrder()) {
            CWM cwm;
            XMIWriterFactory factory = XMIWriterFactory.getDefault();
            XMIWriter writer = factory.createXMIWriter();
            writer.getConfiguration().setEncoding("UTF-8");
            ByteArrayOutputStream stream = new ByteArrayOutputStream(250000);
            writer.write((OutputStream)stream, (RefPackage)this.getPentahoPackage(), "1.2");
            stream.close();
            String tmpDomain = "__tmpdomain__" + this.domainName + "__";
            try {
                if (org.pentaho.pms.core.CWM.exists(tmpDomain)) {
                    cwm = org.pentaho.pms.core.CWM.getInstance(tmpDomain);
                    cwm.removeDomain();
                }
                String xmi = stream.toString("UTF-8");
                CWM cwmInstance = org.pentaho.pms.core.CWM.getInstance(tmpDomain);
                cwmInstance.importFromXMIString(xmi);
                writer.write((OutputStream)new FileOutputStream(filename), (RefPackage)cwmInstance.getPentahoPackage(), "1.2");
            }
            finally {
                if (org.pentaho.pms.core.CWM.exists(tmpDomain)) {
                    cwm = org.pentaho.pms.core.CWM.getInstance(tmpDomain);
                    cwm.removeDomain();
                }
            }
        } else {
            XMIWriterFactory factory = XMIWriterFactory.getDefault();
            XMIWriter writer = factory.createXMIWriter();
            writer.getConfiguration().setEncoding("UTF-8");
            writer.write((OutputStream)new FileOutputStream(filename), (RefPackage)this.getPentahoPackage(), "1.2");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getXMI() throws IOException, CWMException, MalformedXMIException {
        XMIWriterFactory factory = XMIWriterFactory.getDefault();
        XMIWriter writer = factory.createXMIWriter();
        writer.getConfiguration().setEncoding("UTF-8");
        ByteArrayOutputStream stream = new ByteArrayOutputStream(250000);
        writer.write((OutputStream)stream, (RefPackage)this.getPentahoPackage(), "1.2");
        stream.close();
        if (this.isReversingOrder()) {
            CWM cwm;
            String tmpDomain = "__tmpdomain__" + this.domainName + "__";
            try {
                if (org.pentaho.pms.core.CWM.exists(tmpDomain)) {
                    cwm = org.pentaho.pms.core.CWM.getInstance(tmpDomain);
                    cwm.removeDomain();
                }
                String xmi = stream.toString("UTF-8");
                CWM cwmInstance = org.pentaho.pms.core.CWM.getInstance(tmpDomain);
                cwmInstance.importFromXMIString(xmi);
                stream = new ByteArrayOutputStream(250000);
                writer.write((OutputStream)stream, (RefPackage)cwmInstance.getPentahoPackage(), "1.2");
                stream.close();
            }
            finally {
                if (org.pentaho.pms.core.CWM.exists(tmpDomain)) {
                    cwm = org.pentaho.pms.core.CWM.getInstance(tmpDomain);
                    cwm.removeDomain();
                }
            }
        }
        return stream.toString();
    }

    public void importFromXMI(String filename) throws IOException, MalformedXMIException {
        FileInputStream inputStream = new FileInputStream(filename);
        this.importFromXMI(inputStream);
    }

    public void importFromXMI(InputStream inputStream) throws IOException, MalformedXMIException {
        XMIReaderFactory factory = XMIReaderFactory.getDefault();
        XMIReader reader = factory.createXMIReader();
        reader.read(inputStream, null, (RefPackage)this.getPentahoPackage());
        inputStream.close();
    }

    public void importFromXMIString(String xmi) throws IOException, MalformedXMIException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(xmi.getBytes("UTF-8"));
        this.importFromXMI(inputStream);
    }

    public boolean isReversingOrder() {
        return this.reversingOrder;
    }

    public void setReversingOrder(boolean reversingOrder) {
        this.reversingOrder = reversingOrder;
    }
}

