/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pms.example;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.pms.core.exception.PentahoMetadataException;
import org.pentaho.pms.example.AdvancedSQLGenerator;
import org.pentaho.pms.example.AliasAwarePMSFormula;
import org.pentaho.pms.factory.CwmSchemaFactoryInterface;
import org.pentaho.pms.messages.Messages;
import org.pentaho.pms.mql.MQLQueryImpl;
import org.pentaho.pms.mql.MappedQuery;
import org.pentaho.pms.mql.OrderBy;
import org.pentaho.pms.mql.PMSFormula;
import org.pentaho.pms.mql.Selection;
import org.pentaho.pms.mql.WhereCondition;
import org.pentaho.pms.schema.BusinessCategory;
import org.pentaho.pms.schema.BusinessColumn;
import org.pentaho.pms.schema.BusinessModel;
import org.pentaho.pms.schema.SchemaMeta;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AdvancedMQLQuery
extends MQLQueryImpl {
    private static final Log logger = LogFactory.getLog(AdvancedMQLQuery.class);
    private AdvancedSQLGenerator advancedSQLGenerator = new AdvancedSQLGenerator();

    public AdvancedMQLQuery(String XML, DatabaseMeta databaseMeta, String locale, CwmSchemaFactoryInterface factory) throws PentahoMetadataException {
        super(XML, databaseMeta, locale, factory);
    }

    public AdvancedMQLQuery(String XML, String locale, CwmSchemaFactoryInterface factory) throws PentahoMetadataException {
        super(XML, null, locale, factory);
    }

    public AdvancedMQLQuery(SchemaMeta schemaMeta, BusinessModel model, DatabaseMeta databaseMeta, String locale) {
        super(schemaMeta, model, databaseMeta, locale);
    }

    public void addSelection(AliasedSelection selection) {
        if (!selection.hasFormula() && selection.getBusinessColumn() == null) {
            throw new RuntimeException("Error adding selection, no formula or business column specified");
        }
        super.addSelection(selection);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void addSelectionFromXmlNode(Element selectionElement) {
        String column = null;
        String alias = null;
        String formula = null;
        NodeList nodes = selectionElement.getElementsByTagName("column");
        if (nodes.getLength() > 0 && (column = XMLHandler.getNodeValue((Node)nodes.item(0))) != null && column.trim().length() == 0) {
            column = null;
        }
        if ((nodes = selectionElement.getElementsByTagName("alias")).getLength() > 0 && (alias = XMLHandler.getNodeValue((Node)nodes.item(0))) != null && alias.trim().length() == 0) {
            alias = null;
        }
        if ((nodes = selectionElement.getElementsByTagName("formula")).getLength() > 0 && (formula = XMLHandler.getNodeValue((Node)nodes.item(0))) != null && formula.trim().length() == 0) {
            formula = null;
        }
        if (column != null) {
            BusinessColumn businessColumn = this.getModel().findBusinessColumn(column);
            if (businessColumn == null) throw new RuntimeException("Failed to find business column '" + column + "' in model.");
            this.addSelection(new AliasedSelection(businessColumn, alias));
            return;
        }
        if (formula == null) throw new RuntimeException("Failed to parse selection, no column or formula provided");
        try {
            this.addSelection(new AliasedSelection(formula));
            return;
        }
        catch (PentahoMetadataException e) {
            throw new RuntimeException(e);
        }
    }

    protected void addSelectionToDocument(Document doc, Selection selection, Element selectionElement) {
        AliasedSelection aliasedSelection = (AliasedSelection)selection;
        BusinessColumn column = selection.getBusinessColumn();
        Element element = doc.createElement("view");
        if (column != null) {
            BusinessCategory rootCat = this.getModel().getRootCategory();
            BusinessCategory businessCategory = rootCat.findBusinessCategoryForBusinessColumn(column);
            element.appendChild(doc.createTextNode(businessCategory.getId()));
            selectionElement.appendChild(element);
            element = doc.createElement("column");
            element.appendChild(doc.createTextNode(column.getId()));
            selectionElement.appendChild(element);
            if (aliasedSelection.getAlias() != null) {
                element = doc.createElement("alias");
                element.appendChild(doc.createTextNode(aliasedSelection.getAlias()));
                selectionElement.appendChild(element);
            }
        } else if (aliasedSelection.getFormula() != null) {
            element = doc.createElement("formula");
            element.appendChild(doc.createTextNode(aliasedSelection.getFormula()));
            selectionElement.appendChild(element);
        }
    }

    protected void addOrderByFromXmlNode(Element orderElement) throws PentahoMetadataException {
        boolean ascending = true;
        String view = null;
        String column = null;
        String formula = null;
        String alias = null;
        NodeList nodes = orderElement.getElementsByTagName("direction");
        if (nodes.getLength() > 0) {
            ascending = XMLHandler.getNodeValue((Node)nodes.item(0)).equals("asc");
        }
        if ((nodes = orderElement.getElementsByTagName("view")).getLength() > 0) {
            view = XMLHandler.getNodeValue((Node)nodes.item(0));
        }
        if ((nodes = orderElement.getElementsByTagName("column")).getLength() > 0) {
            column = XMLHandler.getNodeValue((Node)nodes.item(0));
        }
        if ((nodes = orderElement.getElementsByTagName("alias")).getLength() > 0) {
            alias = XMLHandler.getNodeValue((Node)nodes.item(0));
        }
        if ((nodes = orderElement.getElementsByTagName("formula")).getLength() > 0) {
            formula = XMLHandler.getNodeValue((Node)nodes.item(0));
        }
        if (view != null && column != null) {
            BusinessCategory rootCat = this.getModel().getRootCategory();
            BusinessCategory businessCategory = rootCat.findBusinessCategory(view);
            if (businessCategory == null) {
                throw new PentahoMetadataException(Messages.getErrorString("MQLQuery.ERROR_0014_BUSINESS_CATEGORY_NOT_FOUND", view));
            }
            BusinessColumn businessColumn = businessCategory.findBusinessColumn(column);
            if (businessColumn == null) {
                throw new PentahoMetadataException(Messages.getErrorString("MQLQuery.ERROR_0016_BUSINESS_COLUMN_NOT_FOUND", businessCategory.getId(), column));
            }
            this.getOrder().add(new OrderBy(new AliasedSelection(businessColumn, alias), ascending));
        } else if (formula != null) {
            this.getOrder().add(new OrderBy(new AliasedSelection(formula), ascending));
        } else {
            throw new PentahoMetadataException("no column or formula specified");
        }
    }

    protected void addOrderByToDocument(Document doc, OrderBy orderBy, Element orderElement) {
        Element element = doc.createElement("direction");
        element.appendChild(doc.createTextNode(orderBy.isAscending() ? "asc" : "desc"));
        orderElement.appendChild(element);
        AliasedSelection selection = (AliasedSelection)orderBy.getSelection();
        if (!selection.hasFormula()) {
            element = doc.createElement("view");
            BusinessCategory rootCat = this.getModel().getRootCategory();
            BusinessCategory businessView = rootCat.findBusinessCategoryForBusinessColumn(selection.getBusinessColumn());
            element.appendChild(doc.createTextNode(businessView.getId()));
            orderElement.appendChild(element);
            element = doc.createElement("column");
            element.appendChild(doc.createTextNode(selection.getBusinessColumn().getId()));
            orderElement.appendChild(element);
            if (selection.getAlias() != null) {
                orderElement.appendChild(element);
                element = doc.createElement("alias");
                element.appendChild(doc.createTextNode(selection.getAlias()));
                orderElement.appendChild(element);
            }
        } else {
            orderElement.appendChild(element);
            element = doc.createElement("formula");
            element.appendChild(doc.createTextNode(selection.getFormula()));
            orderElement.appendChild(element);
        }
    }

    public void addConstraint(String operator, String condition) throws PentahoMetadataException {
        List<Selection> aliases = super.getSelections();
        AliasAwarePMSFormula formula = new AliasAwarePMSFormula(this.getModel(), this.getDatabaseMeta(), condition, aliases, "__DEFAULT__");
        formula.setAllowAggregateFunctions(true);
        WhereCondition where = new WhereCondition(formula, operator, condition);
        this.getConstraints().add(where);
    }

    public void addOrderBy(AliasedSelection selection, boolean ascending) {
        this.getOrder().add(new OrderBy(selection, ascending));
    }

    public MappedQuery getQuery() throws PentahoMetadataException {
        return this.advancedSQLGenerator.getQuery(this.getModel(), this.getSelections(), this.getConstraints(), this.getOrder(), this.getDatabaseMeta(), this.getDisableDistinct(), this.getLimit(), this.getLocale());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AliasedSelection
    extends Selection {
        String alias;
        String formula;
        PMSFormula pmsformula;
        Boolean hasAgg;

        public String toString() {
            return "[bc=" + this.getBusinessColumn() + "; alias=" + this.alias + "; formula=" + this.formula + "]";
        }

        public AliasedSelection(BusinessColumn column, String alias) {
            super(column);
            this.alias = alias;
        }

        public AliasedSelection(String formula) throws PentahoMetadataException {
            super(null);
            this.formula = formula;
        }

        public String getAlias() {
            return this.alias;
        }

        public String getFormula() {
            return this.formula;
        }

        public void initPMSFormula(BusinessModel model, DatabaseMeta databaseMeta, List<Selection> selections) throws PentahoMetadataException {
            this.pmsformula = new AliasAwarePMSFormula(model, databaseMeta, this.formula, selections, "__DEFAULT__");
            this.pmsformula.setAllowAggregateFunctions(true);
            this.pmsformula.parseAndValidate();
        }

        @Override
        public boolean hasAggregate() {
            if (this.hasAgg == null) {
                this.hasAgg = false;
                if (this.getBusinessColumn() != null) {
                    this.hasAgg = this.getBusinessColumn().hasAggregate();
                    return this.hasAgg;
                }
                for (Selection sel : this.pmsformula.getBusinessColumns()) {
                    if (!sel.hasAggregate()) continue;
                    this.hasAgg = true;
                    return this.hasAgg;
                }
                if (this.pmsformula.hasAggregateFunction()) {
                    this.hasAgg = true;
                    return this.hasAgg;
                }
            }
            return this.hasAgg;
        }

        public PMSFormula getPMSFormula() {
            return this.pmsformula;
        }

        public boolean hasFormula() {
            return this.formula != null;
        }

        public boolean equals(Object obj) {
            AliasedSelection abc = (AliasedSelection)obj;
            return this.equals(abc.getBusinessColumn(), this.getBusinessColumn()) && this.equals(this.alias, abc.getAlias()) && this.equals(this.formula, abc.getFormula());
        }

        public boolean equals(Object a, Object b) {
            return a == null && b == null || a != null && b != null && a.equals(b);
        }
    }
}

