/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pms.messages.util;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.Locale;

public class LocaleHelper {
    private static final ThreadLocal<Locale> threadLocales = new ThreadLocal();
    private static Locale defaultLocale;
    public static final String UTF_8 = "UTF-8";
    private static String encoding;
    public static final String LEFT_TO_RIGHT = "LTR";
    private static String textDirection;

    public static void setDefaultLocale(Locale newLocale) {
        defaultLocale = newLocale;
    }

    public static Locale getDefaultLocale() {
        return defaultLocale;
    }

    public static void setLocale(Locale newLocale) {
        threadLocales.set(newLocale);
    }

    public static Locale getLocale() {
        Locale rtn = threadLocales.get();
        if (rtn != null) {
            return rtn;
        }
        defaultLocale = Locale.getDefault();
        LocaleHelper.setLocale(defaultLocale);
        return defaultLocale;
    }

    public static void setSystemEncoding(String encoding) {
        LocaleHelper.encoding = encoding;
    }

    public static void setTextDirection(String textDirection) {
        LocaleHelper.textDirection = textDirection;
    }

    public static String getSystemEncoding() {
        return encoding;
    }

    public static String getTextDirection() {
        return textDirection;
    }

    public static String getClosestLocale(String locale, String[] locales) {
        if (locales == null || locales.length == 0) {
            return locale;
        }
        if (locale == null || locale.length() == 0) {
            return locales[0];
        }
        String localeLanguage = locale.substring(0, 2);
        String localeCountry = locale.length() > 4 ? locale.substring(0, 5) : localeLanguage;
        int looseMatch = -1;
        int closeMatch = -1;
        int exactMatch = -1;
        for (int idx = 0; idx < locales.length; ++idx) {
            if (locales[idx].equals(locale)) {
                exactMatch = idx;
                break;
            }
            if (locales[idx].length() > 1 && locales[idx].substring(0, 2).equals(localeLanguage)) {
                looseMatch = idx;
                continue;
            }
            if (locales[idx].length() <= 4 || !locales[idx].substring(0, 5).equals(localeCountry)) continue;
            closeMatch = idx;
        }
        if (exactMatch == -1) {
            locale = closeMatch != -1 ? locales[closeMatch] : (looseMatch != -1 ? locales[looseMatch] : locales[0]);
        }
        return locale;
    }

    public static String convertISOStringToSystemDefaultEncoding(String isoString) {
        return LocaleHelper.convertEncodedStringToSystemDefaultEncoding("ISO-8859-1", isoString);
    }

    public static String convertEncodedStringToSystemDefaultEncoding(String fromEncoding, String encodedStr) {
        return LocaleHelper.convertStringEncoding(encodedStr, fromEncoding, LocaleHelper.getSystemEncoding());
    }

    public static String isoToUtf8(String isoString) {
        return LocaleHelper.convertStringEncoding(isoString, "ISO-8859-1", UTF_8);
    }

    public static String utf8ToIso(String utf8String) {
        return LocaleHelper.convertStringEncoding(utf8String, UTF_8, "ISO-8859-1");
    }

    public static String convertStringEncoding(String sourceString, String sourceEncoding, String targetEncoding) {
        String targetString = null;
        if (null != sourceString && !sourceString.equals("")) {
            try {
                byte[] stringBytesSource = sourceString.getBytes(sourceEncoding);
                targetString = new String(stringBytesSource, targetEncoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        } else {
            targetString = sourceString;
        }
        return targetString;
    }

    public static boolean isAscii(String aString) {
        return LocaleHelper.isWithinCharset(aString, "US-ASCII");
    }

    public static boolean isLatin1(String aString) {
        return LocaleHelper.isWithinCharset(aString, "ISO-8859-1");
    }

    public static boolean isWithinCharset(String aString, String charsetTarget) {
        byte[] stringBytes = aString.getBytes();
        CharsetDecoder decoder = Charset.forName(charsetTarget).newDecoder();
        try {
            decoder.decode(ByteBuffer.wrap(stringBytes));
            return true;
        }
        catch (CharacterCodingException ignored) {
            return false;
        }
    }

    static {
        encoding = UTF_8;
        textDirection = LEFT_TO_RIGHT;
    }
}

