/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pms.mql.dialect;

import org.pentaho.pms.core.exception.PentahoMetadataException;
import org.pentaho.pms.messages.Messages;
import org.pentaho.pms.mql.dialect.FormulaTraversalInterface;
import org.pentaho.pms.mql.dialect.SQLFunctionGeneratorInterface;
import org.pentaho.reporting.libraries.formula.lvalues.ContextLookup;
import org.pentaho.reporting.libraries.formula.lvalues.FormulaFunction;
import org.pentaho.reporting.libraries.formula.lvalues.StaticValue;
import org.pentaho.reporting.libraries.formula.typing.coretypes.NumberType;
import org.pentaho.reporting.libraries.formula.typing.coretypes.TextType;

public class DefaultSQLFunctionGenerator
implements SQLFunctionGeneratorInterface {
    protected int type;
    protected int paramCount = -1;
    protected String sql;
    protected boolean parens = true;
    protected boolean multiValuedParamAware = false;

    public DefaultSQLFunctionGenerator(int type) {
        this.type = type;
    }

    public DefaultSQLFunctionGenerator(int type, String sql) {
        this(type);
        this.sql = sql;
    }

    public DefaultSQLFunctionGenerator(int type, String sql, boolean parens) {
        this(type);
        this.sql = sql;
        this.parens = parens;
    }

    public DefaultSQLFunctionGenerator(int type, String sql, int paramCount, boolean parens) {
        this(type, sql);
        this.paramCount = paramCount;
        this.parens = parens;
    }

    public DefaultSQLFunctionGenerator(int type, String sql, int paramCount) {
        this(type, sql);
        this.paramCount = paramCount;
    }

    public void validateFunction(FormulaFunction f) throws PentahoMetadataException {
        if (this.paramCount != -1 && (f.getChildValues() == null || f.getChildValues().length != this.paramCount)) {
            throw new PentahoMetadataException(Messages.getErrorString("PMSFormulaContext.ERROR_0002_INVALID_NUMBER_PARAMS", f.getFunctionName(), "" + this.paramCount));
        }
    }

    protected void verifyAllStaticNumbers(FormulaFunction f) throws PentahoMetadataException {
        for (int i = 0; i < f.getChildValues().length; ++i) {
            if (f.getChildValues()[i] instanceof StaticValue && ((StaticValue)f.getChildValues()[i]).getValueType() == NumberType.GENERIC_NUMBER) continue;
            throw new PentahoMetadataException(Messages.getErrorString("PMSFormulaContext.ERROR_0003_INVALID_PARAM_TYPE_NOT_STATIC_NUMBER", Integer.toString(i + 1), f.getFunctionName()));
        }
    }

    protected void verifyAllStaticStrings(FormulaFunction f) throws PentahoMetadataException {
        for (int i = 0; i < f.getChildValues().length; ++i) {
            if (f.getChildValues()[i] instanceof StaticValue && ((StaticValue)f.getChildValues()[i]).getValueType() instanceof TextType || f.getChildValues()[i] instanceof ContextLookup && ((ContextLookup)f.getChildValues()[i]).getName().startsWith("param:")) continue;
            throw new PentahoMetadataException(Messages.getErrorString("PMSFormulaContext.ERROR_0004_INVALID_PARAM_TYPE_NOT_STRING", Integer.toString(i + 1), f.getFunctionName()));
        }
    }

    public int getType() {
        return this.type;
    }

    protected String getSQL() {
        return this.sql;
    }

    public void generateFunctionSQL(FormulaTraversalInterface formula, StringBuffer sb, String locale, FormulaFunction f) throws PentahoMetadataException {
        if (this.type == 0) {
            if (f.getChildValues() != null && f.getChildValues().length > 0) {
                formula.generateSQL(f, f.getChildValues()[0], sb, locale);
                if (this.paramCount == 1) {
                    sb.append(" " + this.getSQL());
                } else {
                    for (int i = 1; i < f.getChildValues().length; ++i) {
                        sb.append(" " + this.getSQL() + " ");
                        formula.generateSQL(f, f.getChildValues()[i], sb, locale);
                    }
                }
            }
        } else if (this.type == 1 || this.type == 2) {
            sb.append(" " + this.getSQL());
            if (this.parens) {
                sb.append("(");
            }
            if (f.getChildValues() != null && f.getChildValues().length > 0) {
                formula.generateSQL(f, f.getChildValues()[0], sb, locale);
                for (int i = 1; i < f.getChildValues().length; ++i) {
                    sb.append(" , ");
                    formula.generateSQL(f, f.getChildValues()[i], sb, locale);
                }
            }
            if (this.parens) {
                sb.append(")");
            }
        }
    }

    public boolean isMultiValuedParamAware() {
        return this.multiValuedParamAware;
    }

    public void setMultiValuedParamAware(boolean multiValuedParamAware) {
        this.multiValuedParamAware = multiValuedParamAware;
    }
}

