/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pms.mql.dialect;

import org.pentaho.pms.core.exception.PentahoMetadataException;
import org.pentaho.pms.mql.dialect.DefaultSQLDialect;
import org.pentaho.pms.mql.dialect.DefaultSQLFunctionGenerator;
import org.pentaho.pms.mql.dialect.FormulaTraversalInterface;
import org.pentaho.pms.mql.dialect.SQLQueryModel;
import org.pentaho.reporting.libraries.formula.lvalues.FormulaFunction;

public class PostgreSQLDialect
extends DefaultSQLDialect {
    public PostgreSQLDialect() {
        super("POSTGRESQL");
        this.supportedFunctions.put("NOW", new DefaultSQLFunctionGenerator(1, "now", 0){

            public void generateFunctionSQL(FormulaTraversalInterface formula, StringBuffer sb, String locale, FormulaFunction f) throws PentahoMetadataException {
                sb.append(this.sql);
            }
        });
    }

    public String getDateSQL(int year, int month, int day) {
        return "date " + this.quoteStringLiteral(year + "-" + this.displayAsTwoOrMoreDigits(month) + "-" + this.displayAsTwoOrMoreDigits(day));
    }

    public String getDateSQL(int year, int month, int day, int hour, int minute, int second, int milli) {
        return "timestamp " + this.quoteStringLiteral(year + "-" + this.displayAsTwoOrMoreDigits(month) + "-" + this.displayAsTwoOrMoreDigits(day) + " " + this.displayAsTwoOrMoreDigits(hour) + ":" + this.displayAsTwoOrMoreDigits(minute) + ":" + this.displayAsTwoOrMoreDigits(second) + "." + milli);
    }

    public int getMaxTableNameLength() {
        return 63;
    }

    protected String getStringConcatOperator() {
        return "||";
    }

    public boolean supportsNLSLiteral() {
        return true;
    }

    protected void generatePostOrderBy(SQLQueryModel query, StringBuilder sql) {
        this.generateLimit(query, sql);
    }

    protected void generateSelectPredicate(SQLQueryModel query, StringBuilder sql) {
        this.generateDistinct(query, sql);
    }
}

