/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pms.mql.dialect;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.metadata.messages.Messages;
import org.pentaho.pms.mql.dialect.DB2Dialect;
import org.pentaho.pms.mql.dialect.DefaultSQLDialect;
import org.pentaho.pms.mql.dialect.FirebirdDialect;
import org.pentaho.pms.mql.dialect.H2Dialect;
import org.pentaho.pms.mql.dialect.HiveDialect;
import org.pentaho.pms.mql.dialect.HypersonicDialect;
import org.pentaho.pms.mql.dialect.IngresDialect;
import org.pentaho.pms.mql.dialect.LucidDbDialect;
import org.pentaho.pms.mql.dialect.MSAccessDialect;
import org.pentaho.pms.mql.dialect.MSSQLDialect;
import org.pentaho.pms.mql.dialect.MySQLDialect;
import org.pentaho.pms.mql.dialect.NetezzaDialect;
import org.pentaho.pms.mql.dialect.OracleDialect;
import org.pentaho.pms.mql.dialect.PostgreSQLDialect;
import org.pentaho.pms.mql.dialect.SQLDialectInterface;
import org.pentaho.pms.mql.dialect.SybaseDialect;

public class SQLDialectFactory {
    private static SQLDialectFactory singleton = new SQLDialectFactory();
    private Map<String, SQLDialectInterface> supportedDialects = new HashMap<String, SQLDialectInterface>();
    private final Log logger = LogFactory.getLog(SQLDialectFactory.class);

    private SQLDialectFactory() {
        this.registerCoreDialects();
        this.loadDialectPlugins();
    }

    private void registerCoreDialects() {
        this.addDialect(new DefaultSQLDialect());
        this.addDialect(new OracleDialect());
        this.addDialect(new MSSQLDialect());
        this.addDialect(new DB2Dialect());
        this.addDialect(new PostgreSQLDialect());
        this.addDialect(new MySQLDialect());
        this.addDialect(new MSAccessDialect());
        this.addDialect(new NetezzaDialect());
        this.addDialect(new H2Dialect());
        this.addDialect(new HypersonicDialect());
        this.addDialect(new SybaseDialect());
        this.addDialect(new IngresDialect());
        this.addDialect(new FirebirdDialect());
        this.addDialect(new LucidDbDialect());
        if (HiveDialect.canLoad()) {
            this.addDialect(new HiveDialect());
        }
    }

    private void loadDialectPlugins() {
        ServiceLoader<SQLDialectInterface> dialects = ServiceLoader.load(SQLDialectInterface.class);
        Iterator<SQLDialectInterface> dialectIter = dialects.iterator();
        while (dialectIter.hasNext()) {
            SQLDialectInterface dialect;
            block3: {
                dialect = null;
                try {
                    dialect = dialectIter.next();
                }
                catch (ServiceConfigurationError err) {
                    this.logger.warn((Object)Messages.getErrorString("SQLDialectFactory.WARN_0001_DIALECT_COULD_NOT_BE_LOADED", err.getMessage()));
                    if (!this.logger.isDebugEnabled()) break block3;
                    this.logger.debug((Object)Messages.getErrorString("SQLDialectFactory.WARN_0001_DIALECT_COULD_NOT_BE_LOADED", err.getMessage()), (Throwable)err);
                }
            }
            if (dialect == null) continue;
            this.addDialect(dialect);
        }
    }

    private void addDialect(SQLDialectInterface dialect) {
        this.supportedDialects.put(dialect.getDatabaseType(), dialect);
        this.logger.info((Object)Messages.getString("SQLDialectFactory.INFO_0001_DIALECT_REGISTERED", dialect.getDatabaseType()));
    }

    public static SQLDialectInterface getSQLDialect(DatabaseMeta databaseMeta) {
        SQLDialectInterface sqlDialect = SQLDialectFactory.singleton.supportedDialects.get(databaseMeta.getDatabaseTypeDesc());
        if (sqlDialect == null) {
            sqlDialect = SQLDialectFactory.singleton.supportedDialects.get("GENERIC");
        }
        return sqlDialect;
    }
}

