/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pms.schema.concept;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.pentaho.di.core.changed.ChangedFlag;
import org.pentaho.pms.schema.concept.ConceptInterface;
import org.pentaho.pms.schema.concept.ConceptPropertyInterface;
import org.pentaho.pms.schema.concept.DefaultPropertyID;
import org.pentaho.pms.schema.concept.types.ConceptPropertyBase;
import org.pentaho.pms.schema.concept.types.ConceptPropertyType;
import org.pentaho.pms.schema.concept.types.localstring.ConceptPropertyLocalizedString;
import org.pentaho.pms.schema.concept.types.localstring.LocalizedStringSettings;
import org.pentaho.pms.schema.concept.types.security.ConceptPropertySecurity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Concept
extends ChangedFlag
implements ConceptInterface,
Cloneable {
    private String name;
    private Map<String, ConceptPropertyInterface> childPropertyInterfaces = new Hashtable<String, ConceptPropertyInterface>();
    private ConceptInterface parentInterface;
    private ConceptInterface inheritedInterface;
    private ConceptInterface securityParentInterface;

    public Concept() {
    }

    public Concept(String name) {
        this();
        this.name = name;
    }

    public Concept(String name, ConceptInterface parentInterface) {
        this(name);
        this.parentInterface = parentInterface;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Concept)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        Concept rhs = (Concept)obj;
        return new EqualsBuilder().append((Object)this.name, (Object)rhs.name).append(this.childPropertyInterfaces, rhs.childPropertyInterfaces).append((Object)this.parentInterface, (Object)rhs.parentInterface).append((Object)this.inheritedInterface, (Object)rhs.inheritedInterface).append((Object)this.securityParentInterface, (Object)rhs.securityParentInterface).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(131, 173).append((Object)this.name).append((Object)this.parentInterface).append((Object)this.inheritedInterface).append((Object)this.securityParentInterface).toHashCode();
    }

    @Override
    public Object clone() {
        try {
            Concept concept = new Concept();
            concept.setName(this.name);
            concept.setParentInterface(this.parentInterface);
            concept.setInheritedInterface(this.inheritedInterface);
            if (this.securityParentInterface != null) {
                concept.setSecurityParentInterface((ConceptInterface)this.securityParentInterface.clone());
            }
            String[] ids = this.getChildPropertyIDs();
            for (int i = 0; i < ids.length; ++i) {
                ConceptPropertyInterface property = this.getChildProperty(ids[i]);
                if (property == null) continue;
                concept.addProperty((ConceptPropertyInterface)((ConceptPropertyBase)property).clone());
            }
            concept.setChanged(this.hasChanged());
            return concept;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append((Object)this.name).append(this.childPropertyInterfaces).append((Object)this.inheritedInterface).append((Object)this.parentInterface).append((Object)this.securityParentInterface).toString();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Map<String, ConceptPropertyInterface> getChildPropertyInterfaces() {
        return this.childPropertyInterfaces;
    }

    @Override
    public Map<String, ConceptPropertyInterface> getParentPropertyInterfaces() {
        if (this.parentInterface == null) {
            return null;
        }
        return this.parentInterface.getPropertyInterfaces();
    }

    @Override
    public Map<String, ConceptPropertyInterface> getInheritedPropertyInterfaces() {
        if (this.inheritedInterface == null) {
            return null;
        }
        return this.inheritedInterface.getPropertyInterfaces();
    }

    @Override
    public Map<String, ConceptPropertyInterface> getSecurityPropertyInterfaces() {
        if (this.securityParentInterface == null) {
            return null;
        }
        return this.securityParentInterface.getPropertyInterfaces();
    }

    @Override
    public Map<String, ConceptPropertyInterface> getPropertyInterfaces() {
        Hashtable<String, ConceptPropertyInterface> all = new Hashtable<String, ConceptPropertyInterface>();
        if (this.inheritedInterface != null) {
            all.putAll(this.inheritedInterface.getPropertyInterfaces());
        }
        if (this.parentInterface != null) {
            all.putAll(this.parentInterface.getPropertyInterfaces());
        }
        if (this.securityParentInterface != null) {
            String id = DefaultPropertyID.SECURITY.getId();
            ConceptPropertySecurity parentSecurityProperty = (ConceptPropertySecurity)this.securityParentInterface.getPropertyInterfaces().get(id);
            if (parentSecurityProperty != null) {
                all.put(id, parentSecurityProperty);
            }
        }
        all.putAll(this.childPropertyInterfaces);
        return all;
    }

    @Override
    public void setParentInterface(ConceptInterface parentInterface) {
        if (this.parentInterface == null && parentInterface != null || this.parentInterface != null && parentInterface == null || this.parentInterface != null && parentInterface != null && !this.parentInterface.equals(parentInterface)) {
            this.setChanged(true);
        }
        this.parentInterface = parentInterface;
    }

    @Override
    public ConceptInterface getParentInterface() {
        return this.parentInterface;
    }

    @Override
    public void addProperty(ConceptPropertyInterface property) {
        this.childPropertyInterfaces.put(property.getId(), property);
        this.setChanged(true);
    }

    @Override
    public ConceptInterface getInheritedInterface() {
        return this.inheritedInterface;
    }

    @Override
    public void setInheritedInterface(ConceptInterface inheritedInterface) {
        this.inheritedInterface = inheritedInterface;
    }

    @Override
    public ConceptPropertyInterface getProperty(String id) {
        return this.getPropertyInterfaces().get(id);
    }

    @Override
    public ConceptPropertyInterface getChildProperty(String id) {
        return this.getChildPropertyInterfaces().get(id);
    }

    @Override
    public ConceptPropertyInterface getParentProperty(String id) {
        if (this.parentInterface == null) {
            return null;
        }
        return this.getParentPropertyInterfaces().get(id);
    }

    @Override
    public ConceptPropertyInterface getInheritedProperty(String id) {
        if (this.inheritedInterface == null) {
            return null;
        }
        return this.getInheritedPropertyInterfaces().get(id);
    }

    @Override
    public ConceptPropertyInterface getSecurityProperty(String id) {
        if (this.securityParentInterface == null) {
            return null;
        }
        return this.getSecurityPropertyInterfaces().get(id);
    }

    @Override
    public void clearChanged() {
        this.setChanged(false);
    }

    @Override
    public String[] getChildPropertyIDs() {
        return Concept.getSortedPropertyIDs(this.childPropertyInterfaces);
    }

    @Override
    public String[] getPropertyIDs() {
        return Concept.getSortedPropertyIDs(this.getPropertyInterfaces());
    }

    private static final String[] getSortedPropertyIDs(Map<String, ?> map) {
        Set<String> keySet = map.keySet();
        ArrayList<String> list = new ArrayList<String>(keySet);
        Comparator<String> comparator = new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                int twoOrder;
                String one = o1;
                String two = o2;
                int oneOrder = DefaultPropertyID.findDefaultPropertyOrder(one);
                if (oneOrder != (twoOrder = DefaultPropertyID.findDefaultPropertyOrder(two))) {
                    return oneOrder - twoOrder;
                }
                return one.compareTo(two);
            }
        };
        Collections.sort(list, comparator);
        return list.toArray(new String[list.size()]);
    }

    @Override
    public int getDepth() {
        int depth = 0;
        ConceptInterface follow = this;
        while (follow != null) {
            follow = follow.getParentInterface();
            ++depth;
        }
        return depth;
    }

    @Override
    public String[] getPath() {
        int depth = this.getDepth();
        String[] retval = new String[depth];
        int d = 0;
        ConceptInterface follow = this;
        while (follow != null) {
            retval[depth - d - 1] = follow.getName();
            follow = follow.getParentInterface();
            ++d;
        }
        return retval;
    }

    @Override
    public boolean matches(String[] path) {
        if (path.length == 0) {
            return false;
        }
        int depth = 0;
        for (ConceptInterface follow = this; follow != null && depth < path.length; follow = follow.getParentInterface(), ++depth) {
            if (follow.getName().equals(path[path.length - depth - 1])) continue;
            return false;
        }
        return depth == path.length;
    }

    @Override
    public String getLocalizedProperty(String propertyName, String locale) {
        ConceptPropertyInterface property = this.getProperty(propertyName);
        if (property != null && property.getType().equals(ConceptPropertyType.LOCALIZED_STRING)) {
            LocalizedStringSettings locString = (LocalizedStringSettings)property.getValue();
            return locString.getString(locale);
        }
        return null;
    }

    @Override
    public void addLocalizedProperty(String propertyName, String locale, String value) {
        LocalizedStringSettings locStringSettings;
        ConceptPropertyInterface property = this.getChildProperty(propertyName);
        if (property == null || property != null && !property.getType().equals(ConceptPropertyType.LOCALIZED_STRING) || property.getValue() == null) {
            locStringSettings = new LocalizedStringSettings();
            property = new ConceptPropertyLocalizedString(propertyName, locStringSettings);
            this.addProperty(property);
        } else {
            locStringSettings = (LocalizedStringSettings)property.getValue();
        }
        locStringSettings.setLocaleString(locale, value);
    }

    @Override
    public String[] getUsedLocale() {
        Hashtable<String, String> locales = new Hashtable<String, String>();
        String[] propertyNames = this.getChildPropertyIDs();
        for (int i = 0; i < propertyNames.length; ++i) {
            ConceptPropertyInterface property = this.getProperty(propertyNames[i]);
            if (!property.getType().equals(ConceptPropertyType.LOCALIZED_STRING)) continue;
            LocalizedStringSettings locString = (LocalizedStringSettings)property.getValue();
            String[] locs = locString.getLocales();
            for (int j = 0; j < locs.length; ++j) {
                locales.put(locs[j], "");
            }
        }
        Set keySet = locales.keySet();
        return keySet.toArray(new String[keySet.size()]);
    }

    @Override
    public ConceptPropertyInterface[] getLocalizedProperties(String locale) {
        ArrayList<ConceptPropertyInterface> propertiesList = new ArrayList<ConceptPropertyInterface>();
        String[] propertyNames = this.getChildPropertyIDs();
        for (int i = 0; i < propertyNames.length; ++i) {
            LocalizedStringSettings locString;
            ConceptPropertyInterface property = this.getProperty(propertyNames[i]);
            if (!property.getType().equals(ConceptPropertyType.LOCALIZED_STRING) || (locString = (LocalizedStringSettings)property.getValue()).getString(locale) == null) continue;
            propertiesList.add(property);
        }
        return propertiesList.toArray(new ConceptPropertyInterface[propertiesList.size()]);
    }

    @Override
    public void setName(String locale, String name) {
        this.addLocalizedProperty(DefaultPropertyID.NAME.getId(), locale, name);
    }

    @Override
    public String getName(String locale) {
        LocalizedStringSettings locString;
        ConceptPropertyInterface property = this.getProperty(DefaultPropertyID.NAME.getId());
        if (property != null && property.getType().equals(ConceptPropertyType.LOCALIZED_STRING) && (locString = (LocalizedStringSettings)property.getValue()) != null) {
            return locString.getString(locale);
        }
        return null;
    }

    @Override
    public void setDescription(String locale, String description) {
        this.addLocalizedProperty(DefaultPropertyID.DESCRIPTION.getId(), locale, description);
    }

    @Override
    public String getDescription(String locale) {
        LocalizedStringSettings locString;
        ConceptPropertyInterface property = this.getProperty(DefaultPropertyID.DESCRIPTION.getId());
        if (property != null && property.getType().equals(ConceptPropertyType.LOCALIZED_STRING) && (locString = (LocalizedStringSettings)property.getValue()) != null) {
            return locString.getString(locale);
        }
        return null;
    }

    @Override
    public void clearChildProperties() {
        this.getChildPropertyInterfaces().clear();
        this.setChanged(true);
    }

    @Override
    public void removeChildProperty(ConceptPropertyInterface property) {
        this.childPropertyInterfaces.remove(property.getId());
        this.setChanged(true);
    }

    @Override
    public boolean hasInheritedConcept() {
        return this.inheritedInterface != null;
    }

    @Override
    public boolean hasParentConcept() {
        return this.parentInterface != null;
    }

    @Override
    public boolean hasSecurityParentConcept() {
        return this.securityParentInterface != null;
    }

    @Override
    public ConceptInterface getSecurityParentInterface() {
        return this.securityParentInterface;
    }

    @Override
    public void setSecurityParentInterface(ConceptInterface securityParentInterface) {
        this.securityParentInterface = securityParentInterface;
    }

    @Override
    public ConceptInterface findFirstParentConcept() {
        ConceptInterface concept = this;
        ConceptInterface parent = this.parentInterface;
        for (int levels = 0; concept != null && parent == null && concept.getInheritedInterface() != null && levels < 20; concept = concept.getInheritedInterface(), ++levels) {
            parent = concept.getParentInterface();
        }
        return parent;
    }
}

