/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pms.schema.concept.types.datatype;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.pentaho.pms.messages.Messages;

public class DataTypeSettings {
    public static final int DATA_TYPE_UNKNOWN = 0;
    public static final int DATA_TYPE_STRING = 1;
    public static final int DATA_TYPE_DATE = 2;
    public static final int DATA_TYPE_BOOLEAN = 3;
    public static final int DATA_TYPE_NUMERIC = 4;
    public static final int DATA_TYPE_BINARY = 5;
    public static final int DATA_TYPE_IMAGE = 6;
    public static final int DATA_TYPE_URL = 7;
    public static final DataTypeSettings UNKNOWN = new DataTypeSettings(0);
    public static final DataTypeSettings STRING = new DataTypeSettings(1);
    public static final DataTypeSettings DATE = new DataTypeSettings(2);
    public static final DataTypeSettings BOOLEAN = new DataTypeSettings(3);
    public static final DataTypeSettings NUMERIC = new DataTypeSettings(4);
    public static final DataTypeSettings BINARY = new DataTypeSettings(5);
    public static final DataTypeSettings IMAGE = new DataTypeSettings(6);
    public static final DataTypeSettings URL = new DataTypeSettings(7);
    private static final String[] typeCodes = new String[]{"Unknown", "String", "Date", "Boolean", "Numeric", "Binary", "Image", "URL"};
    private static final String[] typeDescriptions = new String[]{Messages.getString("DataTypeSettings.USER_UNKNOWN_DESC"), Messages.getString("DataTypeSettings.USER_STRING_DESC"), Messages.getString("DataTypeSettings.USER_DATE_DESC"), Messages.getString("DataTypeSettings.USER_BOOLEAN_DESC"), Messages.getString("DataTypeSettings.USER_NUMERIC_DESC"), Messages.getString("DataTypeSettings.USER_BINARY_DESC"), Messages.getString("DataTypeSettings.USER_IMAGE_DESC"), Messages.getString("DataTypeSettings.USER_URL_DESC")};
    public static final DataTypeSettings[] types = new DataTypeSettings[]{UNKNOWN, STRING, DATE, BOOLEAN, NUMERIC, BINARY, IMAGE, URL};
    private static final String SEPARATOR = ",";
    private int type;
    private int length;
    private int precision;

    public DataTypeSettings(int type, int length, int precision) {
        this.type = type;
        this.length = length;
        this.precision = precision;
    }

    public DataTypeSettings(int type) {
        this.type = type;
        this.length = -1;
        this.precision = -1;
    }

    public String toString() {
        return this.getCode() + SEPARATOR + this.length + SEPARATOR + this.precision;
    }

    public static DataTypeSettings fromString(String value) {
        String[] pieces = value.split(SEPARATOR);
        if (pieces.length > 0) {
            DataTypeSettings settings = DataTypeSettings.getType(pieces[0]);
            if (pieces.length > 1) {
                settings.setLength(Integer.parseInt(pieces[1]));
                if (pieces.length > 2) {
                    settings.setPrecision(Integer.parseInt(pieces[2]));
                }
            }
            return settings;
        }
        return null;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getCode() {
        return typeCodes[this.type];
    }

    public String getDescription() {
        return typeDescriptions[this.type];
    }

    public static DataTypeSettings getType(String description) {
        int i;
        for (i = 0; i < typeDescriptions.length; ++i) {
            if (!typeDescriptions[i].equalsIgnoreCase(description)) continue;
            return types[i];
        }
        for (i = 0; i < typeCodes.length; ++i) {
            if (!typeCodes[i].equalsIgnoreCase(description)) continue;
            return types[i];
        }
        return UNKNOWN;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DataTypeSettings)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        DataTypeSettings rhs = (DataTypeSettings)obj;
        return new EqualsBuilder().append(this.type, rhs.type).append(this.length, rhs.length).append(this.precision, rhs.precision).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(23, 227).append(this.type).append(this.length).append(this.precision).toHashCode();
    }

    public static String[] getTypeDescriptions() {
        return (String[])typeDescriptions.clone();
    }
}

