/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pms.schema.concept.types.date;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.pentaho.pms.schema.concept.types.ConceptPropertyBase;
import org.pentaho.pms.schema.concept.types.ConceptPropertyType;

public class ConceptPropertyDate
extends ConceptPropertyBase
implements Cloneable {
    private Date value;

    public ConceptPropertyDate(String name, Date value) {
        this(name, value, false);
    }

    public ConceptPropertyDate(String name, Date value, boolean required) {
        super(name, required);
        this.value = value;
    }

    public String toString() {
        if (this.value == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd'T'HH:mm:ss");
        return sdf.format(this.value);
    }

    public Object clone() throws CloneNotSupportedException {
        ConceptPropertyDate rtn = (ConceptPropertyDate)super.clone();
        if (this.value != null) {
            rtn.value = new Date(this.value.getTime());
        }
        return rtn;
    }

    public ConceptPropertyType getType() {
        return ConceptPropertyType.DATE;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = (Date)value;
    }

    public boolean equals(Object obj) {
        return this.value.equals(obj);
    }

    public int hashCode() {
        return this.value.hashCode();
    }
}

