/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pms.schema.olap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.pentaho.di.core.changed.ChangedFlag;
import org.pentaho.pms.schema.BusinessTable;
import org.pentaho.pms.schema.olap.OlapDimensionUsage;
import org.pentaho.pms.schema.olap.OlapMeasure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OlapCube
extends ChangedFlag
implements Cloneable {
    private String name;
    private BusinessTable businessTable;
    private List<OlapDimensionUsage> olapDimensionUsages = new ArrayList<OlapDimensionUsage>();
    private List<OlapMeasure> olapMeasures = new ArrayList<OlapMeasure>();

    public Object clone() {
        int i;
        OlapCube olapCube = new OlapCube();
        olapCube.name = this.name;
        for (i = 0; i < this.olapDimensionUsages.size(); ++i) {
            OlapDimensionUsage usage = this.olapDimensionUsages.get(i);
            olapCube.olapDimensionUsages.add((OlapDimensionUsage)usage.clone());
        }
        for (i = 0; i < this.olapMeasures.size(); ++i) {
            OlapMeasure measure = this.olapMeasures.get(i);
            olapCube.olapMeasures.add((OlapMeasure)measure.clone());
        }
        if (this.businessTable != null) {
            olapCube.businessTable = this.businessTable;
        }
        return olapCube;
    }

    public boolean equals(Object obj) {
        return this.name.equals(((OlapCube)obj).getName());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BusinessTable getBusinessTable() {
        return this.businessTable;
    }

    public void setBusinessTable(BusinessTable businessTable) {
        this.businessTable = businessTable;
    }

    public List<OlapDimensionUsage> getOlapDimensionUsages() {
        return this.olapDimensionUsages;
    }

    public void setOlapDimensionUsages(List<OlapDimensionUsage> olapDimensionUsages) {
        this.olapDimensionUsages = olapDimensionUsages;
    }

    public List<OlapMeasure> getOlapMeasures() {
        return this.olapMeasures;
    }

    public void setOlapMeasures(List<OlapMeasure> olapMeasures) {
        this.olapMeasures = olapMeasures;
    }

    public OlapMeasure findOlapMeasure(String measureName) {
        for (int i = 0; i < this.olapMeasures.size(); ++i) {
            OlapMeasure olapMeasure = this.olapMeasures.get(i);
            if (!olapMeasure.getName().equals(measureName)) continue;
            return olapMeasure;
        }
        return null;
    }

    public String[] getUnusedColumnNames(String locale) {
        String[] allColumnNames = this.businessTable.getColumnNames(locale);
        ArrayList<String> names = new ArrayList<String>();
        names.addAll(Arrays.asList(allColumnNames));
        for (int i = names.size() - 1; i >= 0; --i) {
            String columnName = (String)names.get(i);
            for (int m = 0; m < this.olapMeasures.size(); ++m) {
                OlapMeasure measure = this.olapMeasures.get(m);
                if (!measure.getBusinessColumn().getDisplayName(locale).equals(columnName)) continue;
                names.remove(i);
            }
        }
        return names.toArray(new String[names.size()]);
    }
}

