/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pms.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class Const {
    public static final String CR = System.getProperty("line.separator");
    public static final int NOTE_MARGIN = 5;
    public static final String META_EDITOR_LOG_FILE = "pentaho-meta";
    public static final String XML_ENCODING = "UTF-8";

    public static final int toInt(String str, int def) {
        int retval;
        try {
            retval = Integer.parseInt(str);
        }
        catch (Exception e) {
            retval = def;
        }
        return retval;
    }

    public static final long toLong(String str, long def) {
        long retval;
        try {
            retval = Long.parseLong(str);
        }
        catch (Exception e) {
            retval = def;
        }
        return retval;
    }

    public static final double toDouble(String str, double def) {
        double retval;
        try {
            retval = Double.parseDouble(str);
        }
        catch (Exception e) {
            retval = def;
        }
        return retval;
    }

    public static final Date toDate(String str, Date def) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS", Locale.US);
        try {
            return df.parse(str);
        }
        catch (ParseException e) {
            return def;
        }
    }

    public static final String rtrim(String str) {
        int max;
        for (max = str.length(); max > 0 && Const.isSpace(str.charAt(max - 1)); --max) {
        }
        return str.substring(0, max);
    }

    public static final boolean isSpace(char c) {
        return c == ' ' || c == '\t' || c == '\r' || c == '\n';
    }

    public static final String ltrim(String str) {
        int from;
        for (from = 0; from < str.length() && Const.isSpace(str.charAt(from)); ++from) {
        }
        return str.substring(from);
    }

    public static final String trim(String str) {
        int min;
        int max = str.length() - 1;
        for (min = 0; min <= max && Const.isSpace(str.charAt(min)); ++min) {
        }
        while (max >= 0 && Const.isSpace(str.charAt(max))) {
            --max;
        }
        if (max < min) {
            return "";
        }
        return str.substring(min, max + 1);
    }

    public static final String rightPad(String ret, int limit) {
        if (ret == null) {
            return Const.rightPad(new StringBuffer(), limit);
        }
        return Const.rightPad(new StringBuffer(ret), limit);
    }

    public static final String rightPad(StringBuffer ret, int limit) {
        int len = ret.length();
        if (len > limit) {
            ret.setLength(limit);
        } else {
            for (int l = len; l < limit; ++l) {
                ret.append(' ');
            }
        }
        return ret.toString();
    }

    public static final String replace(String string, String repl, String with) {
        StringBuffer str = new StringBuffer(string);
        for (int i = str.length() - 1; i >= 0; --i) {
            if (!str.substring(i).startsWith(repl)) continue;
            str.delete(i, i + repl.length());
            str.insert(i, with);
        }
        return str.toString();
    }

    public static void repl(StringBuffer str, String code, String repl) {
        int clength = code.length();
        for (int i = str.length() - clength; i >= 0; --i) {
            String look = str.substring(i, i + clength);
            if (!look.equalsIgnoreCase(code)) continue;
            str.replace(i, i + clength, repl);
        }
    }

    public static final int nrSpacesBefore(String field) {
        int nr;
        int len = field.length();
        for (nr = 0; nr < len && field.charAt(nr) == ' '; ++nr) {
        }
        return nr;
    }

    public static final int nrSpacesAfter(String field) {
        int nr;
        int len = field.length();
        for (nr = 0; nr < len && field.charAt(field.length() - 1 - nr) == ' '; ++nr) {
        }
        return nr;
    }

    public static final boolean onlySpaces(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (Const.isSpace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static final String NVL(String source, String def) {
        if (source == null || source.length() == 0) {
            return def;
        }
        return source;
    }

    public static final int indexOfString(String lookup, String[] array) {
        if (array == null) {
            return -1;
        }
        if (lookup == null) {
            return -1;
        }
        for (int i = 0; i < array.length; ++i) {
            if (!lookup.equalsIgnoreCase(array[i])) continue;
            return i;
        }
        return -1;
    }

    public static final int indexOfString(String lookup, List list) {
        if (list == null) {
            return -1;
        }
        for (int i = 0; i < list.size(); ++i) {
            String compare = (String)list.get(i);
            if (!lookup.equalsIgnoreCase(compare)) continue;
            return i;
        }
        return -1;
    }

    public static final String[] sortStrings(String[] input) {
        Arrays.sort(input);
        return input;
    }

    public static final String[] splitString(String string, String separator) {
        ArrayList<String> list = new ArrayList<String>();
        if (string == null || string.length() == 0) {
            return new String[0];
        }
        int sepLen = separator.length();
        int from = 0;
        int end = string.length() - sepLen + 1;
        for (int i = from; i < end; i += sepLen) {
            if (!string.substring(i, i + sepLen).equalsIgnoreCase(separator)) continue;
            list.add(Const.NVL(string.substring(from, i), ""));
            from = i + sepLen;
        }
        if (from + sepLen <= string.length()) {
            list.add(Const.NVL(string.substring(from, string.length()), ""));
        }
        return list.toArray(new String[list.size()]);
    }

    public static final String[] splitString(String string, char separator) {
        ArrayList<String> list = new ArrayList<String>();
        if (string == null || string.length() == 0) {
            return new String[0];
        }
        int from = 0;
        int end = string.length();
        for (int i = from; i < end; ++i) {
            if (string.charAt(i) != separator) continue;
            list.add(Const.NVL(string.substring(from, i), ""));
            from = i + 1;
        }
        if (from + 1 <= string.length()) {
            list.add(Const.NVL(string.substring(from, string.length()), ""));
        }
        return list.toArray(new String[list.size()]);
    }

    public static final String[] splitPath(String path, String separator) {
        int from;
        if (path == null || path.length() == 0 || path.equals(separator)) {
            return new String[0];
        }
        int sepLen = separator.length();
        int nr_separators = 0;
        int n = from = path.startsWith(separator) ? sepLen : 0;
        if (from != 0) {
            ++nr_separators;
        }
        for (int i = from; i < path.length(); i += sepLen) {
            if (!path.substring(i, i + sepLen).equalsIgnoreCase(separator)) continue;
            ++nr_separators;
        }
        String[] spath = new String[nr_separators];
        int nr = 0;
        for (int i = from; i < path.length(); i += sepLen) {
            if (!path.substring(i, i + sepLen).equalsIgnoreCase(separator)) continue;
            spath[nr] = path.substring(from, i);
            ++nr;
            from = i + sepLen;
        }
        if (nr < spath.length) {
            spath[nr] = path.substring(from);
        }
        if (spath.length == 0 && path.length() > 0) {
            spath = new String[]{path};
        }
        return spath;
    }

    public static final String[] getDistinctStrings(String[] strings) {
        if (strings == null) {
            return null;
        }
        if (strings.length == 0) {
            return new String[0];
        }
        String[] sorted = Const.sortStrings(strings);
        ArrayList<String> result = new ArrayList<String>();
        String previous = "";
        for (int i = 0; i < sorted.length; ++i) {
            if (!sorted[i].equalsIgnoreCase(previous)) {
                result.add(sorted[i]);
            }
            previous = sorted[i];
        }
        return result.toArray(new String[result.size()]);
    }

    public static final String getStackTracker(Throwable e) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        e.printStackTrace(printWriter);
        String string = stringWriter.getBuffer().toString();
        try {
            stringWriter.close();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return string;
    }

    public static final boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static final boolean isEmpty(StringBuffer string) {
        return string == null || string.length() == 0;
    }

    public static final String toID(String name) {
        name = Const.replace(name, " ", "_");
        name = Const.replace(name, ".", "_");
        name = Const.replace(name, ",", "_");
        name = Const.replace(name, ":", "_");
        name = Const.replace(name, "(", "_");
        name = Const.replace(name, ")", "_");
        name = Const.replace(name, "{", "_");
        name = Const.replace(name, "}", "_");
        name = Const.replace(name, "[", "_");
        name = Const.replace(name, "]", "_");
        name = Const.replace(name, "*", "_TIMES_");
        name = Const.replace(name, "/", "_DIVIDED_BY_");
        name = Const.replace(name, "+", "_PLUS_");
        name = Const.replace(name, "-", "_HYPHEN_");
        name = Const.replace(name, "____", "_");
        name = Const.replace(name, "___", "_");
        name = Const.replace(name, "__", "_");
        name = Const.replace(name, "\"", "");
        name = Const.replace(name, "`", "");
        name = Const.replace(name, "'", "");
        name = name.replaceAll("[^a-zA-Z_0-9]", "_");
        return name;
    }
}

