/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.marketplace;

import java.io.IOException;
import java.io.OutputStream;
import org.pentaho.marketplace.MarketplaceService;
import org.pentaho.platform.api.engine.IParameterProvider;
import org.pentaho.platform.api.engine.IServiceManager;
import org.pentaho.platform.api.engine.ServiceException;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import pt.webdetails.cpf.SimpleContentGenerator;
import pt.webdetails.cpf.annotations.AccessLevel;
import pt.webdetails.cpf.annotations.Exposed;
import pt.webdetails.cpf.annotations.OutputType;

public class MarketplaceContentGenerator
extends SimpleContentGenerator {
    private static final long serialVersionUID = 1L;
    public static final String ENCODING = "utf-8";
    private static final String MIME_JSON = "application/json";

    protected MarketplaceService getMarketplaceService() throws ServiceException {
        return (MarketplaceService)((IServiceManager)PentahoSystem.get(IServiceManager.class)).getServiceBean("xml", "MarketplaceService");
    }

    @Exposed(accessLevel=AccessLevel.PUBLIC)
    @OutputType(value="application/json")
    public void getpluginsjson(OutputStream out) throws IOException {
        try {
            out.write(this.getMarketplaceService().getPluginsJson().getBytes(ENCODING));
        }
        catch (ServiceException ex) {
            this.logger.error((Object)ex);
        }
    }

    @Exposed(accessLevel=AccessLevel.PUBLIC)
    @OutputType(value="application/json")
    public void installpluginjson(OutputStream out) throws IOException {
        try {
            IParameterProvider requestParams = (IParameterProvider)this.parameterProviders.get("request");
            String pluginId = requestParams.getStringParameter("pluginId", null);
            String versionId = requestParams.getStringParameter("versionId", null);
            out.write(this.getMarketplaceService().installPluginJson(pluginId, versionId).getBytes(ENCODING));
        }
        catch (ServiceException ex) {
            this.logger.error((Object)ex);
        }
    }

    @Exposed(accessLevel=AccessLevel.PUBLIC)
    @OutputType(value="application/json")
    public void uninstallpluginjson(OutputStream out) throws IOException {
        try {
            IParameterProvider requestParams = (IParameterProvider)this.parameterProviders.get("request");
            String pluginId = requestParams.getStringParameter("pluginId", null);
            out.write(this.getMarketplaceService().uninstallPluginJson(pluginId).getBytes(ENCODING));
        }
        catch (ServiceException ex) {
            this.logger.error((Object)ex);
        }
    }
}

