/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.marketplace;

import flexjson.JSONSerializer;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.parameters.NamedParams;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobMeta;
import org.pentaho.marketplace.Plugin;
import org.pentaho.marketplace.PluginVersion;
import org.pentaho.marketplace.StatusMessage;
import org.pentaho.marketplace.Util;
import org.pentaho.marketplace.VersionData;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPluginManager;
import org.pentaho.platform.api.engine.IPluginResourceLoader;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.security.SecurityHelper;
import org.pentaho.platform.util.VersionHelper;
import org.pentaho.platform.util.VersionInfo;
import org.pentaho.platform.util.web.HttpUtil;
import org.pentaho.telemetry.BaPluginTelemetry;
import org.pentaho.telemetry.TelemetryHelper;
import org.springframework.security.Authentication;
import org.springframework.security.GrantedAuthority;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarketplaceService {
    private Log logger = LogFactory.getLog(MarketplaceService.class);
    public static final String PLUGIN_NAME = "marketplace";
    public static final String UNAUTORIZED_ACCESS = "Unauthorized Access. Your Pentaho roles do not allow you to make changes to plugins.";
    private XPath xpath = XPathFactory.newInstance().newXPath();

    public List<Plugin> getPlugins() {
        if (!this.hasMarketplacePermission()) {
            // empty if block
        }
        List<Plugin> plugins = this.loadPluginsFromSite();
        List<String> installedPlugins = this.getInstalledPluginsFromFileSystem();
        if (installedPlugins.size() > 0) {
            HashMap<String, Plugin> marketplacePlugins = new HashMap<String, Plugin>();
            if (plugins != null) {
                for (Plugin plugin : plugins) {
                    marketplacePlugins.put(plugin.getId(), plugin);
                }
            }
            for (String installedPlugin : installedPlugins) {
                Plugin plugin = (Plugin)marketplacePlugins.get(installedPlugin);
                if (plugin == null) continue;
                plugin.setInstalled(true);
                this.discoverInstalledVersion(plugin);
            }
        }
        return plugins;
    }

    protected List<String> getInstalledPluginsFromPluginManager() {
        IPluginManager pluginManager = (IPluginManager)PentahoSystem.get(IPluginManager.class, (IPentahoSession)PentahoSessionHolder.getSession());
        return pluginManager.getRegisteredPlugins();
    }

    private List<String> getInstalledPluginsFromFileSystem() {
        ArrayList<String> plugins = new ArrayList<String>();
        File systemDir = new File(PentahoSystem.getApplicationContext().getSolutionPath("system/"));
        String[] dirs = systemDir.list((FilenameFilter)DirectoryFileFilter.INSTANCE);
        for (int i = 0; i < dirs.length; ++i) {
            String dir = dirs[i];
            if (!new File(systemDir.getAbsolutePath() + File.separator + dir + File.separator + "plugin.xml").isFile()) continue;
            plugins.add(dir);
        }
        return plugins;
    }

    private void closeClassLoader(String pluginId) {
        IPluginManager pluginManager = (IPluginManager)PentahoSystem.get(IPluginManager.class, (IPentahoSession)PentahoSessionHolder.getSession());
        ClassLoader cl = pluginManager.getClassLoader(pluginId);
        if (cl != null && cl instanceof URLClassLoader) {
            Util.closeURLClassLoader((URLClassLoader)cl);
        }
    }

    public StatusMessage uninstallPlugin(String id) throws MarketplaceSecurityException {
        if (!this.hasMarketplacePermission()) {
            throw new MarketplaceSecurityException();
        }
        List<Plugin> plugins = this.getPlugins();
        Plugin toUninstall = null;
        for (Plugin plugin : plugins) {
            if (!plugin.getId().equals(id)) continue;
            toUninstall = plugin;
        }
        if (toUninstall == null) {
            return new StatusMessage("NO_PLUGIN", "Plugin Not Found");
        }
        this.closeClassLoader(toUninstall.getId());
        String versionBranch = toUninstall.getInstalledBranch();
        String jobPath = PentahoSystem.getApplicationContext().getSolutionPath("system/marketplace/processes/uninstall_plugin.kjb");
        try {
            JobMeta jobMeta = new JobMeta(jobPath, null);
            Job job = new Job(null, jobMeta);
            File file = new File(PentahoSystem.getApplicationContext().getSolutionPath("system/plugin-cache/backups"));
            file.mkdirs();
            job.getJobMeta().setParameterValue("uninstallLocation", PentahoSystem.getApplicationContext().getSolutionPath("system/" + toUninstall.getId()));
            job.getJobMeta().setParameterValue("uninstallBackup", PentahoSystem.getApplicationContext().getSolutionPath("system/plugin-cache/backups/" + toUninstall.getId() + "_" + new Date().getTime()));
            if (versionBranch != null && versionBranch.length() > 0 && toUninstall.getVersionByBranch(versionBranch).getSamplesDownloadUrl() != null) {
                job.getJobMeta().setParameterValue("samplesUninstallLocation", PentahoSystem.getApplicationContext().getSolutionPath("plugin-samples/" + toUninstall.getId()));
                job.getJobMeta().setParameterValue("samplesUninstallBackup", PentahoSystem.getApplicationContext().getSolutionPath("system/plugin-cache/backups/" + toUninstall.getId() + "_samples_" + new Date().getTime()));
            }
            job.copyParametersFrom((NamedParams)job.getJobMeta());
            job.activateParameters();
            job.start();
            job.waitUntilFinished();
            Result result = job.getResult();
            if (result == null || result.getNrErrors() > 0L) {
                return new StatusMessage("FAIL", "Failed to execute uninstall, see log for details.");
            }
        }
        catch (KettleException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        BaPluginTelemetry telemetryEvent = new BaPluginTelemetry(PLUGIN_NAME);
        HashMap<String, String> extraInfo = new HashMap<String, String>(1);
        extraInfo.put("uninstalledPlugin", toUninstall.getId());
        extraInfo.put("uninstalledPluginVersion", toUninstall.getInstalledVersion());
        extraInfo.put("uninstalledPluginBranch", toUninstall.getInstalledBranch());
        telemetryEvent.sendTelemetryRequest(TelemetryHelper.TelemetryEventType.REMOVAL, extraInfo);
        return new StatusMessage("PLUGIN_UNINSTALLED", toUninstall.getName() + " was successfully uninstalled.  Please restart your BI Server.");
    }

    public StatusMessage installPlugin(String id, String versionBranch) throws MarketplaceSecurityException {
        PluginVersion v;
        if (!this.hasMarketplacePermission()) {
            throw new MarketplaceSecurityException();
        }
        List<Plugin> plugins = this.getPlugins();
        Plugin toInstall = null;
        for (Plugin plugin : plugins) {
            if (!plugin.getId().equals(id)) continue;
            toInstall = plugin;
        }
        if (toInstall == null) {
            return new StatusMessage("NO_PLUGIN", "Plugin Not Found");
        }
        if (toInstall.getId().indexOf(".") >= 0) {
            return new StatusMessage("NO_PLUGIN", "Plugin ID contains an illegal character");
        }
        this.closeClassLoader(toInstall.getId());
        if (versionBranch != null && versionBranch.length() > 0) {
            v = toInstall.getVersionByBranch(versionBranch);
            if (v == null) {
                return new StatusMessage("NO_PLUGIN", "Plugin version not found");
            }
        } else {
            return new StatusMessage("FAIL", "Version " + versionBranch + " not found for plugin " + id + ", see log for details.");
        }
        String downloadUrl = v.getDownloadUrl();
        String samplesDownloadUrl = v.getSamplesDownloadUrl();
        String availableVersion = v.getVersion();
        String jobPath = PentahoSystem.getApplicationContext().getSolutionPath("system/marketplace/processes/download_and_install_plugin.kjb");
        try {
            JobMeta jobMeta = new JobMeta(jobPath, null);
            Job job = new Job(null, jobMeta);
            File file = new File(PentahoSystem.getApplicationContext().getSolutionPath("system/plugin-cache/downloads"));
            file.mkdirs();
            file = new File(PentahoSystem.getApplicationContext().getSolutionPath("system/plugin-cache/backups"));
            file.mkdirs();
            file = new File(PentahoSystem.getApplicationContext().getSolutionPath("system/plugin-cache/staging"));
            file.mkdirs();
            job.getJobMeta().setParameterValue("downloadUrl", downloadUrl);
            if (toInstall.getVersionByBranch(versionBranch).getSamplesDownloadUrl() != null) {
                job.getJobMeta().setParameterValue("samplesDownloadUrl", samplesDownloadUrl);
                job.getJobMeta().setParameterValue("samplesDir", PentahoSystem.getApplicationContext().getSolutionPath("plugin-samples"));
                job.getJobMeta().setParameterValue("samplesTargetDestination", PentahoSystem.getApplicationContext().getSolutionPath("plugin-samples/" + toInstall.getId()));
                job.getJobMeta().setParameterValue("samplesTargetBackup", PentahoSystem.getApplicationContext().getSolutionPath("system/plugin-cache/backups/" + toInstall.getId() + "_samples_" + new Date().getTime()));
                job.getJobMeta().setParameterValue("samplesDownloadDestination", PentahoSystem.getApplicationContext().getSolutionPath("system/plugin-cache/downloads/" + toInstall.getId() + "-samples-" + availableVersion + ".zip"));
                job.getJobMeta().setParameterValue("samplesStagingDestination", PentahoSystem.getApplicationContext().getSolutionPath("system/plugin-cache/staging_samples"));
                job.getJobMeta().setParameterValue("samplesStagingDestinationAndDir", PentahoSystem.getApplicationContext().getSolutionPath("system/plugin-cache/staging_samples/" + toInstall.getId()));
            }
            job.getJobMeta().setParameterValue("downloadDestination", PentahoSystem.getApplicationContext().getSolutionPath("system/plugin-cache/downloads/" + toInstall.getId() + "-" + availableVersion + ".zip"));
            job.getJobMeta().setParameterValue("stagingDestination", PentahoSystem.getApplicationContext().getSolutionPath("system/plugin-cache/staging"));
            job.getJobMeta().setParameterValue("stagingDestinationAndDir", PentahoSystem.getApplicationContext().getSolutionPath("system/plugin-cache/staging/" + toInstall.getId()));
            job.getJobMeta().setParameterValue("targetDestination", PentahoSystem.getApplicationContext().getSolutionPath("system/" + toInstall.getId()));
            job.getJobMeta().setParameterValue("targetBackup", PentahoSystem.getApplicationContext().getSolutionPath("system/plugin-cache/backups/" + toInstall.getId() + "_" + new Date().getTime()));
            job.copyParametersFrom((NamedParams)job.getJobMeta());
            job.activateParameters();
            job.start();
            job.waitUntilFinished();
            Result result = job.getResult();
            if (result == null || result.getNrErrors() > 0L) {
                return new StatusMessage("FAIL", "Failed to execute install, see log for details.");
            }
        }
        catch (KettleException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        BaPluginTelemetry telemetryEvent = new BaPluginTelemetry(PLUGIN_NAME);
        HashMap<String, String> extraInfo = new HashMap<String, String>(1);
        extraInfo.put("installedPlugin", toInstall.getId());
        extraInfo.put("installedVersion", availableVersion);
        extraInfo.put("installedBranch", versionBranch);
        telemetryEvent.sendTelemetryRequest(TelemetryHelper.TelemetryEventType.INSTALLATION, extraInfo);
        return new StatusMessage("PLUGIN_INSTALLED", toInstall.getName() + " was successfully installed.  Please restart your BI Server. \n" + toInstall.getInstallationNotes());
    }

    public String installPluginJson(String pluginId, String versionBranch) {
        try {
            StatusMessage msg = this.installPlugin(pluginId, versionBranch);
            JSONSerializer serializer = new JSONSerializer();
            String json = serializer.deepSerialize((Object)msg);
            return json;
        }
        catch (MarketplaceSecurityException e) {
            this.logger.debug((Object)e.getMessage(), (Throwable)e);
            return this.createJsonMessage(UNAUTORIZED_ACCESS, "ERROR_0002_UNAUTHORIZED_ACCESS");
        }
    }

    public String uninstallPluginJson(String pluginId) {
        try {
            StatusMessage msg = this.uninstallPlugin(pluginId);
            JSONSerializer serializer = new JSONSerializer();
            String json = serializer.deepSerialize((Object)msg);
            return json;
        }
        catch (MarketplaceSecurityException e) {
            this.logger.debug((Object)e.getMessage(), (Throwable)e);
            return this.createJsonMessage(UNAUTORIZED_ACCESS, "ERROR_0002_UNAUTHORIZED_ACCESS");
        }
    }

    public String getPluginsJson() {
        List<Plugin> pluginArray = this.getPlugins();
        JSONSerializer serializer = new JSONSerializer();
        String json = serializer.deepSerialize(pluginArray);
        return json;
    }

    protected boolean hasMarketplacePermission() {
        String[] roleArr;
        Authentication auth = SecurityHelper.getAuthentication((IPentahoSession)PentahoSessionHolder.getSession(), (boolean)true);
        IPluginResourceLoader resLoader = (IPluginResourceLoader)PentahoSystem.get(IPluginResourceLoader.class, null);
        String roles = null;
        String users = null;
        try {
            roles = resLoader.getPluginSetting(this.getClass(), "settings/marketplace-roles");
            users = resLoader.getPluginSetting(this.getClass(), "settings/marketplace-users");
        }
        catch (Exception e) {
            this.logger.debug((Object)"Error getting data access plugin settings", (Throwable)e);
        }
        if (roles == null) {
            roles = "Admin";
        }
        for (String role : roleArr = roles.split(",")) {
            for (GrantedAuthority userRole : auth.getAuthorities()) {
                if (role == null || !role.trim().equals(userRole.getAuthority())) continue;
                return true;
            }
        }
        if (users != null) {
            String[] userArr;
            for (String user : userArr = users.split(",")) {
                if (user == null || !user.trim().equals(auth.getName())) continue;
                return true;
            }
        }
        return false;
    }

    protected StatusMessage createMessage(String message, String code) {
        StatusMessage msg = new StatusMessage();
        msg.setCode(code);
        msg.setMessage(message);
        return msg;
    }

    protected String createJsonMessage(String message, String code) {
        StatusMessage msg = this.createMessage(message, code);
        JSONSerializer serializer = new JSONSerializer();
        String json = serializer.deepSerialize((Object)msg);
        return json;
    }

    protected boolean withinParentVersion(PluginVersion pv) {
        VersionInfo versionInfo = VersionHelper.getVersionInfo(PentahoSystem.class);
        String v = versionInfo.getVersionNumber();
        return new VersionData(v).within(new VersionData(pv.getMinParentVersion()), new VersionData(pv.getMaxParentVersion()));
    }

    protected String getMarketplaceSiteContent() {
        IPluginResourceLoader resLoader = (IPluginResourceLoader)PentahoSystem.get(IPluginResourceLoader.class, null);
        String site = null;
        try {
            site = resLoader.getPluginSetting(this.getClass(), "settings/marketplace-site");
        }
        catch (Exception e) {
            this.logger.debug((Object)"Error getting data access plugin settings", (Throwable)e);
        }
        if (site == null || "".equals(site)) {
            site = "https://raw.github.com/pentaho/marketplace-metadata/master/marketplace.xml";
        }
        return HttpUtil.getURLContent((String)site);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String discoverInstalledVersion(Plugin plugin) {
        block18: {
            String string;
            String versionPath = PentahoSystem.getApplicationContext().getSolutionPath("system/" + plugin.getId() + "/version.xml");
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            InputStreamReader reader = null;
            try {
                File file = new File(versionPath);
                if (!file.exists()) {
                    String string2 = "Unknown";
                    return string2;
                }
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document dom = db.parse(new InputSource(reader = new FileReader(versionPath)));
                NodeList versionElements = dom.getElementsByTagName("version");
                if (versionElements.getLength() < 1) break block18;
                Element versionElement = (Element)versionElements.item(0);
                plugin.setInstalledBuildId(versionElement.getAttribute("buildId"));
                plugin.setInstalledBranch(versionElement.getAttribute("branch"));
                plugin.setInstalledVersion(versionElement.getTextContent());
                string = versionElement.getTextContent();
            }
            catch (Exception e) {
                e.printStackTrace();
                break block18;
            }
            finally {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (Exception e) {}
            }
            return string;
        }
        return "Unknown";
    }

    protected List<Plugin> loadPluginsFromSite() {
        String content = this.getMarketplaceSiteContent();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document dom = db.parse(new InputSource(new StringReader(content)));
            NodeList plugins = dom.getElementsByTagName("market_entry");
            ArrayList<Plugin> pluginList = new ArrayList<Plugin>();
            for (int i = 0; i < plugins.getLength(); ++i) {
                NodeList availableScreenshots;
                Element element = (Element)plugins.item(i);
                String type = this.getElementChildValue(element, "type");
                if (!"Platform".equals(type)) continue;
                Plugin plugin = new Plugin();
                plugin.setId(this.getElementChildValue(element, "id"));
                plugin.setName(this.getElementChildValue(element, "name"));
                plugin.setDescription(this.getElementChildValue(element, "description"));
                plugin.setCompany(this.getElementChildValue(element, "author"));
                plugin.setCompanyUrl(this.getElementChildValue(element, "author_url"));
                plugin.setCompanyLogo(this.getElementChildValue(element, "author_logo"));
                plugin.setImg(this.getElementChildValue(element, "img"));
                plugin.setSmallImg(this.getElementChildValue(element, "small_img"));
                plugin.setLearnMoreUrl(this.getElementChildValue(element, "documentation_url"));
                plugin.setInstallationNotes(this.getElementChildValue(element, "installation_notes"));
                plugin.setLicense(this.getElementChildValue(element, "license"));
                plugin.setDependencies(this.getElementChildValue(element, "dependencies"));
                NodeList availableVersions = (NodeList)this.xpath.evaluate("versions/version", element, XPathConstants.NODESET);
                if (availableVersions.getLength() > 0) {
                    ArrayList<PluginVersion> versions = new ArrayList<PluginVersion>();
                    for (int j = 0; j < availableVersions.getLength(); ++j) {
                        Element versionElement = (Element)availableVersions.item(j);
                        PluginVersion pv = new PluginVersion(this.getElementChildValue(versionElement, "branch"), this.getElementChildValue(versionElement, "name"), this.getElementChildValue(versionElement, "version"), this.getElementChildValue(versionElement, "package_url"), this.getElementChildValue(versionElement, "samples_url"), this.getElementChildValue(versionElement, "description"), this.getElementChildValue(versionElement, "changelog"), this.getElementChildValue(versionElement, "build_id"), this.getElementChildValue(versionElement, "releaseDate"), this.getElementChildValue(versionElement, "min_parent_version"), this.getElementChildValue(versionElement, "max_parent_version"));
                        if (!this.withinParentVersion(pv)) continue;
                        versions.add(pv);
                    }
                    plugin.setVersions(versions);
                }
                if ((availableScreenshots = (NodeList)this.xpath.evaluate("screenshots/screenshot", element, XPathConstants.NODESET)).getLength() > 0) {
                    String[] screenshots = new String[availableScreenshots.getLength()];
                    for (int j = 0; j < availableScreenshots.getLength(); ++j) {
                        Element screenshotElement = (Element)availableScreenshots.item(j);
                        screenshots[j] = screenshotElement.getTextContent();
                    }
                    plugin.setScreenshots(screenshots);
                }
                if (plugin.getVersions() == null || plugin.getVersions().size() <= 0) continue;
                pluginList.add(plugin);
            }
            return pluginList;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected String getElementChildValue(Element element, String child) {
        NodeList list = element.getElementsByTagName(child);
        if (list.getLength() >= 1) {
            return list.item(0).getTextContent();
        }
        return null;
    }

    public static class MarketplaceSecurityException
    extends Exception {
        private static final long serialVersionUID = -1852471739131561628L;
    }
}

